/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
@LoginAs(user="admin")
public class TestAddWorkflowTransition
extends BaseJiraFuncTest {
    private static final String WORKFLOW_NAME = "Test Workflow";
    private static final String STEP_NAME_OPEN = "Open";
    private static final String STEP_NAME_AND = "SpecialChar&";
    private static final String STEP_NAME_LESSTHAN = "SpecialChar<";
    private static final String STEP_NAME_QUOTE = "SpecialChar\"";
    private static final String TRANSITION_NAME_AND = "To&";
    private static final String TRANSITION_NAME_LESSTHAN = "To<";
    private static final String TRANSITION_NAME_QUOTE = "To\"";
    private static final String ISSUE_STATUS_VALUE_ID = "opsbar-transitions_more";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestAddWorkflowTransition.xml");
    }

    @Test
    public void testAddWorkflowTransitionSpecialCharacters() {
        this.administration.workflows().goTo().workflowSteps(WORKFLOW_NAME).add(STEP_NAME_AND, null).add(STEP_NAME_LESSTHAN, null).add(STEP_NAME_QUOTE, null).addTransition(STEP_NAME_OPEN, TRANSITION_NAME_AND, null, STEP_NAME_AND, null).addTransition(STEP_NAME_AND, TRANSITION_NAME_LESSTHAN, null, STEP_NAME_LESSTHAN, null).addTransition(STEP_NAME_LESSTHAN, TRANSITION_NAME_QUOTE, null, STEP_NAME_QUOTE, null);
        this.backdoor.workflowSchemes().createScheme(new WorkflowSchemeData().setName("New Workflow Scheme").setDescription("Test workflow scheme.").setMapping("1", WORKFLOW_NAME));
        this.administration.project().associateWorkflowScheme("homosapien", "New Workflow Scheme");
        this.navigation.issue().createIssue("homosapien", "Bug", "Test Special Characters");
        this.workflowUtil.clickAction("action_id_11");
        this.workflowUtil.clickAction("action_id_21");
        this.workflowUtil.clickAction("action_id_31");
        this.assertCurrentIssueIsResolved();
    }

    private void transitionCurrentIssueTo(String transitionName) {
        this.navigation.clickLinkWithExactText(transitionName);
    }

    private void assertCurrentIssueIsResolved() {
        this.textAssertions.assertTextPresent(this.locator.id(ISSUE_STATUS_VALUE_ID), "Resolved");
    }
}

