/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.WorkflowSchemes;
import com.atlassian.jira.functest.framework.admin.ViewWorkflows;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@LoginAs(user="admin")
public class TestExcludeResolutionOnTransitions
extends BaseJiraFuncTest {
    private static final String WORKFLOW_NAME = "Exclude Resolution Workflow";
    private static final String WORKFLOW_DESC = "A workflow where we will exclude resolutions.";
    private static final String OPEN_STEP_NAME = "Open";
    private static final String CLOSED_STEP_NAME = "Closed Step";
    private static final String BULK_TRANSITION_ELEMENT_NAME = "wftransition";
    public static final String ACTION_CLOSE_ISSUE = "action_id_11";
    @Inject
    private WorkflowSchemes workflowSchemes;
    @Inject
    private BulkOperations bulkOperations;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Test
    @Restore(value="blankWithOldDefault.xml")
    public void testAddExcludeAttribute() {
        this._testCreateWorkflowWithResolutionExcludes();
        this._testExcludeResolutionsSingleIssue();
        this._testExcludeResolutionBulkTransition();
    }

    private void _testExcludeResolutionsSingleIssue() {
        this.navigation.issue().createIssue("homosapien", "Bug", "Test Issue");
        this.workflowUtil.clickAction(ACTION_CLOSE_ISSUE);
        List<String> extraOptions = Collections.emptyList();
        this.assertExcludedOptions(extraOptions);
        this.tester.selectOption("resolution", "Fixed");
        this.tester.submit();
    }

    private void _testCreateWorkflowWithResolutionExcludes() {
        this.tester.assertTextNotPresent(WORKFLOW_NAME);
        ViewWorkflows workflows = this.administration.workflows();
        workflows.goTo().addWorkflow(WORKFLOW_NAME, WORKFLOW_DESC).goTo();
        this.tester.assertTextPresent(WORKFLOW_NAME);
        this.assertTransitionNameNotPresent(CLOSED_STEP_NAME);
        workflows.goTo().workflowSteps(WORKFLOW_NAME).add(CLOSED_STEP_NAME, "Closed");
        this.tester.assertTextPresent(CLOSED_STEP_NAME);
        this.assertTransitionNameNotPresent("Close Issue");
        workflows.goTo().workflowSteps(WORKFLOW_NAME).addTransition(OPEN_STEP_NAME, "Close Issue", "Close issue", CLOSED_STEP_NAME, "Resolve Issue Screen");
        this.tester.assertTextPresent("Close Issue");
        this.assertTransitionNameNotPresent("Reopen Issue");
        workflows.goTo().workflowSteps(WORKFLOW_NAME).addTransition(CLOSED_STEP_NAME, "Reopen Issue", "Reopen issue", OPEN_STEP_NAME, "Workflow Screen");
        this.tester.assertTextPresent("Reopen Issue");
        this.backdoor.workflow().setTransitionProperty(WORKFLOW_NAME, false, 11L, "jira.field.resolution.exclude", "2,4");
        this.administration.project().addProject("homosapien", "HSP", "admin");
        this.enableWorkflow();
    }

    private void assertTransitionNameNotPresent(String transitionName) {
        MatcherAssert.assertThat((Object)this.tester.getDialog().getElement("content").getTextContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)transitionName)));
    }

    private void enableWorkflow() {
        this.workflowSchemes.addWorkFlowScheme("New Workflow Scheme", "Test workflow scheme.");
        this.backdoor.workflowSchemes().assignScheme(10000L, "Bug", WORKFLOW_NAME);
        this.administration.project().associateWorkflowScheme("homosapien", "New Workflow Scheme");
        this.workflowSchemes.waitForSuccessfulWorkflowSchemeMigration("homosapien", "New Workflow Scheme");
    }

    private void assertExcludedOptions(Collection<String> extraOptions) {
        ArrayList<String> options = new ArrayList<String>(extraOptions);
        options.add("1");
        options.add("3");
        options.add("5");
        this.tester.assertOptionValuesEqual("resolution", options.toArray(new String[0]));
        this.tester.assertRadioOptionValueNotPresent("resolution", "Won't Fix");
        this.tester.assertRadioOptionValueNotPresent("resolution", "Incomplete");
    }

    private void _testExcludeResolutionBulkTransition() {
        ArrayList<String> issueKeys = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            issueKeys.add(this.navigation.issue().createIssue("homosapien", "Bug", "Test Issue " + i));
        }
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeChooseIssuesAll();
        this.bulkOperations.chooseOperationExecuteWorfklowTransition();
        this.navigation.workflows().assertStepOperationDetails();
        this.tester.getDialog().setWorkingForm("bulk-transition-details");
        String[] options = this.tester.getDialog().getForm().getOptions(BULK_TRANSITION_ELEMENT_NAME);
        String[] optionValues = this.tester.getDialog().getForm().getOptionValues(BULK_TRANSITION_ELEMENT_NAME);
        if (options == null || options.length == 0) {
            Assert.fail((String)"No options for 'wftransition' element.");
        }
        String closeTransitionOptionValue = null;
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            if (!option.contains("Close Issue")) continue;
            closeTransitionOptionValue = optionValues[i];
            break;
        }
        if (closeTransitionOptionValue == null) {
            Assert.fail((String)"Could not find option for Close Issue transition");
        }
        this.navigation.workflows().chooseWorkflowAction(closeTransitionOptionValue);
        ArrayList<String> extraOptions = new ArrayList<String>();
        extraOptions.add("-1");
        this.assertExcludedOptions(extraOptions);
        this.tester.selectOption("resolution", "Fixed");
        this.navigation.clickOnNext();
        this.tester.assertTableRowsEqual("updatedfields", 1, (String[][])new String[][]{{"Resolution", "Fixed"}});
        this.navigation.clickOnNext();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        for (String issueKey : issueKeys) {
            this.navigation.issue().gotoIssue(issueKey);
            this.textAssertions.assertTextPresent(new IdLocator(this.tester, "resolution-val"), "Fixed");
        }
    }
}

