/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Screens;
import com.atlassian.jira.functest.framework.WorkflowSchemes;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import java.util.List;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SCHEMES, Category.WORKFLOW})
@Restore(value="blankWithOldDefault.xml")
@LoginAs(user="admin")
public class TestWorkFlowSchemes
extends BaseJiraFuncTest {
    private static final String TAB_NAME = "Tab for Testing";
    private static final String CUSTOM_FIELD_NAME = "Approval Rating";
    private static final String CUSTOM_FIELD_NAME_TWO = "Animal";
    private static final String UNSHOWN_STATUS = "Unshown Status";
    String customFieldId;
    String customFieldId2;
    @Inject
    private Screens screens;
    @Inject
    private WorkflowSchemes workflowSchemes;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private WorkflowUtil workflowUtil;

    @Test
    public void testWorkFlowSchemes() {
        this.customFieldId = this.createCustomField(CUSTOM_FIELD_NAME, CustomFields.builtInCustomFieldKey("textfield"));
        this.customFieldId2 = this.createCustomField(CUSTOM_FIELD_NAME_TWO, CustomFields.builtInCustomFieldKey("textfield"));
        String issueKey = this.backdoor.issues().createIssue("HSP", "test 1", "admin", "Minor", "Bug").key();
        this.screens.addScreen("Test Workflow Screen", "");
        this.backdoor.screens().addFieldToScreen("Test Workflow Screen", CUSTOM_FIELD_NAME);
        this.backdoor.screens().addTabToScreen("Test Workflow Screen", TAB_NAME);
        this.backdoor.screens().addFieldToScreenTab("Test Workflow Screen", TAB_NAME, CUSTOM_FIELD_NAME_TWO, "");
        this.workflowAddScheme();
        this.workflowAddDuplicateScheme();
        this.workflowAddInvalidScheme();
        this.workflowAddWorkflow();
        this.workflowCopyWorkflow();
        this.workflowAddDuplicateWorkflow();
        this.workflowAddInvalidWorkflow();
        this.workflowAddLinkedStatus();
        this.workflowAddDuplicateLinkedStatus();
        this.workflowAddInvalidLinkedStatus();
        this.workflowAddStep();
        this.workflowAddTransition();
        this.workflowAddDuplicateTransition();
        this.workflowAddInvalidTransition();
        this.workflowAssignWorkflowSchemeToIssueType();
        this.workflowAssociateWorkflowSchemeToProject();
        this.workflowPerformAction(issueKey);
        this._testNoActiveStatus();
        this.administration.project().associateWorkflowScheme("homosapien", "Default");
        this.workflowSchemes.waitForSuccessfulWorkflowSchemeMigration("homosapien", "Default");
        this.workflowDeleteScheme();
        this.workflowDeleteTransition();
        this.workflowDeleteStep();
        this.workflowDeleteLinkedStatus();
        this.workflowDeleteWorkflow();
        this.navigation.issue().deleteIssue(issueKey);
        this.screens.removeAllRemainingFieldScreens();
        this.removeAllCustomFields();
    }

    @Test
    public void archivedProjectIsMarkedAsArchived() {
        this.backdoor.restoreBlankInstance();
        this.workflowAddScheme();
        this.workflowAssociateWorkflowSchemeToProject();
        this.backdoor.project().archiveProject("HSP");
        this.navigation.gotoPage("secure/admin/ViewWorkflowSchemes.jspa");
        this.tester.assertTextPresent("homosapien (archived)");
        this.tester.assertLinkNotPresentWithText("homosapien");
    }

    @Test
    public void testJRADEV7692() {
        this.administration.restoreBlankInstance();
        this.workflowAddScheme();
        this.workflowAddWorkflow();
        this.workflowCopyWorkflow();
        this.workflowAssignWorkflowSchemeToIssueType();
        this.workflowSchemes.addWorkFlowScheme("Scheme7692", "Another tests workflow scheme.");
    }

    private void _testNoActiveStatus() {
        this.logger.log((Object)"Workflow Schemes: Non-active status should not be displayed if it's not active");
        this.administration.statuses().addLinkedStatus(UNSHOWN_STATUS, "This status should not be shown in the issue navigator");
        this.tester.assertTextPresent(UNSHOWN_STATUS);
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Approved");
        this.tester.assertTextNotPresent(UNSHOWN_STATUS);
        this.administration.statuses().deleteLinkedStatus("10001");
        this.tester.assertTextNotPresent(UNSHOWN_STATUS);
    }

    public void workflowAddScheme() {
        this.logger.log((Object)"Workflow Schemes: Create a workflow scheme");
        this.workflowSchemes.addWorkFlowScheme("New Workflow Scheme", "New workflow scheme for testing");
        this.tester.assertTextPresent("Workflow schemes");
    }

    public void workflowDeleteScheme() {
        this.logger.log((Object)"Workflow Schemes: Delete a workflow scheme");
        this.workflowSchemes.deleteWorkFlowScheme("10000");
        this.tester.assertTextPresent("Workflow schemes");
        this.tester.assertTextNotPresent("New Workflow Scheme");
    }

    public void workflowAddDuplicateScheme() {
        this.logger.log((Object)"Workflow Schemes: Add a workflow scheme with a duplicate name");
        this.workflowSchemes.addWorkFlowScheme("New Workflow Scheme", "");
        this.tester.assertTextPresent("Add Workflow Scheme");
        this.tester.assertTextPresent("A Scheme with this name already exists.");
    }

    public void workflowAddInvalidScheme() {
        this.logger.log((Object)"Workflow Schemes: Add a workflow scheme with a invalid name");
        this.workflowSchemes.addWorkFlowScheme("", "");
        this.tester.assertTextPresent("Add Workflow Scheme");
        this.tester.assertTextPresent("Please specify a name for this Scheme.");
    }

    public void workflowAddWorkflow() {
        this.logger.log((Object)"Workflow Schemes: Create a workflow");
        this.administration.workflows().goTo().addWorkflow("New Workflow For Testing", "New workflow for testing").goTo();
        this.tester.assertTextPresent("New Workflow For Testing");
    }

    public void workflowDeleteWorkflow() {
        this.logger.log((Object)"Workflow Schemes: Delete a workflow");
        this.administration.workflows().goTo().delete("New Workflow For Testing");
        this.tester.assertTextNotPresent("New Workflow For Testing");
        this.administration.workflows().goTo().delete("Copied Workflow");
        this.tester.assertTextNotPresent("Copied Workflow");
    }

    public void workflowCopyWorkflow() {
        this.logger.log((Object)"Workflow Schemes: Copy a workflow");
        this.administration.workflows().goTo().copyWorkflow("jira", "Copied Workflow", "Workflow copied from JIRA default");
        this.tester.assertTextPresent("Copied Workflow");
    }

    public void workflowAddDuplicateWorkflow() {
        this.logger.log((Object)"Workflow Schemes: Add a workflow with a duplicate name");
        this.administration.workflows().goTo().addWorkflow("Copied Workflow", "");
        this.tester.assertTextPresent("A workflow with this name already exists.");
    }

    public void workflowAddInvalidWorkflow() {
        this.logger.log((Object)"Workflow Schemes: Add a workflow with an invalid name");
        this.administration.workflows().goTo().addWorkflow("", "");
        this.tester.assertTextPresent("You must specify a workflow name.");
    }

    public void workflowAddLinkedStatus() {
        this.logger.log((Object)"Workflow Schemes: Add a linked status");
        this.administration.statuses().addLinkedStatus("Approved", "The resolution of this issue has been approved");
        this.tester.assertTextPresent("Approved");
    }

    public void workflowDeleteLinkedStatus() {
        this.logger.log((Object)"Workflow Schemes: Delete a linked status");
        this.administration.statuses().deleteLinkedStatus("10000");
        this.tester.assertTextNotPresent("Approved");
    }

    public void workflowAddDuplicateLinkedStatus() {
        this.logger.log((Object)"Workflow Scheme: Add a linked status with a duplicate name");
        this.administration.statuses().addLinkedStatus("Approved", "");
        this.tester.assertTextPresent("A status with that name already exists, please enter a different name.");
    }

    public void workflowAddInvalidLinkedStatus() {
        this.logger.log((Object)"Workflow Scheme: Add a linked status with a invalid name");
        this.administration.statuses().addLinkedStatus("", "");
        this.tester.assertTextPresent("You must specify a name.");
    }

    public void workflowAddStep() {
        this.logger.log((Object)"Workflow Scheme: Add a step");
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").add("Approved", "Approved");
        this.tester.assertLinkPresentWithText("Approved");
        this.tester.assertFormElementNotPresent("stepName");
        this.tester.assertFormElementNotPresent("stepStatus");
    }

    public void workflowDeleteStep() {
        this.logger.log((Object)"Workflow Scheme: delete a step");
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").deleteStep("Approved");
        this.tester.assertLinkNotPresent("Approved");
        this.tester.assertFormElementPresent("stepName");
        this.tester.assertFormElementPresent("stepStatus");
    }

    public void workflowAddTransition() {
        this.logger.log((Object)"Workflow Scheme: Add a transition to a step");
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").addTransition("Resolved", "Approve Issue", "", "Approved", "Test Workflow Screen");
        this.tester.assertLinkPresentWithText("Approve Issue");
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").addTransition("Approved", "Reopen Issue", "", "Open", "Workflow Screen");
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").addTransition("Approved", "Close Issue", "", "Closed", null);
    }

    public void workflowDeleteTransition() {
        this.logger.log((Object)"Workflow Scheme: Delete a transition from a Step");
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").deleteTransition("Resolved", "Approve Issue");
        this.tester.assertLinkNotPresentWithText("Approve Issue");
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").deleteTransition("Approved", "Reopen Issue");
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").deleteTransition("Approved", "Close Issue");
    }

    public void workflowAddDuplicateTransition() {
        this.logger.log((Object)"Workflow Scheme: Add a transition with a duplicate nane");
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").addTransition("Approved", "Reopen Issue", "", "Open", null);
        this.tester.assertTextPresent("Add Workflow Transition");
        this.tester.assertTextPresent("Transition with this name already exists for Approved step.");
    }

    public void workflowAddInvalidTransition() {
        this.logger.log((Object)"Workflow Scheme: Add a transition with an invalid name");
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").addTransition("Approved", "", "", "Open", null);
        this.tester.assertTextPresent("Add Workflow Transition");
        this.tester.assertTextPresent("You must enter a valid name.");
    }

    public void workflowAssignWorkflowSchemeToIssueType() {
        this.logger.log((Object)"Workflow Scheme: Assign a workflow scheme to an issue type");
        this.backdoor.workflowSchemes().assignScheme(10000L, "Bug", "Copied Workflow");
    }

    public void workflowAssociateWorkflowSchemeToProject() {
        this.logger.log((Object)"Workflow Scheme; Associate a workflow scheme with a project");
        this.administration.project().associateWorkflowScheme("homosapien", "New Workflow Scheme");
        this.workflowSchemes.waitForSuccessfulWorkflowSchemeMigration("homosapien", "New Workflow Scheme");
    }

    public void workflowPerformAction(String issueKey) {
        this.logger.log((Object)"Perform workflow actions using the customised workflow/workflow scheme");
        this.navigation.issue().viewIssue(issueKey);
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.tester.assertTextPresent("Resolved");
        this.workflowUtil.clickAction("action_id_711");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.setFormElement("customfield_" + this.customFieldId, "High");
        this.tester.clickLinkWithText(TAB_NAME);
        this.tester.setFormElement("customfield_" + this.customFieldId2, "Whale");
        this.tester.submit("Transition");
        this.tester.assertTextPresent("Approved");
        this.workflowUtil.clickAction("action_id_721");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.tester.assertTextPresent("Open");
    }

    private void removeAllCustomFields() {
        List customFields = this.backdoor.customFields().getCustomFields();
        customFields.forEach(cfResponse -> this.backdoor.customFields().deleteCustomField(cfResponse.id));
    }

    private String createCustomField(String name, String type) {
        String cfId = this.backdoor.customFields().createCustomField(name, "", type, null);
        this.backdoor.screens().addFieldToScreen("Default Screen", name);
        return CustomFields.numericCfId(cfId);
    }
}

