/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import java.util.Arrays;
import java.util.HashMap;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PERMISSIONS, Category.WORKFLOW})
@Restore(value="WorkflowBasedPermissions.zip")
@LoginAs(user="admin")
public class TestWorkflowBasedPermissions
extends BaseJiraFuncTest {
    private static final String TRANSITION_ID_STATUS_APPROVED_ACTION_START_PROGRESS = "action_id_31";
    private static final String TRANSITION_ID_STATUS_OPEN_ACTION_APPROVED = "action_id_21";
    private static final String TRANSITION_ID_SUBTASK_STATUS_OPEN_ACTION_APPROVED = "action_id_11";
    private static final String TRANSITION_ID_STATUS_IN_PROGRESS_ACTION_RESOLVE = "action_id_51";
    @Inject
    private BulkOperations bulkOperations;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUp() {
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
        this.backdoor.darkFeatures().enableForSite("jira.no.frother.userpicker.field");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.administration.attachments().enable();
    }

    @After
    public void tearDown() {
        this.backdoor.darkFeatures().disableForSite("jira.no.frother.userpicker.field");
    }

    @Test
    public void testWorkflowPermissions() {
        this._testSingleIssuePermissions();
        this._testBulkEdit();
    }

    private void _testSingleIssuePermissions() {
        this.logger.log((Object)"Check that non-overridden 'assignables' are correct");
        this.navigation.login("test", "test");
        this.createIssueStep1("Test Project", "Bug");
        this.tester.assertFormElementPresent("assignee");
        this.tester.assertOptionValuesEqual("assignee", new String[]{"-1", "assignable", "devadmin", "developer", "test"});
        this.logger.log((Object)"Test that the 'assignables' list is overridden when creating issues");
        this.createIssueStep1("Test Project", "ChangeRequest");
        this.tester.assertOptionValuesEqual("assignee", new String[]{"-1", "assignable", "devadmin", "developer"});
        this.logger.log((Object)"Testing normal permissions on Open state");
        this.assertIssuePermissions("test", "TP-8", new boolean[]{true, true, true, true, true, true, true, true, true, true});
        this.assertIssuePermissions("test", "TP-9", new boolean[]{true, true, true, true, true, false, true, true, true, true});
        this.navigation.issue().gotoIssue("TP-8");
        this.tester.clickLink("assign-issue");
        this.tester.assertOptionValuesEqual("assignee", new String[]{"-1", "developer", "test", "assignable", "devadmin", "developer", "test"});
        this.logger.log((Object)"Set the assignee to 'developer'");
        this.tester.selectOption("assignee", "Joe Developer");
        this.tester.submit();
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Assignee:", "Joe Developer");
        this.logger.log((Object)"Progress workflow to 'Approved' status");
        this.workflowUtil.clickAction(TRANSITION_ID_STATUS_OPEN_ACTION_APPROVED);
        this.tester.setFormElement("summary", "Approved CR");
        this.tester.submit();
        this.assertIssuePermissions("test", "TP-8", new boolean[]{true, false, true, true, true, true, true, false, false, false});
        this.assertIssuePermissions("user1", "TP-8", new boolean[]{true, false, false, true, false, true, false, false, false, false});
        this.assertIssuePermissions("qa", "TP-8", new boolean[]{true, false, false, true, false, true, false, false, false, false});
        this.assertIssuePermissions("assignable", "TP-8", new boolean[]{true, true, true, true, false, true, false, false, false, false});
        this.assertIssuePermissions("manager", "TP-8", new boolean[]{true, false, false, true, false, true, false, false, true, false});
        this.assertIssuePermissions("devadmin", "TP-8", new boolean[]{true, false, true, true, false, true, false, false, false, true});
        this.assertIssuePermissions("test", "TP-9", new boolean[]{true, false, false, true, false, false, false, false, false, false});
        this.navigation.issue().gotoIssue("TP-8");
        this.logger.log((Object)"Check that permissions are back to normal in 'In Progress' state");
        this.workflowUtil.clickAction(TRANSITION_ID_STATUS_APPROVED_ACTION_START_PROGRESS);
        this.tester.setFormElement("summary", "In Progress CR");
        this.tester.submit();
        this.assertIssuePermissions("test", "TP-8", new boolean[]{true, true, true, true, true, true, true, true, true, true});
        this.navigation.issue().gotoIssue("TP-8");
        this.logger.log((Object)"Check that the correct users are assignable in 'In Progress' state");
        this.tester.clickLink("assign-issue");
        this.tester.assertOptionValuesEqual("assignee", new String[]{"-1", "developer", "test", "assignable", "devadmin", "developer", "test"});
        this.navigation.issue().gotoIssue("TP-10");
        this.logger.log((Object)"Check that a subtask in the 'Approved' state becomes invisible");
        this.workflowUtil.clickAction(TRANSITION_ID_SUBTASK_STATUS_OPEN_ACTION_APPROVED);
        this.tester.setFormElement("summary", "hideme");
        this.tester.submit();
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.issue().gotoIssue("TP-8");
        this.logger.log((Object)"Check that on 'Resolve' transition screen, we see subset of assignees permissible for Resolved issues");
        this.workflowUtil.clickAction(TRANSITION_ID_STATUS_IN_PROGRESS_ACTION_RESOLVE);
        this.tester.assertOptionValuesEqual("assignee", new String[]{"-1", "developer", "developer"});
        this.logger.log((Object)"Check that we can resolve the issue");
        this.tester.setFormElement("summary", "Resolved CR");
        this.tester.selectOption("assignee", "Joe Developer");
        this.tester.setFormElement("customfield_10000", "developer");
        this.tester.submit();
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Assignee:", "Joe Developer");
        this.logger.log((Object)"Check that in the 'Resolved' state, editing is limited to developer (custom field val), and permissions are otherwise normal");
        this.assertIssuePermissions("test", "TP-8", new boolean[]{true, true, true, true, true, true, true, false, true, true});
        this.assertIssuePermissions("developer", "TP-8", new boolean[]{true, true, true, true, true, true, false, true, true, true});
        this.assertIssuePermissions("qa", "TP-8", new boolean[]{true, false, true, true, true, true, false, false, false, false});
        this.assertIssuePermissions("assignable", "TP-8", new boolean[]{true, true, true, true, true, true, false, false, true, true});
        this.assertIssuePermissions("manager", "TP-8", new boolean[]{true, false, true, true, true, true, false, false, true, false});
        this.assertIssuePermissions("devadmin", "TP-8", new boolean[]{true, true, true, true, true, true, false, false, true, true});
    }

    private void assertIssuePermissions(String user, String key, boolean[] permissions) {
        this.navigation.login(user, user);
        this.navigation.issue().gotoIssue(key);
        this.logger.log((Object)("Testing " + key + " permissions for " + user));
        if (permissions[0]) {
            if (permissions[1]) {
                this.tester.assertLinkPresent("assign-issue");
            } else {
                this.tester.assertLinkNotPresent("assign-issue");
            }
            if (permissions[2]) {
                this.tester.assertLinkPresent("attach-file");
            } else {
                this.tester.assertLinkNotPresent("attach-file");
            }
            if (permissions[3]) {
                this.tester.assertLinkPresent("clone-issue");
            } else {
                this.tester.assertLinkNotPresent("clone-issue");
            }
            if (permissions[4]) {
                this.tester.assertLinkPresent("comment-issue");
                this.tester.assertLinkPresent("footer-comment-button");
            } else {
                this.tester.assertLinkNotPresent("comment-issue");
                this.tester.assertLinkNotPresent("footer-comment-button");
            }
            if (permissions[5]) {
                this.tester.assertLinkPresent("create-subtask");
            } else {
                this.tester.assertLinkNotPresent("create-subtask");
            }
            if (permissions[6]) {
                this.tester.assertLinkPresent("delete-issue");
            } else {
                this.tester.assertLinkNotPresent("delete-issue");
            }
            if (permissions[7]) {
                this.tester.assertLinkPresent("edit-issue");
            } else {
                this.tester.assertLinkNotPresent("edit-issue");
            }
            if (permissions[8]) {
                this.tester.assertLinkPresent("link-issue");
            } else {
                this.tester.assertLinkNotPresent("link-issue");
            }
            if (permissions[9]) {
                if (this.tester.getDialog().isLinkPresent("move-subtask")) {
                    this.tester.assertLinkPresent("move-subtask");
                } else {
                    this.tester.assertLinkPresent("move-issue");
                }
            } else {
                this.tester.assertLinkNotPresent("move-issue");
                this.tester.assertLinkNotPresent("move-subtask");
            }
        } else {
            this.tester.assertTextPresent("Permission violation");
        }
    }

    private void _testBulkEdit() {
        this.tester.clickLink("assign-issue");
        this.tester.assertOptionValuesEqual("assignee", new String[]{"-1", "developer", "developer"});
        this.navigation.issue().gotoIssue("TP-11");
        this.tester.clickLink("assign-issue");
        this.tester.assertOptionValuesEqual("assignee", new String[]{"-1", "test", "assignable", "devadmin", "developer", "test"});
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeSelectIssues(Arrays.asList("TP-8", "TP-11"));
        this.bulkOperations.bulkChangeChooseOperationEdit();
        this.tester.assertOptionValuesEqual("assignee", new String[]{"-1", "developer", "developer"});
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("assignee", "Joe Developer");
        this.bulkOperations.bulkEditOperationDetailsSetAs(fields);
        fields = new HashMap();
        fields.put("assignee", "Joe Developer");
        this.bulkOperations.bulkEditConfirmEdit(fields);
        this.bulkOperations.bulkChangeConfirm();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().gotoIssue("TP-8");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Assignee", "Joe Developer");
        this.navigation.issue().gotoIssue("TP-11");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Assignee", "Joe Developer");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeSelectIssues(Arrays.asList("TP-11"));
        this.bulkOperations.bulkChangeChooseOperationEdit();
        this.tester.assertOptionValuesEqual("assignee", new String[]{"-1", "developer", "assignable", "devadmin", "developer"});
        fields = new HashMap();
        fields.put("assignee", "Dev-Admin");
        this.bulkOperations.bulkEditOperationDetailsSetAs(fields);
        fields = new HashMap();
        fields.put("assignee", "Dev-Admin");
        this.bulkOperations.bulkEditConfirmEdit(fields);
        this.bulkOperations.bulkChangeConfirm();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().gotoIssue("TP-11");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Assignee", "Dev-Admin");
    }

    private void createIssueStep1(String project, String issueType) {
        this.navigation.issue().goToCreateIssueForm(project, issueType);
    }
}

