/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.ViewWorkflows;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestWorkflowDesigner
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Test
    public void testWorkflowDesignerValidWorkflowName() {
        ViewWorkflows viewWorkflows = this.administration.workflows().goTo();
        String name = "UNIQUE_WORKFLOW_NAME";
        String description = "UNIQUE_WORKFLOW_DESCRIPTION";
        viewWorkflows.addWorkflow("UNIQUE_WORKFLOW_NAME", "UNIQUE_WORKFLOW_DESCRIPTION").goTo();
        viewWorkflows.launchDesigner("UNIQUE_WORKFLOW_NAME");
        this.tester.assertTextPresent("UNIQUE_WORKFLOW_NAME");
        this.tester.assertTextPresent("UNIQUE_WORKFLOW_DESCRIPTION");
    }

    @Test
    public void testWorkflowDesignerInvalidWorkflowName() {
        String name = "UNIQUE_WORKFLOW_NAME";
        this.navigation.gotoPage("secure/admin/workflows/WorkflowDesigner.jspa?wfName=UNIQUE_WORKFLOW_NAME");
        this.tester.assertTextPresent("No workflow with name 'UNIQUE_WORKFLOW_NAME' could be found.");
    }

    @Test
    public void testWorkflowDesignerNoWorkflowName() {
        this.administration.workflows().goTo();
        String name = "";
        this.navigation.gotoPage("secure/admin/workflows/WorkflowDesigner.jspa?wfName=");
        this.tester.assertTextPresent("No workflow with name '' could be found.");
    }

    @Test
    public void testWorkflowDesignerScriptTagInNameAndDescription() {
        ViewWorkflows viewWorkflows = this.administration.workflows().goTo();
        String name = "\"><script>alert('hello');</script>";
        String description = "\"><script>alert('world');</script>";
        viewWorkflows.addWorkflow("\"><script>alert('hello');</script>", "\"><script>alert('world');</script>").goTo();
        viewWorkflows.launchDesigner("\"><script>alert('hello');</script>");
        this.tester.assertTextNotPresent("\"><script>alert('hello');</script>");
        this.tester.assertTextNotPresent("\"><script>alert('world');</script>");
        this.tester.assertTextPresent("&gt;&lt;script&gt;alert(&#39;hello&#39;);&lt;/script&gt;");
        this.tester.assertTextPresent("&gt;&lt;script&gt;alert(&#39;world&#39;);&lt;/script&gt;");
    }

    @Test
    public void testOldWorkflowEditorLinksToDesigner() {
        ViewWorkflows viewWorkflows = this.administration.workflows().goTo();
        String name = "UNIQUE_WORKFLOW_NAME";
        String description = "UNIQUE_WORKFLOW_DESCRIPTION";
        viewWorkflows.addWorkflow("UNIQUE_WORKFLOW_NAME", "UNIQUE_WORKFLOW_DESCRIPTION").goTo();
        viewWorkflows.workflowSteps("UNIQUE_WORKFLOW_NAME");
        this.tester.assertLinkPresentWithText("Diagram");
        this.tester.clickLinkWithText("Diagram");
        this.tester.assertTextPresent("Workflow Designer");
        this.tester.assertTextPresent("UNIQUE_WORKFLOW_NAME");
    }
}

