/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.ProgressBar;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.backdoor.ProjectControlExt;
import com.atlassian.jira.functest.framework.backdoor.WorkflowsControlExt;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.WorkflowSchemesControl;
import com.atlassian.jira.webtests.ztests.workflow.AbstractTestWorkflowSchemeMigration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
@LoginAs(user="admin")
public class TestWorkflowMigration
extends AbstractTestWorkflowSchemeMigration {
    @Inject
    private Administration administration;
    @Inject
    private Assertions assertions;
    @Inject
    private ProgressBar progressBar;

    @Test
    @RestoreBlankInstance
    public void testDrafWorkflowRemovedWhenInactive() {
        String workflowName = "WorkflowWithDraft";
        WorkflowsControlExt workflowControl = this.getBackdoor().workflow();
        workflowControl.createWorkflow("WorkflowWithDraft");
        WorkflowSchemesControl workflowSchemesControl = this.getBackdoor().workflowSchemes();
        WorkflowSchemeData scheme = workflowSchemesControl.createScheme(new WorkflowSchemeData().setName("WorkflowWithDraft").setMapping("Bug", "WorkflowWithDraft"));
        String projectKey = "TDWC";
        String projectName = "testDrafWorkflowRemovedWhenInactive";
        ProjectControlExt projectControl = this.getBackdoor().project();
        projectControl.addProject("testDrafWorkflowRemovedWhenInactive", "TDWC", "admin");
        projectControl.setWorkflowScheme("TDWC", scheme.getId());
        workflowControl.createDraftOfWorkflow("WorkflowWithDraft");
        String targetSchemeName = "WorkflowWithDraftTarget";
        workflowSchemesControl.createScheme(new WorkflowSchemeData().setName("WorkflowWithDraftTarget").setMapping("Bug", "jira"));
        this.administration.project().associateWorkflowScheme("testDrafWorkflowRemovedWhenInactive", "WorkflowWithDraftTarget", Collections.emptyMap(), true);
        WorkflowsControlExt.Workflow workflow = workflowControl.getWorkflowDetailed("WorkflowWithDraft");
        Assert.assertFalse((String)"Workflow should no longer have a draft.", (boolean)workflow.isHasDraft());
        workflow = workflowControl.getWorkflowDetailed("Copy of WorkflowWithDraft");
        Assert.assertNotNull((String)"Workflow draft has been made its own scheme?", (Object)workflow);
        Assert.assertEquals((String)"Description should be valid.", (Object)String.format("(This copy was automatically generated from a draft, when workflow '%s' was made inactive.)", "WorkflowWithDraft"), (Object)workflow.getDescription());
    }

    @Test
    @Restore(value="WorkflowMigrationTest.xml")
    public void testWorkflowMigration() {
        this.associateScheme();
        this.assertStandardIssues("TST");
    }

    @Test
    @Restore(value="WorkflowMigrationTestBrokenHalfWay.xml")
    public void testWorkflowMigrationHalfMigratedData() {
        this.associateScheme();
        this.assertIssuesMigratedAndChangeHistory("TST");
    }

    @Test
    @Restore(value="WorkflowMigrationTestIssueWithUnupdatedIssue.xml")
    public void testWorkflowMigrationWithUnupdatedIssue() {
        this.associateScheme();
        this.assertIssuesMigratedAndChangeHistory("TST");
    }

    @Test
    @Restore(value="WorkflowMigrationTestUnchangedScheme.xml")
    public void testWorkflowMigrationWithUnupdatedWorkflowScheme() {
        this.associateScheme();
        this.assertIssuesAfterMigrationWithUnupdatedWorkflowScheme();
    }

    @Test
    @Restore(value="WorkflowMigrationTestRemovedWorkflowScheme.xml")
    public void testWorkflowMigrationWithRemovedWorkflowScheme() {
        HashMap<String, String> statusMapping = new HashMap<String, String>();
        statusMapping.put("mapping_1_1", "Custom Status 3");
        statusMapping.put("mapping_1_3", "Resolved");
        statusMapping.put("mapping_1_6", "Custom Status 4");
        statusMapping.put("mapping_1_4", "Custom Status 3");
        statusMapping.put("mapping_4_1", "Custom Status 3");
        statusMapping.put("mapping_4_3", "Resolved");
        statusMapping.put("mapping_4_6", "Custom Status 4");
        statusMapping.put("mapping_4_4", "Custom Status 3");
        statusMapping.put("mapping_2_1", "Custom Status 3");
        statusMapping.put("mapping_2_3", "Resolved");
        statusMapping.put("mapping_2_6", "Custom Status 4");
        statusMapping.put("mapping_2_4", "Custom Status 3");
        this.associateScheme(statusMapping);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Open").addTransitions("Start Progress", "Resolve Issue", "Close Issue").addHistoryItems(TestWorkflowMigration.item("Workflow", "Source Workflow 1", "jira")).assertIssue(this.getIssue("TST-1"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Open").addTransitions("Start Progress", "Resolve Issue", "Close Issue").addHistoryItems(TestWorkflowMigration.item("Workflow", "Source Workflow 1", "jira")).assertIssue(this.getIssue("TST-2"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Resolved").addTransitions("Go 4").addHistoryItems(TestWorkflowMigration.item("Workflow", "jira", "Destinatiom Workflow")).assertIssue(this.getIssue("TST-3"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 4").addTransitions("Go 3").addHistoryItems(TestWorkflowMigration.item("Workflow", "jira", "Destinatiom Workflow")).assertIssue(this.getIssue("TST-4"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 3").addTransitions("Resolve").addHistoryItems(TestWorkflowMigration.item("Workflow", "jira", "Destinatiom Workflow")).assertIssue(this.getIssue("TST-5"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 4").addTransitions("Go 3").addHistoryItems(TestWorkflowMigration.item("Workflow", "jira", "Destinatiom Workflow")).assertIssue(this.getIssue("TST-6"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 4").addTransitions("Go 3").addHistoryItems(TestWorkflowMigration.item("Workflow", "jira", "Destinatiom Workflow")).assertIssue(this.getIssue("TST-7"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Resolved").addTransitions("Go 4").addHistoryItems(TestWorkflowMigration.item("Workflow", "jira", "Destinatiom Workflow")).assertIssue(this.getIssue("TST-8"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Closed").addTransitions("Reopen Issue").addHistoryItems(TestWorkflowMigration.item("Workflow", "Source Workflow 1", "jira")).assertIssue(this.getIssue("TST-9"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 3").addTransitions("Resolve").addHistoryItems(TestWorkflowMigration.item("Workflow", "jira", "Destinatiom Workflow")).assertIssue(this.getIssue("TST-10"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 3").addTransitions("Resolve").addHistoryItems(TestWorkflowMigration.item("Workflow", "jira", "Destinatiom Workflow")).assertIssue(this.getIssue("TST-11"), false);
    }

    private void associateScheme() {
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        this.associateScheme(statusMapping);
    }

    private void associateScheme(Map<String, String> statusMapping) {
        this.administration.project().associateWorkflowScheme("Test Project", "Destination Workflow Scheme", statusMapping, true);
        this.waitForSuccessfulWorkflowSchemeMigration("Test Project", "Destination Workflow Scheme");
    }

    @Test
    @Restore(value="WorkflowMigrationHalfMigratedDataNewDestination.xml")
    public void testWorkflowMigrationHalfMigratedDataNewDestination() throws SAXException {
        this.tester.gotoPage("/secure/project/SelectProjectWorkflowScheme!default.jspa?projectId=10010");
        this.tester.assertTextNotPresent("There are currently no workflow schemes setup.");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//div[@class='aui-page-panel-main']", "Add");
        String destinationSchemeName = "Homosapien Destination Scheme";
        this.tester.selectOption("schemeId", "Homosapien Destination Scheme");
        this.tester.submit("Associate");
        this.tester.assertTextPresent("Step 2 of 3");
        this.tester.assertTextPresent("Affected issues: 4 of 8");
        this.tester.assertTextPresent("Affected issues: 8 of 16");
        this.tester.assertTextPresent("Affected issues: 2 of 8");
        this.assertMappingAndSelectOptionsForHalfMigratedDataNewDestination();
        this.tester.submit("Associate");
        this.waitForSuccessfulWorkflowSchemeMigration("homosapien", "Homosapien Destination Scheme");
        this.assertIssuesInHomosapienProjectAfterHalfMigratedDataNewDestination();
        this.checkIssuesInTestProjectAfterHalfMigratedDataNewDestination();
    }

    @Test
    @Restore(value="WorkflowMigrationTestIssueVerifier.xml")
    public void testIssueVerifier() {
        this.administration.project().associateWorkflowScheme("Test Project", "Destination Workflow Scheme", Collections.emptyMap(), false);
        this.waitForFailedMigration();
        this.assertIssueVerifierErrorMessages("TST");
    }

    @Test
    @Restore(value="WorkflowMigrationTest.xml")
    public void testMultipleActiveWorkflowErrorMessageNotPresentInEnterprise() {
        this.tester.gotoPage("secure/admin/workflows/ListWorkflows.jspa");
        this.tester.assertTextNotPresent("An error has occured during workflow activation and the result is multiple active workflows");
    }

    @Test
    @Restore(value="WorkflowMigrationTwoAdmins.xml")
    public void testMultiAdminTaskProgressFlow() {
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        this.administration.project().associateWorkflowScheme("Test Project", "Destination Workflow Scheme", statusMapping, false);
        long taskId = this.progressBar.getSubmittedTaskId();
        this.progressBar.waitForTaskAcknowledgement(taskId);
        this.tester.assertTextPresent("input type=\"submit\" name=\"Acknowledge\"");
        this.tester.assertTextNotPresent("input type=\"submit\" name=\"Done\"");
        this.progressBar.validateProgressBarUI("Acknowledge");
        this.navigation.logout();
        this.navigation.login("admin2", "admin2");
        this.navigation.gotoAdmin();
        this.tester.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep3.jspa?projectId=10000&taskId=" + taskId + "&schemeId=10001");
        this.progressBar.validateProgressBarUI("Done");
        this.tester.assertTextNotPresent("input type=\"submit\" name=\"Acknowledge\"");
        this.tester.assertTextPresent("input type=\"submit\" name=\"Done\"");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.gotoAdmin();
        this.tester.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep3.jspa?projectId=10000&taskId=" + taskId + "&schemeId=10001");
        this.tester.assertTextPresent("input type=\"submit\" name=\"Acknowledge\"");
        this.tester.assertTextNotPresent("input type=\"submit\" name=\"Done\"");
        this.progressBar.validateProgressBarUI("Acknowledge");
        this.tester.submit("Acknowledge");
        this.tester.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep3.jspa?projectId=10000&taskId=" + taskId + "&schemeId=10001");
        this.tester.assertTextPresent("The task could not be found. Perhaps it has finished and has been acknowledged?");
        this.tester.assertTextPresent("input type=\"submit\" name=\"Done\"");
    }

    @Test
    @Restore(value="WorkflowMigrationTestWithDrafts.xml")
    public void testMigrateSchemeWithDraft() {
        WorkflowSchemeData draft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("homosapien");
        this.administration.project().associateWorkflowScheme("homosapien", "Two");
        WorkflowSchemeData copiedScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound("Copy of One");
        Assert.assertNotNull((Object)copiedScheme);
        Assert.assertFalse((boolean)copiedScheme.isActive());
        Assert.assertEquals((Object)"(This copy was automatically generated from a draft, when workflow scheme 'One' was made inactive.)", (Object)copiedScheme.getDescription());
        Assert.assertEquals((Object)draft.getMappings(), (Object)copiedScheme.getMappings());
        this.administration.project().associateWorkflowScheme("monkey", "One");
        draft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("monkey");
        Assert.assertNull((Object)draft);
    }

    @Test
    @Restore(value="WorkflowMigrationTestWithDrafts.xml")
    public void testMigrateSchemeWithDraftUsedByAnotherProject() {
        this.administration.project().associateWorkflowScheme("monkey", "One");
        WorkflowSchemeData homosapienDraft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("homosapien");
        this.administration.project().associateWorkflowScheme("homosapien", "Two");
        WorkflowSchemeData copiedScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound("Copy of One");
        Assert.assertNull((Object)copiedScheme);
        WorkflowSchemeData monkeyDraft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("monkey");
        Assert.assertNotNull((Object)monkeyDraft);
        Assert.assertEquals((Object)monkeyDraft.getName(), (Object)homosapienDraft.getName());
        Assert.assertEquals((Object)monkeyDraft.getDescription(), (Object)homosapienDraft.getDescription());
        Assert.assertEquals((Object)monkeyDraft.getMappings(), (Object)homosapienDraft.getMappings());
    }

    @Test
    @Restore(value="WorkflowMigrationTestWithDrafts.xml")
    public void testMigrateSchemeWithDraftWithTheSameNameAsExistingWorkflowScheme() {
        this.backdoor.workflowSchemes().createScheme(new WorkflowSchemeData().setName("Copy of One"));
        WorkflowSchemeData draft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("homosapien");
        this.administration.project().associateWorkflowScheme("homosapien", "Two");
        WorkflowSchemeData copiedScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound("Copy 2 of One");
        Assert.assertNotNull((Object)copiedScheme);
        Assert.assertFalse((boolean)copiedScheme.isActive());
        Assert.assertEquals((Object)"(This copy was automatically generated from a draft, when workflow scheme 'One' was made inactive.)", (Object)copiedScheme.getDescription());
        Assert.assertEquals((Object)draft.getMappings(), (Object)copiedScheme.getMappings());
        this.administration.project().associateWorkflowScheme("monkey", "One");
        draft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("monkey");
        Assert.assertNull((Object)draft);
    }
}

