/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.WorkflowSchemes;
import com.atlassian.jira.functest.framework.admin.ViewWorkflows;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
@LoginAs(user="admin")
@Restore(value="TestWorkflowNameEditing.xml")
public class TestWorkflowNameEditing
extends BaseJiraFuncTest {
    @Inject
    private WorkflowSchemes workflowSchemes;
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private WorkflowUtil workflowUtil;

    @Test
    public void testSystemWorkflowIsNotEditable() {
        Assert.assertFalse((boolean)this.administration.workflows().goTo().isEditable("jira"));
    }

    @Test
    public void testAnActiveWorkflowIsEditableGivenADraftHasNotBeenCreatedForIt() {
        Assert.assertTrue((boolean)this.administration.workflows().goTo().isEditable("Active workflow"));
    }

    @Test
    public void testAnActiveWorkflowIsEditableGivenADraftHasBeenCreatedForIt() {
        this.administration.workflows().goTo().createDraft("Active workflow");
        Assert.assertTrue((boolean)this.administration.workflows().goTo().isEditable("Active workflow"));
    }

    @Test
    public void testAnInactiveWorkflowIsEditableGivenItHasNoAssignedSchemes() {
        Assert.assertTrue((boolean)this.administration.workflows().goTo().isEditable("editable with no scheme"));
    }

    @Test
    public void testAnInactiveWorkflowIsEditableGivenItHasAssignedSchemes() {
        Assert.assertTrue((boolean)this.administration.workflows().goTo().isEditable("editable workflow"));
    }

    @Test
    public void testEditInactiveWorkflowWithScheme() {
        this.administration.workflows().goTo().edit("editable workflow").rename().setNameTo("edited with a scheme").setDescriptionTo("edited with a scheme").submit();
        this.administration.workflows().goTo();
        this.tester.assertTextPresent("edited with a scheme");
        this.tester.assertTextNotPresent("editable workflow");
        this.administration.project().associateWorkflowScheme("monkey", "scheme with editable flow");
        this.workflowSchemes.waitForSuccessfulWorkflowSchemeMigration("monkey", "scheme with editable flow");
        this.administration.project().associateWorkflowScheme("neanderthal", "scheme with renamed workflow");
        this.workflowSchemes.waitForSuccessfulWorkflowSchemeMigration("neanderthal", "scheme with renamed workflow");
        this.assertAddingIssueForModifiedWorkflow("monkey", "New Feature", "MONKEY new feature issue of the workflow that was renamed");
        this.assertAddingIssueForModifiedWorkflow("monkey", "Task", "MONKEY task issue of the workflow that was renamed");
        this.assertAddingIssueForUnModifiedWorkflow("monkey", "Bug", "MONKEY bug issue of the workflow that was NOT renamed");
        this.assertAddingIssueForUnModifiedWorkflow("monkey", "Improvement", "MONKEY improvement issue of the workflow that was NOT renamed");
        this.assertAddingIssueForModifiedWorkflow("neanderthal", "Bug", "NEO bug issue of the workflow that was renamed");
        this.assertAddingIssueForModifiedWorkflow("neanderthal", "Improvement", "NEO improvement issue of the workflow that was renamed");
        this.assertAddingIssueForModifiedWorkflow("neanderthal", "New Feature", "NEO new feature issue of the workflow that was renamed");
        this.assertAddingIssueForModifiedWorkflow("neanderthal", "Task", "NEO task issue of the workflow that was renamed");
    }

    private void assertAddingIssueForUnModifiedWorkflow(String project, String issueType, String summary) {
        String issueKey = this.navigation.issue().createIssue(project, issueType, summary);
        List<String> transitions = this.workflowUtil.queryAvailableWorkflowActionNames(issueKey);
        MatcherAssert.assertThat(transitions, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"RESOLVE WITH EDITED WORKFLOW")));
        MatcherAssert.assertThat(transitions, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Start Progress", "Resolve Issue", "Close Issue"}));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".opsbar-transitions__status-category_new"), "Open");
        this.workflowUtil.clickAction("action_id_4");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".opsbar-transitions__status-category_indeterminate"), "In Progress");
    }

    private void assertAddingIssueForModifiedWorkflow(String project, String issueType, String summary) {
        String issueKey = this.navigation.issue().createIssue(project, issueType, summary);
        MatcherAssert.assertThat(this.workflowUtil.queryAvailableWorkflowActionNames(issueKey), (Matcher)Matchers.hasItem((Object)"RESOLVE WITH EDITED WORKFLOW"));
        this.tester.assertTextPresent("Open");
        MatcherAssert.assertThat((Object)this.tester.getDialog().getElement("stalker").getTextContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Resolved")));
        this.workflowUtil.clickAction("action_id_11");
        this.tester.assertTextPresent("Resolved");
        MatcherAssert.assertThat((Object)this.tester.getDialog().getElement("stalker").getTextContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Open")));
    }

    @Test
    public void testDefaultSystemWorkflowIsNotEditableViaUrlAccess() {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/workflows/EditWorkflow.jspa?workflowMode=live&workflowName=jira"));
        this.assertWorkflowIsNotEditable();
    }

    @Test
    public void testActiveWorkflowsAreNotEditable() {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/workflows/EditWorkflow.jspa?workflowMode=live&workflowName=Active+workflow"));
        this.assertWorkflowIsNotEditable();
    }

    @Test
    public void testEditWorkflowNameValidation() {
        this.administration.workflows().goTo().edit("editable workflow").rename().setNameTo("").submit();
        this.tester.assertTextPresent("You must specify a workflow name.");
        this.administration.workflows().goTo().edit("editable workflow").rename().setNameTo("Active workflow").submit();
        this.tester.assertTextPresent("A workflow with this name already exists.");
        this.administration.workflows().goTo().edit("editable workflow").rename().setNameTo("non-ascii char: \u1234").submit();
        this.tester.assertTextPresent("Please use only ASCII characters for the workflow name.");
    }

    private void assertWorkflowIsNotEditable() {
        this.tester.assertTextPresent("Workflow cannot be edited as it is not editable.");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Edit workflow");
        this.tester.assertTextPresent("Workflow cannot be edited as it is not editable.");
        this.tester.setFormElement("newWorkflowName", "name change");
        this.tester.setFormElement("description", "desc change");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Edit workflow");
        this.tester.assertTextPresent("Workflow cannot be edited as it is not editable.");
    }

    @Test
    public void testEditDraftWorkflow() {
        this.administration.workflows().goTo().createDraft("Active workflow");
        Assert.assertFalse((boolean)this.administration.workflows().goTo().edit("Active workflow").rename().isNameEditable());
        this.administration.workflows().goTo().edit("Active workflow").rename().setDescriptionTo("well not really since its a draft").submit();
        Assert.assertTrue((boolean)Iterables.any((Iterable)Iterables.filter((Iterable)((Object)this.administration.workflows().goTo().active()), ViewWorkflows.WorkflowItemsList.Predicates.byName("Active workflow")), ViewWorkflows.WorkflowItemsList.Predicates.byDescription("This workflow is active")));
        this.administration.workflows().goTo().edit("Active workflow");
        this.tester.assertTextPresent("well not really since its a draft");
    }
}

