/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WorkflowUtil {
    public static final String ACTION_PREFIX = "action_id_";
    private final WebTester tester;
    private final LocatorFactory locators;
    private final IssueClient issueClient;

    @Inject
    public WorkflowUtil(WebTester tester, com.atlassian.jira.webtests.util.JIRAEnvironmentData jiraEnvironmentData, LocatorFactory locators) {
        this.tester = tester;
        this.locators = locators;
        this.issueClient = new IssueClient((JIRAEnvironmentData)jiraEnvironmentData);
    }

    public void clickAction(String actionId) {
        this.tester.gotoPage(this.getActionUrl(actionId));
    }

    public String getActionUrl(String actionId) {
        if (this.isActionId(actionId)) {
            actionId = actionId.substring(ACTION_PREFIX.length());
        }
        String xsrfToken = Objects.requireNonNull(new HtmlPage(this.tester).getXsrfToken());
        String issueId = Objects.requireNonNull(this.getIssueId());
        return String.format("/secure/WorkflowUIDispatcher.jspa?id=%s&action=%s&atl_token=%s", issueId, actionId, xsrfToken);
    }

    public boolean isActionId(String actionId) {
        if (actionId == null) {
            return false;
        }
        return actionId.startsWith(ACTION_PREFIX);
    }

    public List<String> queryAvailableWorkflowActionNames(String issueKey) {
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[]{Issue.Expand.transitions});
        return issue.transitions.stream().map(t -> t.name).collect(Collectors.toList());
    }

    private String getIssueId() {
        Node node = this.locators.id("key-val").getNode();
        if (node instanceof Element) {
            return ((Element)node).getAttribute("rel");
        }
        return null;
    }
}

