/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.issue.comparator.util.DelegatingComparator;
import com.atlassian.jira.issue.statistics.FilterStatisticsValuesGenerator;
import com.atlassian.jira.issue.statistics.StatisticGatherer;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.util.CachingStatisticsMapper;
import com.atlassian.jira.issue.statistics.util.ComparatorSelector;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.comparators.ReverseComparator;

public class TwoDimensionalStatsMap {
    public static final String TOTAL_ORDER = "total";
    public static final String NATURAL_ORDER = "natural";
    public static final String DESC = "desc";
    public static final String ASC = "asc";
    private final StatisticsMapper xAxisMapper;
    private final StatisticsMapper yAxisMapper;
    private final StatisticGatherer statisticGatherer;
    private final Map xAxis;
    private final Map xAxisTotals;
    private final Map yAxisTotals;
    private final Map<Object, Number> xAxisIrrelevantTotals;
    private int bothIrrelevant = 0;
    private final Map<Object, Number> yAxisIrrelevantTotals;
    private Number entireTotal;

    public TwoDimensionalStatsMap(StatisticsMapper xAxisMapper, StatisticsMapper yAxisMapper, StatisticGatherer statisticGatherer) {
        Comparator xAxisComparator = ComparatorSelector.getComparator(xAxisMapper);
        Comparator yAxisComparator = ComparatorSelector.getComparator(yAxisMapper);
        this.xAxisMapper = new CachingStatisticsMapper(xAxisMapper);
        this.yAxisMapper = new CachingStatisticsMapper(yAxisMapper);
        this.statisticGatherer = statisticGatherer;
        this.xAxis = new TreeMap(new IrrelevantHandlingComparator(xAxisComparator));
        this.xAxisTotals = new TreeMap(new IrrelevantHandlingComparator(xAxisComparator));
        this.yAxisTotals = new TreeMap(new IrrelevantHandlingComparator(yAxisComparator));
        this.xAxisIrrelevantTotals = new TreeMap(yAxisComparator);
        this.yAxisIrrelevantTotals = new TreeMap(xAxisComparator);
    }

    public TwoDimensionalStatsMap(StatisticsMapper xAxisMapper, StatisticsMapper yAxisMapper) {
        this(xAxisMapper, yAxisMapper, (StatisticGatherer)new StatisticGatherer.Sum());
    }

    private void addToXTotal(Object xValue, int i) {
        Number total = (Number)this.xAxisTotals.get(xValue);
        this.xAxisTotals.put(xValue, this.statisticGatherer.getValue(total, i));
    }

    private void addToYTotal(Object yValue, int i) {
        Number total = (Number)this.yAxisTotals.get(yValue);
        this.yAxisTotals.put(yValue, this.statisticGatherer.getValue(total, i));
    }

    private void addToEntireTotal(int i) {
        this.entireTotal = this.statisticGatherer.getValue(this.entireTotal, i);
    }

    void addValue(Object xValue, Object yValue, int i) {
        TreeMap yValues = (TreeMap)this.xAxis.get(xValue);
        if (yValues == null) {
            yValues = new TreeMap(ComparatorSelector.getComparator(this.yAxisMapper));
            this.xAxis.put(xValue, yValues);
        }
        Number existingValue = (Number)yValues.get(yValue);
        yValues.put(yValue, this.statisticGatherer.getValue(existingValue, i));
    }

    void addToYIrrelevantTotals(Collection xValues, int incrementValue) {
        for (Object xValue : xValues) {
            Number existingValue = this.yAxisIrrelevantTotals.get(xValue);
            this.yAxisIrrelevantTotals.put(xValue, this.statisticGatherer.getValue(existingValue, incrementValue));
        }
    }

    void addToXIrrelevantTotals(Collection yValues, int incrementValue) {
        for (Object yValue : yValues) {
            Number existingValue = this.xAxisIrrelevantTotals.get(yValue);
            this.xAxisIrrelevantTotals.put(yValue, this.statisticGatherer.getValue(existingValue, incrementValue));
        }
    }

    public Collection getXAxis() {
        TreeSet xVals = new TreeSet(ComparatorSelector.getComparator(this.xAxisMapper));
        if (this.xAxis.keySet() != null) {
            xVals.addAll(this.xAxis.keySet());
        }
        if (this.yAxisIrrelevantTotals.keySet() != null) {
            xVals.addAll(this.yAxisIrrelevantTotals.keySet());
        }
        return xVals;
    }

    public Collection getYAxis() {
        return this.getYAxis(NATURAL_ORDER, ASC);
    }

    public Collection getYAxis(String orderBy, String direction) {
        Comparator comp;
        if (orderBy != null && orderBy.equals(TOTAL_ORDER)) {
            comp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    Long o1Long = new Long(TwoDimensionalStatsMap.this.getYAxisUniqueTotal(o1));
                    Long o2Long = new Long(TwoDimensionalStatsMap.this.getYAxisUniqueTotal(o2));
                    return o1Long.compareTo(o2Long);
                }
            };
            if (direction != null && direction.equals(DESC)) {
                comp = new ReverseComparator(comp);
            }
            comp = new DelegatingComparator(comp, ComparatorSelector.getComparator(this.yAxisMapper));
        } else {
            comp = this.yAxisMapper.getComparator();
            if (direction != null && direction.equals(DESC)) {
                comp = new ReverseComparator(comp);
            }
        }
        return this.getYAxis(comp);
    }

    public Collection getYAxis(Comparator comp) {
        TreeSet<Object> yAxisKeys = new TreeSet<Object>(comp);
        for (Object o : this.xAxis.values()) {
            Map yAxisValues = (Map)o;
            yAxisKeys.addAll(yAxisValues.keySet());
        }
        if (this.xAxisIrrelevantTotals.keySet() != null) {
            yAxisKeys.addAll(this.xAxisIrrelevantTotals.keySet());
        }
        return yAxisKeys;
    }

    public int getCoordinate(Object xAxis, Object yAxis) {
        Map yValues = (Map)this.xAxis.get(xAxis);
        if (yValues == null) {
            return 0;
        }
        Number value = (Number)yValues.get(yAxis);
        return value == null ? 0 : value.intValue();
    }

    public StatisticsMapper getyAxisMapper() {
        return this.yAxisMapper;
    }

    public StatisticsMapper getxAxisMapper() {
        return this.xAxisMapper;
    }

    public int getXAxisUniqueTotal(Object xAxis) {
        Number xTotal = (Number)this.xAxisTotals.get(xAxis);
        return xTotal != null ? xTotal.intValue() : 0;
    }

    public int getYAxisUniqueTotal(Object yAxis) {
        Number yTotal = (Number)this.yAxisTotals.get(yAxis);
        return yTotal != null ? yTotal.intValue() : 0;
    }

    public int getXAxisIrrelevantTotal(Object yAxis) {
        Number xTotal = this.xAxisIrrelevantTotals.get(yAxis);
        return xTotal != null ? xTotal.intValue() : 0;
    }

    public int getYAxisIrrelevantTotal(Object xAxis) {
        Number yTotal = this.yAxisIrrelevantTotals.get(xAxis);
        return yTotal != null ? yTotal.intValue() : 0;
    }

    public int getBothIrrelevant() {
        return this.bothIrrelevant;
    }

    public boolean hasIrrelevantXData() {
        if (this.bothIrrelevant > 0) {
            return true;
        }
        for (Number xAxisIrrelevantTotal : this.xAxisIrrelevantTotals.values()) {
            if (xAxisIrrelevantTotal == null || xAxisIrrelevantTotal.intValue() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasIrrelevantYData() {
        if (this.bothIrrelevant > 0) {
            return true;
        }
        for (Number yAxisIrrelevantTotal : this.yAxisIrrelevantTotals.values()) {
            if (yAxisIrrelevantTotal == null || yAxisIrrelevantTotal.intValue() <= 0) continue;
            return true;
        }
        return false;
    }

    public long getUniqueTotal() {
        return this.entireTotal != null ? (long)this.entireTotal.intValue() : 0L;
    }

    public void adjustMapForIrrelevantValues(Collection xAxisValues, boolean xIrrelevant, Collection yAxisValues, boolean yIrrelevant, int incrementValue) {
        if (xIrrelevant && yIrrelevant) {
            ++this.bothIrrelevant;
        } else if (xIrrelevant && !yIrrelevant) {
            this.addToXTotal(FilterStatisticsValuesGenerator.IRRELEVANT, incrementValue);
            Collection transformedYValues = yAxisValues == null ? EasyList.build(null) : TwoDimensionalStatsMap.transformAndRemoveInvaid(yAxisValues, this.yAxisMapper);
            this.addToXIrrelevantTotals(transformedYValues, incrementValue);
        } else if (yIrrelevant && !xIrrelevant) {
            this.addToYTotal(FilterStatisticsValuesGenerator.IRRELEVANT, incrementValue);
            Collection transformedXValues = xAxisValues == null ? EasyList.build(null) : TwoDimensionalStatsMap.transformAndRemoveInvaid(xAxisValues, this.xAxisMapper);
            this.addToYIrrelevantTotals(transformedXValues, incrementValue);
        }
        this.addToEntireTotal(1);
    }

    public void adjustMapForValues(Collection xAxisValues, Collection yAxisValues, int value) {
        if (xAxisValues == null) {
            xAxisValues = EasyList.build(null);
        }
        if (yAxisValues == null) {
            yAxisValues = EasyList.build(null);
        }
        xAxisValues = TwoDimensionalStatsMap.transformAndRemoveInvaid(xAxisValues, this.xAxisMapper);
        yAxisValues = TwoDimensionalStatsMap.transformAndRemoveInvaid(yAxisValues, this.yAxisMapper);
        for (Object xvalue : xAxisValues) {
            this.addToXTotal(xvalue, value);
            for (Object yvalue : yAxisValues) {
                this.addValue(xvalue, yvalue, value);
            }
        }
        for (Object yvalue : yAxisValues) {
            this.addToYTotal(yvalue, value);
        }
        this.addToEntireTotal(value);
    }

    private static Collection transformAndRemoveInvaid(Collection values, StatisticsMapper mapper) {
        ArrayList output = Lists.newArrayListWithCapacity((int)values.size());
        for (Object value1 : values) {
            String key = (String)value1;
            Object value = key != null ? mapper.getValueFromLuceneField(key) : null;
            if (!mapper.isValidValue(value)) continue;
            output.add(value);
        }
        return output;
    }

    private static class IrrelevantHandlingComparator
    implements Comparator {
        private final Comparator delegate;

        public IrrelevantHandlingComparator(Comparator delegate) {
            this.delegate = delegate;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == FilterStatisticsValuesGenerator.IRRELEVANT) {
                return -1;
            }
            if (o2 == FilterStatisticsValuesGenerator.IRRELEVANT) {
                return 1;
            }
            return this.delegate.compare(o1, o2);
        }
    }
}

