/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.JiraDocValues;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.parameters.lucene.JiraBytesRef;
import com.atlassian.jira.issue.statistics.util.BytesRefMapper;
import com.atlassian.jira.issue.statistics.util.CachingBytesRefMapper;
import com.atlassian.jira.issue.statistics.util.HitCollectorUtil;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.SimpleCollector;

@Internal
@NotThreadSafe
public abstract class AbstractOneDimensionalHitCollector
extends SimpleCollector {
    private final String fieldId;
    private JiraDocValues docToTerms;
    private JiraDocValues docToProject;
    private JiraDocValues docToIssueType;
    private String documentFieldId;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final ReaderCache readerCache;
    private long irrelevantCount = 0L;
    private final CustomField customField;
    private final Map<Long, Map<String, Boolean>> projectIdIssueTypeIdFieldVisibility = new HashMap<Long, Map<String, Boolean>>();
    private final BytesRefMapper<String> issueTypesMapper = new CachingBytesRefMapper<String>(Function.identity());
    private final BytesRefMapper<Long> projectIdsMapper = new CachingBytesRefMapper<Long>(Long::new);
    private long hitCount = 0L;
    private int docBase = 0;

    public AbstractOneDimensionalHitCollector(String documentFieldId, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache, FieldManager fieldManager) {
        this.documentFieldId = documentFieldId;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.readerCache = readerCache;
        this.fieldId = new HitCollectorUtil().getFieldId(documentFieldId);
        this.customField = fieldManager.isCustomField(this.fieldId) ? fieldManager.getCustomField(this.fieldId) : null;
    }

    public void doSetNextReader(LeafReaderContext context) {
        this.doSetNextIndexReader((IndexReaderContext)context);
        this.docBase = context.docBase;
    }

    public void doSetNextIndexReader(IndexReaderContext context) {
        this.docBase = 0;
        this.docToTerms = this.readerCache.getDocValues(context.reader(), this.documentFieldId);
        this.docToProject = this.readerCache.getDocValues(context.reader(), SystemSearchConstants.forProject().getIndexField());
        this.docToIssueType = this.readerCache.getDocValues(context.reader(), SystemSearchConstants.forIssueType().getIndexField());
    }

    public void collect(int i) {
        ++this.hitCount;
        JiraBytesRef[] terms = this.docToTerms.getDocValues(i);
        int docId = this.docBase + i;
        if (terms == null || terms.length == 0) {
            Long projectIdString = this.projectIdsMapper.mapSingleValueFromArray(this.docToProject.getDocValues(i));
            String issueTypeId = this.issueTypesMapper.mapSingleValueFromArray(this.docToIssueType.getDocValues(i));
            if (projectIdString != null && issueTypeId != null && this.fieldIsRelevant(projectIdString, issueTypeId)) {
                this.collectWithTerms(docId, null);
            } else {
                ++this.irrelevantCount;
                this.collectIrrelevant(docId);
            }
        } else {
            this.collectWithTerms(docId, terms);
        }
    }

    private boolean fieldIsRelevant(Long projectId, String issueTypeId) {
        Boolean fieldRelevant;
        Map<String, Boolean> issueTypeIdFieldVisibility = this.projectIdIssueTypeIdFieldVisibility.get(projectId);
        if (issueTypeIdFieldVisibility == null) {
            issueTypeIdFieldVisibility = new HashMap<String, Boolean>();
            this.projectIdIssueTypeIdFieldVisibility.put(projectId, issueTypeIdFieldVisibility);
        }
        if ((fieldRelevant = issueTypeIdFieldVisibility.get(issueTypeId)) == null) {
            fieldRelevant = this.fieldVisibilityManager.isFieldVisible(projectId, this.fieldId, issueTypeId) && this.isFieldInScope(projectId, issueTypeId);
            issueTypeIdFieldVisibility.put(issueTypeId, fieldRelevant);
        }
        return fieldRelevant;
    }

    private boolean isFieldInScope(Long projectId, String issueTypeId) {
        if (this.fieldId == null || "".equals(this.fieldId) || projectId == null || issueTypeId == null || "".equals(issueTypeId)) {
            return false;
        }
        if (this.customField == null) {
            return true;
        }
        return this.customField.isInScope(projectId.longValue(), issueTypeId);
    }

    private static String getSingleValue(JiraBytesRef[] source) {
        return source.length > 0 ? source[0].utf8ToString() : "";
    }

    public long getIrrelevantCount() {
        return this.irrelevantCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    protected abstract void collectIrrelevant(int var1);

    protected abstract void collectWithTerms(int var1, JiraBytesRef[] var2);

    public boolean needsScores() {
        return false;
    }
}

