/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.parameters.lucene.JiraBytesRef;
import com.atlassian.jira.issue.statistics.util.BytesRefMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CachingBytesRefMapper<T>
implements BytesRefMapper<T> {
    private final Map<JiraBytesRef, T> bytesRefValuesCache = new HashMap<JiraBytesRef, T>();
    private final Function<JiraBytesRef, T> converter;

    public CachingBytesRefMapper(@Nonnull Function<String, T> converter) {
        this.converter = bytesRef -> converter.apply(bytesRef.utf8ToString());
    }

    public CachingBytesRefMapper(@Nullable LuceneFieldSorter<T> sorter) {
        this.converter = sorter == null ? value -> null : bytesRef -> sorter.getValueFromLuceneField(bytesRef.utf8ToString());
    }

    @Override
    @Nullable
    public T mapValue(@Nullable JiraBytesRef valueToConvert) {
        return this.bytesRefValuesCache.computeIfAbsent(valueToConvert, this.converter);
    }
}

