/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page;

import com.atlassian.jira.pageobjects.framework.elements.ExtendedElementFinder;
import com.atlassian.jira.pageobjects.framework.elements.PageElements;
import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.SidebarBrowseProjectSubPage;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class SummaryPage
extends SidebarBrowseProjectSubPage {
    public static final String SUMMARY_PAGE_KEY = "com.atlassian.jira.jira-projects-plugin:summary-page";
    @Inject
    private Timeouts timeouts;
    @Inject
    private ExtendedElementFinder extendedElementFinder;
    @ElementBy(className="project-meta-column")
    private PageElement projectMeta;

    public SummaryPage(String projectKey) {
        super(projectKey);
    }

    @Override
    public String getPageId() {
        return SUMMARY_PAGE_KEY;
    }

    public TimedQuery<Iterable<String>> getMostActive() {
        return Queries.forSupplier((Timeouts)this.timeouts, (Supplier)this.extendedElementFinder.newQuery(By.cssSelector((String)"dd.project-meta-most-active .user-hover")).transform(PageElements.getAttribute((String)"rel")).supplier());
    }

    public TimedQuery<String> getVignette(String name) {
        String xpath = "//dt[text()=\"%s\"]/following-sibling::dd";
        PageElement pageElement = this.projectMeta.find(By.xpath((String)String.format(xpath, name)));
        return pageElement.timed().getText();
    }
}

