/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.legacy;

import com.atlassian.jira.projects.pageobjects.webdriver.page.legacy.BrowseProjectTab;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import javax.inject.Inject;
import org.openqa.selenium.By;

public abstract class AbstractProjectTab
implements BrowseProjectTab {
    public static final String PROJECT_PLUGIN_PREFIX = "com.atlassian.jira.jira-projects-plugin:";
    protected final String linkId;
    protected final String projectKey;
    protected PageElement linkItem;
    protected PageElement link;
    @Inject
    private PageElementFinder elementFinder;

    public AbstractProjectTab(String linkId, String projectKey) {
        this.projectKey = projectKey;
        this.linkId = (String)Assertions.notNull((Object)linkId);
    }

    @Init
    private void init() {
        for (PageElement item : this.elementFinder.find(By.cssSelector((String)"ul.vertical.tabs")).findAll(By.tagName((String)"li"))) {
            PageElement link = item.find(By.id((String)this.linkId()));
            if (!link.isPresent()) continue;
            this.linkItem = item;
            this.link = link;
            break;
        }
        Assertions.stateTrue((String)("Not found link by ID " + this.linkId), (this.link != null ? 1 : 0) != 0);
    }

    public final String linkId() {
        return this.linkId;
    }

    public final TimedCondition isOpen() {
        return this.linkItem.timed().hasClass("active");
    }
}

