/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.api.ComponentRestClient;
import com.atlassian.jira.rest.client.api.domain.Component;
import com.atlassian.jira.rest.client.api.domain.input.ComponentInput;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.domain.input.ComponentInputWithProjectKey;
import com.atlassian.jira.rest.client.internal.json.ComponentJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.gen.ComponentInputWithProjectKeyJsonGenerator;
import io.atlassian.util.concurrent.Promise;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class AsynchronousComponentRestClient
extends AbstractAsynchronousRestClient
implements ComponentRestClient {
    private final ComponentJsonParser componentJsonParser = new ComponentJsonParser();
    private final URI componentUri;

    public AsynchronousComponentRestClient(URI baseUri, HttpClient client) {
        super(client);
        this.componentUri = UriBuilder.fromUri((URI)baseUri).path("component").build(new Object[0]);
    }

    public Promise<Component> getComponent(URI componentUri) {
        return this.getAndParse(componentUri, this.componentJsonParser);
    }

    public Promise<Component> createComponent(String projectKey, ComponentInput componentInput) {
        ComponentInputWithProjectKey helper = new ComponentInputWithProjectKey(projectKey, componentInput);
        return this.postAndParse(this.componentUri, helper, new ComponentInputWithProjectKeyJsonGenerator(), this.componentJsonParser);
    }

    public Promise<Component> updateComponent(URI componentUri, ComponentInput componentInput) {
        ComponentInputWithProjectKey helper = new ComponentInputWithProjectKey(null, componentInput);
        return this.putAndParse(componentUri, helper, new ComponentInputWithProjectKeyJsonGenerator(), this.componentJsonParser);
    }

    public Promise<Void> removeComponent(URI componentUri, @Nullable URI moveIssueToComponentUri) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)componentUri);
        if (moveIssueToComponentUri != null) {
            uriBuilder.queryParam("moveIssuesTo", new Object[]{moveIssueToComponentUri});
        }
        return this.delete(uriBuilder.build(new Object[0]));
    }

    public Promise<Integer> getComponentRelatedIssuesCount(URI componentUri) {
        URI relatedIssueCountsUri = UriBuilder.fromUri((URI)componentUri).path("relatedIssueCounts").build(new Object[0]);
        return this.getAndParse(relatedIssueCountsUri, new JsonObjectParser<Integer>(this){

            @Override
            public Integer parse(JSONObject json) throws JSONException {
                return json.getInt("issueCount");
            }
        });
    }
}

