/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.exception;

import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import java.util.Collections;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

public abstract class JiraExceptionMapper<E extends Throwable>
implements ExceptionMapper<E> {
    public Response toResponse(E exception) {
        JSONObject json = new JSONObject();
        try {
            json.put("errorMessages", Collections.singletonList(((Throwable)exception).getMessage()));
        }
        catch (JSONException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)((Throwable)exception).getMessage()).cacheControl(CacheControl.never()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)json.toString()).type(MediaType.APPLICATION_JSON_TYPE).cacheControl(CacheControl.never()).build();
    }
}

