/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.field.configscheme;

import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.rest.api.field.FieldBean;
import com.atlassian.jira.rest.v2.issue.IssueTypeBeanExample;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collection;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FieldConfigSchemeBean {
    public static final FieldConfigSchemeBean DOC_EXAMPLE_1 = new FieldConfigSchemeBean();
    public static final FieldConfigSchemeBean DOC_EXAMPLE_2;
    public static final FieldConfigSchemeBean DOC_EXAMPLE_3;
    public static final List<FieldConfigSchemeBean> DOC_EXAMPLE_LIST;
    @JsonProperty
    private URI self;
    @JsonProperty
    private Long id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    private FieldBean field;
    @JsonProperty
    @JsonFormat(with={JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED})
    private Object defaultValue;
    @JsonProperty
    private boolean allProjects;
    @JsonProperty
    private Collection<ProjectBean> projects;
    @JsonProperty
    private boolean allIssueTypes;
    @JsonProperty
    private Collection<IssueTypeJsonBean> issueTypes;
    @JsonProperty
    private Collection<Long> fieldConfigIds;

    public FieldConfigSchemeBean(URI self, Long id, String name, String description, FieldBean field, Object defaultValue, boolean allProjects, Collection<ProjectBean> projects, boolean allIssueTypes, Collection<IssueTypeJsonBean> issueTypes, Collection<Long> fieldConfigIds) {
        this.self = self;
        this.id = id;
        this.name = name;
        this.description = description;
        this.field = field;
        this.defaultValue = defaultValue;
        this.allProjects = allProjects;
        this.projects = projects;
        this.allIssueTypes = allIssueTypes;
        this.issueTypes = issueTypes;
        this.fieldConfigIds = fieldConfigIds;
    }

    public FieldConfigSchemeBean() {
    }

    public boolean isAllProjects() {
        return this.allProjects;
    }

    public void setAllProjects(boolean allProjects) {
        this.allProjects = allProjects;
    }

    public Collection<ProjectBean> getProjects() {
        return this.projects;
    }

    public void setProjects(Collection<ProjectBean> projects) {
        this.projects = projects;
    }

    public void setIssueTypes(Collection<IssueTypeJsonBean> issueTypes) {
        this.issueTypes = issueTypes;
    }

    public FieldBean getField() {
        return this.field;
    }

    public void setField(FieldBean field) {
        this.field = field;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public URI getSelf() {
        return this.self;
    }

    public void setSelf(URI self) {
        this.self = self;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isAllIssueTypes() {
        return this.allIssueTypes;
    }

    public void setAllIssueTypes(boolean allIssueTypes) {
        this.allIssueTypes = allIssueTypes;
    }

    public Collection<IssueTypeJsonBean> getIssueTypes() {
        return this.issueTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Collection<Long> getFieldConfigIds() {
        return this.fieldConfigIds;
    }

    public void setFieldConfigIds(Collection<Long> fieldConfigIds) {
        this.fieldConfigIds = fieldConfigIds;
    }

    static {
        DOC_EXAMPLE_1.setSelf(URI.create("http://www.example.com/jira/rest/api/2/field/description/configschemes/10050"));
        DOC_EXAMPLE_1.setId(10050L);
        DOC_EXAMPLE_1.setName("Context for Bugs and Tasks");
        DOC_EXAMPLE_1.setDescription("A context for Bug and Task issue type");
        DOC_EXAMPLE_1.setField(FieldBean.DOC_EXAMPLE);
        DOC_EXAMPLE_1.setDefaultValue("A default value of the description field set by the user");
        DOC_EXAMPLE_1.setAllProjects(false);
        DOC_EXAMPLE_1.setProjects(ProjectBean.PROJECTS_EXAMPLE);
        DOC_EXAMPLE_1.setAllIssueTypes(false);
        DOC_EXAMPLE_1.setIssueTypes(IssueTypeBeanExample.ISSUE_TYPES_EXAMPLE);
        DOC_EXAMPLE_2 = new FieldConfigSchemeBean();
        DOC_EXAMPLE_2.setSelf(URI.create("http://www.example.com/jira/rest/api/2/field/customfield_10101/configschemes/10100"));
        DOC_EXAMPLE_2.setId(10100L);
        DOC_EXAMPLE_2.setName("Context for Tasks");
        DOC_EXAMPLE_2.setDescription("A context for Task issue in Example Project");
        DOC_EXAMPLE_2.setField(FieldBean.DOC_EXAMPLE_CF);
        DOC_EXAMPLE_2.setDefaultValue("Another custom default value");
        DOC_EXAMPLE_2.setProjects((Collection<ProjectBean>)ImmutableList.of((Object)ProjectBean.DOC_EXAMPLE));
        DOC_EXAMPLE_2.setIssueTypes((Collection<IssueTypeJsonBean>)ImmutableList.of((Object)IssueTypeBeanExample.DOC_EXAMPLE));
        DOC_EXAMPLE_3 = new FieldConfigSchemeBean();
        DOC_EXAMPLE_3.setSelf(URI.create("http://www.example.com/jira/rest/api/2/field/customfield_10101/configschemes/10100"));
        DOC_EXAMPLE_3.setId(10100L);
        DOC_EXAMPLE_3.setName("Global context");
        DOC_EXAMPLE_3.setDescription("A context for all projects and issue types");
        DOC_EXAMPLE_3.setField(FieldBean.DOC_EXAMPLE_CF);
        DOC_EXAMPLE_3.setDefaultValue("Default value");
        DOC_EXAMPLE_3.setAllProjects(true);
        DOC_EXAMPLE_3.setAllIssueTypes(true);
        DOC_EXAMPLE_LIST = ImmutableList.of((Object)DOC_EXAMPLE_1, (Object)DOC_EXAMPLE_2, (Object)DOC_EXAMPLE_3);
    }

    public static class Builder {
        private URI self;
        private Long id;
        private String name;
        private String description;
        private FieldBean field;
        private Object defaultValue;
        private boolean allProjects;
        private Collection<ProjectBean> projects;
        private boolean allIssueTypes;
        private Collection<IssueTypeJsonBean> issueTypes;
        private Collection<Long> fieldConfigIds;

        public Builder setSelf(URI self) {
            this.self = self;
            return this;
        }

        public Builder setId(Long id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setField(FieldBean field) {
            this.field = field;
            return this;
        }

        public Builder setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setAllProjects(boolean value) {
            this.allProjects = value;
            return this;
        }

        public Builder setIssueTypes(Collection<IssueTypeJsonBean> issueTypes) {
            this.issueTypes = issueTypes;
            return this;
        }

        public Builder setAllIssueTypes(boolean value) {
            this.allIssueTypes = value;
            return this;
        }

        public Builder setProjects(Collection<ProjectBean> projects) {
            this.projects = projects;
            return this;
        }

        public Builder setFieldConfigIds(Collection<Long> fieldConfigIds) {
            this.fieldConfigIds = fieldConfigIds;
            return this;
        }

        public FieldConfigSchemeBean build() {
            return new FieldConfigSchemeBean(this.self, this.id, this.name, this.description, this.field, this.defaultValue, this.allProjects, this.projects, this.allIssueTypes, this.issueTypes, this.fieldConfigIds);
        }
    }
}

