/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.field.configscheme;

import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.DefaultValueField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.field.FieldBean;
import com.atlassian.jira.rest.internal.v2.field.configscheme.FieldConfigSchemeBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBeanFactory;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class FieldConfigSchemeBeanFactory {
    private final ProjectBeanFactory projectBeanFactory;
    private final JiraBaseUrls baseUrls;
    private final FieldManager fieldManager;
    private final SearchHandlerManager searchHandlerManager;

    public FieldConfigSchemeBeanFactory(ProjectBeanFactory projectBeanFactory, JiraBaseUrls baseUrls, FieldManager fieldManager, SearchHandlerManager searchHandlerManager) {
        this.projectBeanFactory = projectBeanFactory;
        this.baseUrls = baseUrls;
        this.fieldManager = fieldManager;
        this.searchHandlerManager = searchHandlerManager;
    }

    public List<FieldConfigSchemeBean> getBeans(List<FieldConfigScheme> schemesForField) {
        return schemesForField.stream().map(this::getBean).collect(Collectors.toList());
    }

    public FieldConfigSchemeBean getBean(FieldConfigScheme fieldConfigScheme) {
        ConfigurableField field = fieldConfigScheme.getField();
        List projects = fieldConfigScheme.getAssociatedProjectObjects();
        boolean allIssueTypes = fieldConfigScheme.isAllIssueTypes();
        boolean allProjects = fieldConfigScheme.isAllProjects();
        Collection issueTypes = fieldConfigScheme.getAssociatedIssueTypes();
        Object defaultValue = this.getDefaultValueIfSupported(field, fieldConfigScheme);
        Collection fieldConfigIds = fieldConfigScheme.getConfigs().values().stream().map(FieldConfig::getId).collect(Collectors.toList());
        URI self = UriBuilder.fromPath((String)this.baseUrls.baseUrl()).path("/rest/internal/2/field/").path(field.getId()).path("/context/").path(fieldConfigScheme.getId().toString()).build(new Object[0]);
        return FieldConfigSchemeBean.builder().setSelf(self).setId(fieldConfigScheme.getId()).setName(fieldConfigScheme.getName()).setDescription(fieldConfigScheme.getDescription()).setAllIssueTypes(allIssueTypes).setIssueTypes((Collection<IssueTypeJsonBean>)(allIssueTypes ? ImmutableList.of() : this.getIssueTypeBeans(issueTypes))).setDefaultValue(defaultValue).setField(this.getFieldBean(field)).setAllProjects(allProjects).setProjects((Collection<ProjectBean>)(allProjects ? ImmutableList.of() : this.getProjectBeans(projects))).setFieldConfigIds(fieldConfigIds).build();
    }

    public FieldConfigScheme createConfig(String fieldId, FieldConfigSchemeBean bean) {
        return new FieldConfigScheme.Builder().setName(bean.getName()).setDescription(bean.getDescription()).setFieldId(fieldId).toFieldConfigScheme();
    }

    public FieldConfigScheme updateConfig(String fieldId, FieldConfigScheme existingSchee, FieldConfigSchemeBean bean) {
        return new FieldConfigScheme.Builder(existingSchee).setName(bean.getName()).setDescription(StringUtils.defaultString((String)bean.getDescription(), (String)"")).setFieldId(fieldId).toFieldConfigScheme();
    }

    public Collection<ProjectBean> getProjectBeans(Collection<Project> projects) {
        return projects.stream().map(it -> this.projectBeanFactory.fullProject((Project)it, "")).collect(Collectors.toList());
    }

    private Collection<IssueTypeJsonBean> getIssueTypeBeans(Collection<IssueType> issueTypes) {
        return IssueTypeJsonBean.shortBeans(issueTypes, (JiraBaseUrls)this.baseUrls);
    }

    private FieldBean getFieldBean(ConfigurableField<?> field) {
        return FieldBean.shortBean(field, this.fieldManager, this.searchHandlerManager);
    }

    private Object getDefaultValueIfSupported(ConfigurableField<?> field, FieldConfigScheme configScheme) {
        boolean isCustomField = field instanceof CustomField;
        if (!isCustomField && field instanceof DefaultValueField) {
            return ((DefaultValueField)field).getDefaultValueOperations().getDefaultValue(Objects.requireNonNull(configScheme.getOneAndOnlyConfig()));
        }
        return null;
    }
}

