/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.field.renderer;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.fields.renderer.EditorMarkupParameters;
import com.atlassian.jira.issue.fields.renderer.EditorMarkupService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import java.util.Collection;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="field/markup")
@Consumes(value={"application/json"})
@Produces(value={"text/html", "application/json"})
@UnrestrictedAccess
public class EditorMarkupResource {
    private static final int ONE_DAY = 86400;
    private final EditorMarkupService editorMarkupService;

    @Inject
    public EditorMarkupResource(@ComponentImport EditorMarkupService editorMarkupService) {
        this.editorMarkupService = editorMarkupService;
    }

    @POST
    public Response getEditorMarkupForField(@RequestBody EditorMarkupParameters parameters) {
        ServiceOutcome outcome = this.editorMarkupService.getEditorMarkupForField(parameters);
        if (outcome.isValid()) {
            return Response.ok().entity(outcome.get()).cacheControl(this.saveCacheForOneDay()).build();
        }
        return this.errorResponse(outcome.getErrorCollection());
    }

    private Response errorResponse(com.atlassian.jira.util.ErrorCollection errorCollection) {
        ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons());
        if (worstReason == null) {
            worstReason = ErrorCollection.Reason.SERVER_ERROR;
        }
        return Response.status((int)worstReason.getHttpStatusCode()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)ErrorCollection.of(errorCollection)).cacheControl(CacheControl.never()).build();
    }

    private javax.ws.rs.core.CacheControl saveCacheForOneDay() {
        javax.ws.rs.core.CacheControl cacheControl = new javax.ws.rs.core.CacheControl();
        cacheControl.setMaxAge(86400);
        return cacheControl;
    }
}

