/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.user;

import com.atlassian.jira.rest.v2.issue.users.IssueInvolvementBean;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Objects;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class UsersBean {
    @JsonProperty
    public final boolean hasMore;
    @JsonProperty
    public final List<UserBean> users;

    public UsersBean(boolean hasMore, List<UserBean> users) {
        this.hasMore = hasMore;
        this.users = users;
    }

    static class UserBean {
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        public URI avatarUrl;
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        public String displayName;
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        public String emailAddress;
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        public String name;
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        @Nullable
        public List<IssueInvolvementBean> issueInvolvements;
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        @Nullable
        public Integer highestIssueInvolvementRank;
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        @Nullable
        public Long latestCommentCreationTime;

        public UserBean(URI avatarUri, String displayName, String emailAddress, String name) {
            this(avatarUri, displayName, emailAddress, name, null, null, null);
        }

        public UserBean(URI avatarUrl, String displayName, String emailAddress, String name, @Nullable List<IssueInvolvementBean> issueInvolvements, @Nullable Integer highestIssueInvolvementRank, @Nullable Long latestCommentCreationTime) {
            this.avatarUrl = avatarUrl;
            this.displayName = displayName;
            this.emailAddress = emailAddress;
            this.name = name;
            this.issueInvolvements = issueInvolvements;
            this.highestIssueInvolvementRank = highestIssueInvolvementRank;
            this.latestCommentCreationTime = latestCommentCreationTime;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("avatarUrl", (Object)this.avatarUrl).append("displayName", (Object)this.displayName).append("emailAddress", (Object)this.emailAddress).append("name", (Object)this.name).append("issueInvolvements", this.issueInvolvements).append("highestIssueInvolvementRank", (Object)this.highestIssueInvolvementRank).append("latestCommentCreationTime", (Object)this.latestCommentCreationTime).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserBean userBean = (UserBean)o;
            return Objects.equal((Object)this.avatarUrl, (Object)userBean.avatarUrl) && Objects.equal((Object)this.displayName, (Object)userBean.displayName) && Objects.equal((Object)this.emailAddress, (Object)userBean.emailAddress) && Objects.equal((Object)this.name, (Object)userBean.name) && Objects.equal(this.issueInvolvements, userBean.issueInvolvements) && Objects.equal((Object)this.highestIssueInvolvementRank, (Object)userBean.highestIssueInvolvementRank) && Objects.equal((Object)this.latestCommentCreationTime, (Object)userBean.latestCommentCreationTime);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.avatarUrl, this.displayName, this.emailAddress, this.name, this.issueInvolvements, this.highestIssueInvolvementRank, this.latestCommentCreationTime});
        }
    }
}

