/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.util;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.util.ServiceOutcomes;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.util.Function;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ProjectConverter
implements Function<ProjectBean, ServiceOutcome<Project>> {
    private final ProjectManager projectManager;

    public ProjectConverter(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public ServiceOutcome<List<Project>> all(@Nonnull Collection<ProjectBean> beans) {
        return ServiceOutcomes.combine(beans.stream().map(this).collect(Collectors.toList()));
    }

    public ServiceOutcome<Project> apply(@Nonnull ProjectBean input) {
        if (StringUtils.isNotBlank((CharSequence)input.getId())) {
            return this.byId(input.getId());
        }
        if (StringUtils.isNotBlank((CharSequence)input.getKey())) {
            return this.byKey(input.getKey());
        }
        return ServiceOutcomeImpl.error((String)"Could not find project");
    }

    private ServiceOutcome<Project> byId(String id) {
        return (ServiceOutcome)Optional.ofNullable(this.projectManager.getProjectObj(Long.valueOf(Long.parseLong(id)))).map(ServiceOutcomeImpl::ok).orElse(ServiceOutcomeImpl.error((String)("Could not find project with id: " + id)));
    }

    private ServiceOutcome<Project> byKey(String key) {
        return (ServiceOutcome)Optional.ofNullable(this.projectManager.getProjectObjByKey(key)).map(ServiceOutcomeImpl::ok).orElse(ServiceOutcomeImpl.error((String)("Could not find project with key: " + key)));
    }
}

