/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.CodePointTranslator;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.apache.commons.lang3.text.translate.UnicodeEscaper;

public class RestStringUtils {
    private static final CharSequenceTranslator ESCAPE_UNICODE = new LookupTranslator((CharSequence[][])new String[0][]).with(new CharSequenceTranslator[]{new UTF16Escaper()}).with(new CharSequenceTranslator[]{UnicodeEscaper.outsideOf((int)32, (int)127)});

    public static final String escapeUnicode(String input) {
        return ESCAPE_UNICODE.translate((CharSequence)input);
    }

    private static class UTF16Escaper
    extends CodePointTranslator {
        private UTF16Escaper() {
        }

        public boolean translate(int codePoint, Writer out) throws IOException {
            if (codePoint > 65535) {
                int base = codePoint - 65536;
                char low = (char)(56320 + (base & 0x3FF));
                char high = (char)(55296 + (base >> 10 & 0x3FF));
                out.write("\\u" + UTF16Escaper.hex((int)high) + "\\u" + UTF16Escaper.hex((int)low));
                return true;
            }
            return false;
        }
    }
}

