/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.favourites;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.favourites.FavouritesManager;
import com.atlassian.jira.rest.api.messages.TextMessage;
import com.atlassian.jira.rest.v1.model.BooleanResult;
import com.atlassian.jira.rest.v1.model.errors.ErrorCollection;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugins.rest.api.security.annotation.CorsAllowed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Consumes(value={"application/json", "application/xml"})
@Produces(value={"application/json", "application/xml"})
@CorsAllowed
public class FavouriteResource {
    private static final Logger log = LoggerFactory.getLogger(FavouriteResource.class);
    private final JiraAuthenticationContext authContext;
    private final FavouritesService favService;
    private final FavouritesManager favouritesManager;
    private final SharedEntityAccessor.Factory sharedEntityAccessorFactory;
    private final SharedEntity.TypeDescriptor entityType;
    private final Long entityId;

    @Inject
    public FavouriteResource(JiraAuthenticationContext authContext, FavouritesService favService, FavouritesManager favouritesManager, SharedEntityAccessor.Factory sharedEntityAccessorFactory, SharedEntity.TypeDescriptor entityType, Long entityId) {
        Assertions.notNull((String)"authContext", (Object)authContext);
        Assertions.notNull((String)"favService", (Object)favService);
        Assertions.notNull((String)"favouritesManager", (Object)favouritesManager);
        Assertions.notNull((String)"sharedEntityAccessorFactory", (Object)sharedEntityAccessorFactory);
        Assertions.notNull((String)"entityType", (Object)entityType);
        Assertions.notNull((String)"entityId", (Object)entityId);
        this.authContext = authContext;
        this.favService = favService;
        this.favouritesManager = favouritesManager;
        this.sharedEntityAccessorFactory = sharedEntityAccessorFactory;
        this.entityType = entityType;
        this.entityId = entityId;
    }

    @GET
    public Response isFavourite() {
        try {
            SharedEntity entity = this.getSharedEntity();
            return Response.ok((Object)new BooleanResult(this.favService.isFavourite(this.authContext.getUser(), entity))).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (RuntimeException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
    }

    @PUT
    public Response addFavourite() {
        return this.setFavourite(this.entityType, this.entityId, true, null);
    }

    @DELETE
    public Response deleteFavourite() {
        return this.setFavourite(this.entityType, this.entityId, false, null);
    }

    @POST
    public Response undo(OriginalOrder originalOrder) {
        return this.setFavourite(this.entityType, this.entityId, true, originalOrder != null ? originalOrder.getEntries() : null);
    }

    private Response setFavourite(SharedEntity.TypeDescriptor entityType, Long entityId, boolean enable, List<Long> originalOrder) {
        boolean success;
        JiraServiceContext ctx = this.getContext();
        if (log.isDebugEnabled()) {
            log.debug("Set favourite for : " + ctx.getLoggedInApplicationUser() + " (" + entityType + " - " + entityId + ") - " + enable);
        }
        SharedEntity entity = this.getSharedEntity();
        if (enable) {
            if (originalOrder != null) {
                long positionForFavourite = this.getPositionForFavourite(ctx.getLoggedInApplicationUser(), entity, originalOrder);
                this.favService.addFavouriteInPosition(ctx, entity, positionForFavourite);
            } else {
                this.favService.addFavourite(ctx, entity);
            }
        } else {
            this.favService.removeFavourite(ctx, entity);
        }
        boolean bl = success = !ctx.getErrorCollection().hasAnyErrors();
        if (!success) {
            log.debug("Unable to set favourite for : " + ctx.getLoggedInApplicationUser() + " (" + entityType + " - " + entityId + ") - " + enable + ":\n" + ctx.getErrorCollection());
            return Response.status((int)400).entity((Object)ErrorCollection.Builder.newBuilder().addErrorCollection(ctx.getErrorCollection()).build()).cacheControl(CacheControl.NO_CACHE).build();
        }
        if (log.isDebugEnabled()) {
            log.debug("Success in setting favourite for : " + ctx.getLoggedInApplicationUser() + " (" + entityType + " - " + entityId + ") - " + enable);
        }
        return Response.ok((Object)new TextMessage("Success in setting favourite for : " + ctx.getLoggedInApplicationUser() + " (" + entityType + " - " + entityId + ") - favourite state: " + enable)).cacheControl(CacheControl.NO_CACHE).build();
    }

    long getPositionForFavourite(ApplicationUser user, SharedEntity entityToUndo, List<Long> originalOrder) {
        ArrayList<Long> newOrderedEntities = new ArrayList<Long>(originalOrder.size());
        Collection existingIds = this.favouritesManager.getFavouriteIds(user, entityToUndo.getEntityType());
        Long entityToUndoId = entityToUndo.getId();
        for (Long entityId : originalOrder) {
            if (existingIds.contains(entityId)) {
                newOrderedEntities.add(entityId);
                continue;
            }
            if (!entityId.equals(entityToUndoId)) continue;
            return newOrderedEntities.size();
        }
        return -1L;
    }

    private SharedEntity getSharedEntity() {
        SharedEntityAccessor accessor = this.sharedEntityAccessorFactory.getSharedEntityAccessor(this.entityType);
        if (accessor == null) {
            throw new IllegalArgumentException("Unsupported entityType");
        }
        SharedEntity entity = accessor.getSharedEntity(this.authContext.getUser(), this.entityId);
        if (entity == null) {
            throw new IllegalArgumentException(this.getText("common.favourites.entity.not.available"));
        }
        return entity;
    }

    private JiraServiceContext getContext() {
        return new JiraServiceContextImpl(this.authContext.getUser());
    }

    private String getText(String key) {
        return this.authContext.getI18nHelper().getText(key);
    }

    @XmlRootElement
    public static class OriginalOrder {
        @XmlElement
        private List<Long> entries = new ArrayList<Long>();

        private OriginalOrder() {
        }

        public OriginalOrder(List<Long> entries) {
            this.entries = entries;
        }

        public List<Long> getEntries() {
            return this.entries;
        }
    }
}

