/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.rest.v2.ServerInfoBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.plugins.rest.api.security.annotation.CorsAllowed;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import java.util.Date;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="serverInfo")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@CorsAllowed
public class ServerInfoResource {
    private final ApplicationProperties properties;
    private final BuildUtilsInfo buildUtils;
    private final JiraAuthenticationContext authContext;
    private final PermissionManager permissionManager;

    @Inject
    public ServerInfoResource(ApplicationProperties properties, BuildUtilsInfo buildUtils, JiraAuthenticationContext authContext, PermissionManager permissionManager) {
        this.properties = properties;
        this.buildUtils = buildUtils;
        this.authContext = authContext;
        this.permissionManager = permissionManager;
    }

    @GET
    public ServerInfoBean getServerInfo() {
        boolean canUse = this.permissionManager.hasPermission(1, this.authContext.getUser());
        return new ServerInfoBean(this.properties.getString("jira.baseurl"), this.buildUtils.getVersion(), this.buildUtils.getVersionNumbers(), Integer.valueOf(this.buildUtils.getCurrentBuildNumber()), this.buildUtils.getCurrentBuildDate(), this.buildUtils.getDatabaseBuildNumber(), this.buildUtils.getCommitId(), this.buildUtils.getBuildPartnerName(), this.properties.getString("jira.title"), canUse ? new Date() : null);
    }
}

