/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.permissionscheme;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.PermissionGrant;
import com.atlassian.jira.permission.PermissionGrantInput;
import com.atlassian.jira.permission.PermissionScheme;
import com.atlassian.jira.permission.PermissionSchemeAttributeManager;
import com.atlassian.jira.permission.PermissionSchemeInput;
import com.atlassian.jira.permission.PermissionSchemeService;
import com.atlassian.jira.permission.data.PermissionGrantAsPureData;
import com.atlassian.jira.rest.api.permission.PermissionGrantBean;
import com.atlassian.jira.rest.api.permission.PermissionGrantBeanExpander;
import com.atlassian.jira.rest.api.permission.PermissionGrantsBean;
import com.atlassian.jira.rest.api.permission.PermissionSchemeAttributeBean;
import com.atlassian.jira.rest.api.permission.PermissionSchemeBean;
import com.atlassian.jira.rest.api.permission.PermissionSchemeBeansFactory;
import com.atlassian.jira.rest.api.permission.PermissionSchemeExpandParam;
import com.atlassian.jira.rest.api.permission.PermissionSchemesBean;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Either;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="permissionscheme")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@WebSudoRequired
public final class PermissionSchemeResource {
    public static final String RESOURCE_PATH = "permissionscheme";
    public static final String ENTITY_PATH = "permission";
    private static final Logger logger = LoggerFactory.getLogger(PermissionSchemeResource.class);
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionSchemeBeansFactory beansFactory;
    private final PermissionGrantBeanExpander permissionGrantBeanExpander;
    private final PermissionSchemeService permissionSchemeService;
    private final I18nHelper i18n;
    private final ResponseFactory responseFactory;
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionSchemeAttributeManager permissionSchemeAttributeManager;

    @Inject
    public PermissionSchemeResource(JiraAuthenticationContext authenticationContext, PermissionSchemeBeansFactory beansFactory, PermissionGrantBeanExpander permissionGrantBeanExpander, PermissionSchemeService permissionSchemeService, I18nHelper i18n, ResponseFactory responseFactory, GlobalPermissionManager globalPermissionManager, @ComponentImport PermissionSchemeAttributeManager permissionSchemeAttributeManager) {
        this.authenticationContext = authenticationContext;
        this.beansFactory = beansFactory;
        this.permissionGrantBeanExpander = permissionGrantBeanExpander;
        this.permissionSchemeService = permissionSchemeService;
        this.i18n = i18n;
        this.responseFactory = responseFactory;
        this.globalPermissionManager = globalPermissionManager;
        this.permissionSchemeAttributeManager = permissionSchemeAttributeManager;
    }

    @GET
    public Response getPermissionSchemes(@QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on((java.util.function.Function)new java.util.function.Function<List<PermissionSchemeExpandParam>, Response>(){

            @Override
            public Response apply(final List<PermissionSchemeExpandParam> expands) {
                ServiceOutcome permissionSchemes = PermissionSchemeResource.this.permissionSchemeService.getPermissionSchemes(PermissionSchemeResource.this.getUser());
                return (Response)PermissionSchemeResource.this.responseFactory.validateOutcome(permissionSchemes).left().on((java.util.function.Function)new java.util.function.Function<List<PermissionScheme>, Response>(){

                    @Override
                    public Response apply(List<PermissionScheme> permissionSchemes) {
                        ImmutableList result = ImmutableList.copyOf((Iterable)Iterables.transform(permissionSchemes, (Function)new Function<PermissionScheme, PermissionSchemeBean>(){

                            public PermissionSchemeBean apply(PermissionScheme scheme) {
                                return PermissionSchemeResource.this.beansFactory.toBean(scheme, expands);
                            }
                        }));
                        return PermissionSchemeResource.this.responseFactory.okNoCache(new PermissionSchemesBean((Iterable<PermissionSchemeBean>)result));
                    }
                });
            }
        });
    }

    @GET
    @Path(value="{schemeId}")
    public Response getPermissionScheme(final @PathParam(value="schemeId") Long id, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on((java.util.function.Function)new java.util.function.Function<List<PermissionSchemeExpandParam>, Response>(){

            @Override
            public Response apply(final List<PermissionSchemeExpandParam> expands) {
                return (Response)PermissionSchemeResource.this.responseFactory.validateOutcome(PermissionSchemeResource.this.permissionSchemeService.getPermissionScheme(PermissionSchemeResource.this.getUser(), id)).left().on((java.util.function.Function)new java.util.function.Function<PermissionScheme, Response>(){

                    @Override
                    public Response apply(PermissionScheme scheme) {
                        return PermissionSchemeResource.this.responseFactory.okNoCache(PermissionSchemeResource.this.beansFactory.toBean(scheme, expands));
                    }
                });
            }
        });
    }

    @DELETE
    @Path(value="{schemeId}")
    public Response deletePermissionScheme(@PathParam(value="schemeId") Long id) {
        return this.responseFactory.serviceResultToNoContentResponse(this.permissionSchemeService.deletePermissionScheme(this.getUser(), id));
    }

    @POST
    public Response createPermissionScheme(final PermissionSchemeBean permissionScheme, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on((java.util.function.Function)new java.util.function.Function<List<PermissionSchemeExpandParam>, Response>(){

            @Override
            public Response apply(final List<PermissionSchemeExpandParam> expands) {
                return (Response)PermissionSchemeResource.this.toResponse(PermissionSchemeResource.this.beansFactory.fromBean(permissionScheme)).left().on((java.util.function.Function)new java.util.function.Function<PermissionSchemeInput, Response>(){

                    @Override
                    public Response apply(PermissionSchemeInput input) {
                        ServiceOutcome createdScheme = PermissionSchemeResource.this.permissionSchemeService.createPermissionScheme(PermissionSchemeResource.this.getUser(), input);
                        return (Response)PermissionSchemeResource.this.responseFactory.validateOutcome(createdScheme).left().on((java.util.function.Function)new java.util.function.Function<PermissionScheme, Response>(){

                            @Override
                            public Response apply(PermissionScheme scheme) {
                                PermissionSchemeBean created = PermissionSchemeResource.this.beansFactory.toBean(scheme, expands);
                                return PermissionSchemeResource.this.responseFactory.created(created.getSelf(), created);
                            }
                        });
                    }
                });
            }
        });
    }

    @PUT
    @Path(value="{schemeId}")
    public Response updatePermissionScheme(final @PathParam(value="schemeId") Long schemeId, final PermissionSchemeBean permissionScheme, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on((java.util.function.Function)new java.util.function.Function<List<PermissionSchemeExpandParam>, Response>(){

            @Override
            public Response apply(List<PermissionSchemeExpandParam> expands) {
                return PermissionSchemeResource.this.updatePermissionScheme(schemeId, oldScheme -> PermissionSchemeResource.this.beansFactory.fromBean(permissionScheme).map((java.util.function.Function)new java.util.function.Function<PermissionSchemeInput, PermissionSchemeInput>(){

                    @Override
                    public PermissionSchemeInput apply(PermissionSchemeInput newScheme) {
                        if (permissionScheme.getPermissions() == null) {
                            return PermissionSchemeInput.builder((PermissionScheme)oldScheme).setName(newScheme.getName()).setDescription((String)newScheme.getDescription().getOrNull()).build();
                        }
                        return newScheme;
                    }
                }), updatedScheme -> PermissionSchemeResource.this.responseFactory.okNoCache(PermissionSchemeResource.this.beansFactory.toBean((PermissionScheme)updatedScheme, expands)));
            }
        });
    }

    @GET
    @Path(value="{permissionSchemeId}/attribute/{attributeKey}")
    @ExperimentalApi
    public Response getSchemeAttribute(@PathParam(value="permissionSchemeId") Long schemeId, @PathParam(value="attributeKey") String key) {
        return this.asAdmin(() -> {
            Either schemeValidation = this.responseFactory.validateOutcome(this.permissionSchemeService.getPermissionScheme(this.getUser(), schemeId));
            if (schemeValidation.isLeft()) {
                return (Response)schemeValidation.left().get();
            }
            Optional value = this.permissionSchemeAttributeManager.getAttribute(schemeId, key);
            if (value.isPresent()) {
                return this.responseFactory.okNoCache(new PermissionSchemeAttributeBean(key, (String)value.get()));
            }
            return this.responseFactory.errorResponse(ErrorCollections.create((String)this.i18n.getText("rest.permissionscheme.attribute.not.found"), (ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND));
        });
    }

    @PUT
    @Path(value="{permissionSchemeId}/attribute/{key}")
    @Consumes(value={"text/plain"})
    @ExperimentalApi
    public Response setSchemeAttribute(@PathParam(value="permissionSchemeId") Long schemeId, @PathParam(value="key") String key, String value) {
        return this.asAdmin(() -> {
            Either schemeValidation = this.responseFactory.validateOutcome(this.permissionSchemeService.getPermissionScheme(this.getUser(), schemeId));
            if (schemeValidation.isLeft()) {
                return (Response)schemeValidation.left().get();
            }
            String booleanValue = Boolean.toString(Boolean.valueOf(value));
            try {
                this.permissionSchemeAttributeManager.setAttribute(schemeId, key, booleanValue);
                return this.responseFactory.noContent();
            }
            catch (Exception e) {
                String errorMessage = this.i18n.getText("rest.permissionscheme.attribute.update.error");
                logger.error(String.format("%s Details: '%s'", errorMessage, e.getMessage()));
                return this.responseFactory.errorResponse(ErrorCollections.create((String)errorMessage, (ErrorCollection.Reason)ErrorCollection.Reason.SERVER_ERROR));
            }
        });
    }

    @GET
    @Path(value="{schemeId}/permission")
    public Response getPermissionSchemeGrants(final @PathParam(value="schemeId") Long schemeId, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on((java.util.function.Function)new java.util.function.Function<List<PermissionSchemeExpandParam>, Response>(){

            @Override
            public Response apply(final List<PermissionSchemeExpandParam> expands) {
                return (Response)PermissionSchemeResource.this.responseFactory.validateOutcome(PermissionSchemeResource.this.permissionSchemeService.getPermissionScheme(PermissionSchemeResource.this.getUser(), schemeId)).left().on((java.util.function.Function)new java.util.function.Function<PermissionScheme, Response>(){

                    @Override
                    public Response apply(PermissionScheme scheme) {
                        return PermissionSchemeResource.this.responseFactory.okNoCache(new PermissionGrantsBean((Iterable<PermissionGrantBean>)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)scheme.getPermissions(), (Function)new Function<PermissionGrant, PermissionGrantBean>(){

                            public PermissionGrantBean apply(PermissionGrant grant) {
                                return PermissionSchemeResource.this.beansFactory.toBean(grant, schemeId, expands);
                            }
                        }))));
                    }
                });
            }
        });
    }

    @POST
    @Path(value="{schemeId}/permission")
    public Response createPermissionGrant(final @PathParam(value="schemeId") Long schemeId, final PermissionGrantBean grantBean, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on((java.util.function.Function)new java.util.function.Function<List<PermissionSchemeExpandParam>, Response>(){

            @Override
            public Response apply(final List<PermissionSchemeExpandParam> expands) {
                return PermissionSchemeResource.this.asAdmin(() -> (Response)PermissionSchemeResource.this.toResponse(PermissionSchemeResource.this.beansFactory.fromBean(grantBean)).left().on((java.util.function.Function)new java.util.function.Function<PermissionGrantInput, Response>(){

                    @Override
                    public Response apply(PermissionGrantInput newPermission) {
                        return PermissionSchemeResource.this.updatePermissionScheme(schemeId, oldScheme -> PermissionSchemeResource.this.validateThatNewPermissionDoesNotAlreadyExist(oldScheme, newPermission).map((java.util.function.Function)new java.util.function.Function<PermissionGrantInput, PermissionSchemeInput>(){

                            @Override
                            public PermissionSchemeInput apply(PermissionGrantInput input) {
                                return PermissionSchemeInput.builder((PermissionScheme)oldScheme).addPermission(input).build();
                            }
                        }), newScheme -> {
                            PermissionGrant createdPermission = (PermissionGrant)Iterables.find((Iterable)newScheme.getPermissions(), (Predicate)PermissionGrantAsPureData.equalToModuloId((PermissionGrantInput)newPermission));
                            PermissionGrantBean createdPermissionBean = PermissionSchemeResource.this.beansFactory.toBean(createdPermission, schemeId, expands);
                            return PermissionSchemeResource.this.responseFactory.created(createdPermissionBean.getSelf(), createdPermissionBean);
                        });
                    }
                }));
            }
        });
    }

    @DELETE
    @Path(value="{schemeId}/permission/{permissionId}")
    public Response deletePermissionSchemeEntity(@PathParam(value="schemeId") Long schemeId, final @PathParam(value="permissionId") Long permissionId) {
        return this.asAdmin(() -> this.updatePermissionScheme(schemeId, (PermissionScheme scheme) -> {
            if (!this.findPermissionGrant((PermissionScheme)scheme, permissionId).isPresent()) {
                return Either.left((Object)ErrorCollections.create((String)this.i18n.getText("rest.permissionscheme.permission.grant.does.not.exist", permissionId.toString()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED));
            }
            Iterable newPermissionSet = Iterables.filter((Iterable)scheme.getPermissions(), (Predicate)new Predicate<PermissionGrant>(){

                public boolean apply(PermissionGrant grant) {
                    return !grant.getId().equals(permissionId);
                }
            });
            return Either.right((Object)PermissionSchemeInput.builder((PermissionScheme)scheme).setOriginalPermissions(newPermissionSet).build());
        }, (PermissionScheme input) -> this.responseFactory.noContent()));
    }

    private Response updatePermissionScheme(final Long schemeId, final java.util.function.Function<PermissionScheme, Either<ErrorCollection, PermissionSchemeInput>> oldToNew, final java.util.function.Function<PermissionScheme, Response> newSchemeToResponse) {
        return (Response)this.responseFactory.validateOutcome(this.permissionSchemeService.getPermissionScheme(this.getUser(), schemeId)).left().on((java.util.function.Function)new java.util.function.Function<PermissionScheme, Response>(){

            @Override
            public Response apply(PermissionScheme scheme) {
                return (Response)PermissionSchemeResource.this.toResponse((Either)oldToNew.apply(scheme)).left().on((java.util.function.Function)new java.util.function.Function<PermissionSchemeInput, Response>(){

                    @Override
                    public Response apply(PermissionSchemeInput newScheme) {
                        return (Response)PermissionSchemeResource.this.responseFactory.validateOutcome(PermissionSchemeResource.this.permissionSchemeService.updatePermissionScheme(PermissionSchemeResource.this.getUser(), schemeId, newScheme)).left().on((java.util.function.Function)new java.util.function.Function<PermissionScheme, Response>(){

                            @Override
                            public Response apply(PermissionScheme createdScheme) {
                                return (Response)newSchemeToResponse.apply(createdScheme);
                            }
                        });
                    }
                });
            }
        });
    }

    @GET
    @Path(value="{schemeId}/permission/{permissionId}")
    public Response getPermissionSchemeGrant(final @PathParam(value="schemeId") Long schemeId, final @PathParam(value="permissionId") Long permissionId, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on((java.util.function.Function)new java.util.function.Function<List<PermissionSchemeExpandParam>, Response>(){

            @Override
            public Response apply(final List<PermissionSchemeExpandParam> expands) {
                return (Response)PermissionSchemeResource.this.responseFactory.validateOutcome(PermissionSchemeResource.this.permissionSchemeService.getPermissionScheme(PermissionSchemeResource.this.getUser(), schemeId)).left().on((java.util.function.Function)new java.util.function.Function<PermissionScheme, Response>(){

                    @Override
                    public Response apply(PermissionScheme permissionScheme) {
                        com.google.common.base.Optional maybeEntity = PermissionSchemeResource.this.findPermissionGrant(permissionScheme, permissionId);
                        if (maybeEntity.isPresent()) {
                            return PermissionSchemeResource.this.responseFactory.okNoCache(PermissionSchemeResource.this.beansFactory.toBean((PermissionGrant)maybeEntity.get(), schemeId, expands));
                        }
                        return PermissionSchemeResource.this.responseFactory.errorResponse(ErrorCollections.create((String)PermissionSchemeResource.this.i18n.getText("rest.permissionscheme.permission.grant.does.not.exist", permissionId.toString()), (ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND));
                    }
                });
            }
        });
    }

    private com.google.common.base.Optional<PermissionGrant> findPermissionGrant(PermissionScheme permissionScheme, final Long permissionId) {
        return Iterables.tryFind((Iterable)permissionScheme.getPermissions(), (Predicate)new Predicate<PermissionGrant>(){

            public boolean apply(PermissionGrant grant) {
                return grant.getId().equals(permissionId);
            }
        });
    }

    private ApplicationUser getUser() {
        return this.authenticationContext.getUser();
    }

    private Either<Response, List<PermissionSchemeExpandParam>> withParsedExpandParameter(String parameter) {
        return this.toResponse(this.permissionGrantBeanExpander.parseExpandQuery(parameter));
    }

    private <T> Either<Response, T> toResponse(Either<ErrorCollection, T> either) {
        return this.responseFactory.toResponse(either);
    }

    private Either<ErrorCollection, PermissionGrantInput> validateThatNewPermissionDoesNotAlreadyExist(PermissionScheme oldScheme, PermissionGrantInput newPermission) {
        if (Iterables.contains((Iterable)Iterables.transform((Iterable)oldScheme.getPermissions(), (Function)PermissionGrantAsPureData.TO_PURE_DATA), (Object)PermissionGrantAsPureData.of((PermissionGrantInput)newPermission))) {
            return Either.left((Object)ErrorCollections.create((String)this.i18n.getText("rest.permissionscheme.permission.already.exists", newPermission.getPermission().permissionKey(), newPermission.getHolder().getType().toString(), (String)newPermission.getHolder().getParameter().getOrNull(), oldScheme.getId().toString()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED));
        }
        return Either.right((Object)newPermission);
    }

    public Response asAdmin(RestAction action) {
        if (this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.getUser())) {
            return action.perform();
        }
        return this.responseFactory.errorResponse(ErrorCollections.create((String)this.i18n.getText("rest.permissionscheme.forbidden"), (ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN));
    }

    private static interface RestAction {
        public Response perform();
    }
}

