/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.dashboard;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.rest.api.dashboard.DashboardBean;
import com.atlassian.jira.rest.api.dashboard.DashboardsBean;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.search.SharedEntitySearchContext;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchParametersBuilder;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
@Path(value="dashboard")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DashboardResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PortalPageService portalPageService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final JiraBaseUrls jiraBaseUrls;
    private final UriInfo uriInfo;
    private final FeatureManager featureManager;
    private final GlobalPermissionManager permissionManager;

    @Inject
    public DashboardResource(JiraAuthenticationContext jiraAuthenticationContext, PortalPageService portalPageService, I18nHelper.BeanFactory i18nFactory, JiraBaseUrls jiraBaseUrls, UriInfo uriInfo, FeatureManager featureManager, GlobalPermissionManager permissionManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.portalPageService = portalPageService;
        this.i18nFactory = i18nFactory;
        this.jiraBaseUrls = jiraBaseUrls;
        this.uriInfo = uriInfo;
        this.featureManager = featureManager;
        this.permissionManager = permissionManager;
    }

    @GET
    public Response list(@QueryParam(value="filter") String filter, @QueryParam(value="startAt") Integer startAtParam, @QueryParam(value="maxResults") Integer maxResultsParam) {
        int startAt;
        int n = startAt = startAtParam != null ? Math.max(startAtParam, 0) : 0;
        if (maxResultsParam != null && maxResultsParam != 0 && startAt % maxResultsParam != 0) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n().getText("rest.dashboard.invalid.startAt", String.valueOf(maxResultsParam), String.valueOf(startAt))));
        }
        int maxResults = maxResultsParam == null ? (startAt != 0 ? startAt : 20) : (maxResultsParam < 0 ? 20 : Math.min(maxResultsParam, 1000));
        DashboardsBean dashboards = null;
        if ("favourite".equals(filter)) {
            dashboards = this.search(this.searchParams().setFavourite(Boolean.valueOf(true)).toSearchParameters(), startAt, maxResults);
        } else if ("my".equals(filter)) {
            ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
            dashboards = user == null ? new DashboardsBean().startAt(startAt).maxResults(maxResults).total(0).dashboards(Collections.emptyList()) : this.search(this.searchParams().setUserName(user.getUsername()).toSearchParameters(), startAt, maxResults);
        } else if (StringUtils.isBlank((CharSequence)filter)) {
            dashboards = this.search(this.searchParams().toSearchParameters(), startAt, maxResults);
        }
        if (dashboards != null) {
            dashboards = this.addPreviousNextLinks(filter, startAt, maxResults, dashboards);
            return Response.ok().entity((Object)dashboards).cacheControl(CacheControl.never()).build();
        }
        throw new BadRequestWebException(ErrorCollection.of(this.i18n().getText("rest.dashboard.filter.bad.param", filter, "filter", "'favourite', 'my'")));
    }

    @GET
    @Path(value="{id}")
    public Response getDashboard(@PathParam(value="id") String id) {
        PortalPage portalPage = null;
        try {
            portalPage = this.portalPageService.getPortalPage((JiraServiceContext)this.makeContext(), Long.valueOf(id));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (portalPage != null) {
            return Response.ok().entity((Object)this.buildDashboardBean(portalPage)).cacheControl(CacheControl.never()).build();
        }
        throw new NotFoundWebException(ErrorCollection.of(this.i18n().getText("rest.dashboard.not.found", id)));
    }

    private DashboardsBean search(SharedEntitySearchParameters searchParams, Integer startAt, Integer maxResults) {
        List results;
        int total;
        if (searchParams.getFavourite() != null && searchParams.getFavourite().booleanValue()) {
            Collection allFavourites = this.portalPageService.getFavouritePortalPages(this.jiraAuthenticationContext.getLoggedInUser());
            total = allFavourites.size();
            results = startAt > total ? Collections.emptyList() : Lists.newArrayList((Iterable)allFavourites).subList(startAt, Math.min(total, startAt + maxResults));
        } else {
            SharedEntitySearchResult searchResults = this.portalPageService.search((JiraServiceContext)this.makeContext(), searchParams, this.toPageNumber(startAt, maxResults), maxResults == 0 ? 1 : maxResults);
            total = searchResults.getTotalResultCount();
            results = maxResults == 0 ? Collections.emptyList() : searchResults.getResults();
        }
        return this.makeResponse(startAt, maxResults, total, results);
    }

    private DashboardsBean addPreviousNextLinks(String filter, int startAt, int maxResults, DashboardsBean dashboards) {
        UriBuilder builder = this.uriInfo.getBaseUriBuilder().path(DashboardResource.class).replaceQueryParam("maxResults", new Object[]{maxResults});
        if (filter != null) {
            builder = builder.queryParam("filter", new Object[]{filter});
        }
        if (startAt > 0) {
            dashboards = dashboards.prev(builder.replaceQueryParam("startAt", new Object[]{startAt - maxResults}).build(new Object[0]).toString());
        }
        if (maxResults != 0 && startAt + dashboards.dashboards().size() < dashboards.total()) {
            dashboards = dashboards.next(builder.replaceQueryParam("startAt", new Object[]{startAt + maxResults}).build(new Object[0]).toString());
        }
        return dashboards;
    }

    private DashboardsBean makeResponse(int startAt, int maxResults, int total, Iterable<PortalPage> portalPages) {
        ArrayList dashboards = Lists.newArrayList();
        for (PortalPage page : portalPages) {
            dashboards.add(this.buildDashboardBean(page));
        }
        return new DashboardsBean().startAt(startAt).maxResults(maxResults).total(total).dashboards(dashboards);
    }

    private DashboardBean buildDashboardBean(PortalPage portalPage) {
        return new DashboardBean(String.valueOf(portalPage.getId()), portalPage.getName(), this.selfLinkFor(portalPage), this.viewLinkFor(portalPage));
    }

    private String selfLinkFor(PortalPage page) {
        return String.format("%s%s/%s", this.jiraBaseUrls.restApi2BaseUrl(), "dashboard", page.getId());
    }

    private String viewLinkFor(PortalPage page) {
        return String.format("%s/secure/Dashboard.jspa?selectPageId=%d", this.jiraBaseUrls.baseUrl(), page.getId());
    }

    private SharedEntitySearchParametersBuilder searchParams() {
        SharedEntitySearchParametersBuilder builder = new SharedEntitySearchParametersBuilder();
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS) && this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.jiraAuthenticationContext.getLoggedInUser())) {
            builder.setEntitySearchContext(SharedEntitySearchContext.ADMINISTER);
        }
        return builder;
    }

    private JiraServiceContextImpl makeContext() {
        return new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser());
    }

    private int toPageNumber(int startAt, int maxResults) {
        return maxResults != 0 ? startAt / maxResults : 1;
    }

    private I18nHelper i18n() {
        return this.i18nFactory.getInstance(this.jiraAuthenticationContext.getLoggedInUser());
    }
}

