/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.entity.property;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.util.RestStringUtils;
import com.atlassian.jira.rest.v2.entity.property.EntityPropertiesKeysBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;

public class BasePropertyResource<E extends WithId> {
    private final EntityPropertyService<E> entityPropertyService;
    private final JiraAuthenticationContext authContext;
    private final JiraBaseUrls jiraBaseUrls;
    private final I18nHelper i18n;
    private final EntityPropertyType entityPropertyType;
    private final BiFunction<Long, String, String> entityIdAndPropertyKeyToSelfFunction;
    private final ObjectMapper minimalistObjectMapper;

    @Inject
    public BasePropertyResource(EntityPropertyService<E> entityPropertyService, JiraAuthenticationContext authContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n, BiFunction<Long, String, String> entityIdAndPropertyKeyToSelfFunction, EntityPropertyType entityPropertyType) {
        this.entityPropertyService = entityPropertyService;
        this.authContext = authContext;
        this.jiraBaseUrls = jiraBaseUrls;
        this.i18n = i18n;
        this.entityPropertyType = (EntityPropertyType)Preconditions.checkNotNull((Object)entityPropertyType);
        this.entityIdAndPropertyKeyToSelfFunction = (BiFunction)Preconditions.checkNotNull(entityIdAndPropertyKeyToSelfFunction);
        this.minimalistObjectMapper = new ObjectMapper();
        this.minimalistObjectMapper.disable(SerializationFeature.INDENT_OUTPUT);
    }

    public BasePropertyResource<E> withSelfFunction(BiFunction<Long, String, String> selfFunction) {
        return new BasePropertyResource<E>(this.entityPropertyService, this.authContext, this.jiraBaseUrls, this.i18n, selfFunction, this.entityPropertyType);
    }

    public Response getPropertiesKeys(String id) {
        ApplicationUser user = this.authContext.getLoggedInUser();
        EntityPropertyService.PropertyKeys<E> propertyKeys = this.getPropertiesKeys(user, id);
        if (propertyKeys.isValid()) {
            EntityPropertiesKeysBean entity = EntityPropertiesKeysBean.build(this.jiraBaseUrls, ((WithId)propertyKeys.getEntity()).getId(), propertyKeys.getKeys(), this.entityIdAndPropertyKeyToSelfFunction);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).cacheControl(CacheControl.never()).build();
        }
        return this.error(propertyKeys.getErrorCollection());
    }

    public Response setProperty(String id, String propertyKey, HttpServletRequest request) {
        ApplicationUser user = this.authContext.getLoggedInUser();
        EntityPropertyService.SetPropertyValidationResult setValidationResult = this.validateSetProperty(user, new EntityPropertyService.PropertyInput(this.propertyValue(request), propertyKey), id);
        if (setValidationResult.isValid()) {
            EntityPropertyService.PropertyResult property = this.getProperty(user, propertyKey, id);
            EntityPropertyService.PropertyResult propertyResult = this.entityPropertyService.setProperty(user, setValidationResult);
            if (!propertyResult.isValid()) {
                return this.error(propertyResult.getErrorCollection());
            }
            return (Response)property.getEntityProperty().fold(() -> Response.status((Response.Status)Response.Status.CREATED).cacheControl(CacheControl.never()).build(), entityProperty -> Response.status((Response.Status)Response.Status.OK).cacheControl(CacheControl.never()).build());
        }
        return this.error(setValidationResult.getErrorCollection());
    }

    public Response getProperty(String entityId, String propertyKey) {
        ApplicationUser user = this.authContext.getLoggedInUser();
        EntityPropertyService.PropertyResult propertyResult = this.getProperty(user, propertyKey, entityId);
        if (propertyResult.isValid()) {
            Option property = propertyResult.getEntityProperty();
            return (Response)property.fold(this.propertyDoesNotExist(propertyKey), this.propertyBean());
        }
        return this.error(propertyResult.getErrorCollection());
    }

    private Supplier<Response> propertyDoesNotExist(String propertyKey) {
        return () -> {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addErrorMessage(this.i18n.getText("jira.properties.service.property.does.not.exist", propertyKey), ErrorCollection.Reason.NOT_FOUND);
            return this.error((com.atlassian.jira.util.ErrorCollection)errorCollection);
        };
    }

    private Function<EntityProperty, Response> propertyBean() {
        return entityProperty -> {
            EntityPropertyBean entityPropertyBean = EntityPropertyBean.builder((JiraBaseUrls)this.jiraBaseUrls, this.entityIdAndPropertyKeyToSelfFunction).value(this.jacksonSafeJsonValue(entityProperty.getValue())).key(entityProperty.getKey()).build(entityProperty.getEntityId());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entityPropertyBean).cacheControl(CacheControl.never()).build();
        };
    }

    private String jacksonSafeJsonValue(String storedJSON) {
        String serialisedJSON = storedJSON;
        try {
            JsonNode jsonNode = this.minimalistObjectMapper.readTree(serialisedJSON);
            serialisedJSON = this.minimalistObjectMapper.writeValueAsString((Object)jsonNode);
            serialisedJSON = RestStringUtils.escapeUnicode(serialisedJSON);
            return serialisedJSON;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("The JSON stored against an entity is, unexpectedly, not valid JSON - '%s'", storedJSON), e);
        }
    }

    public Response deleteProperty(String id, String propertyKey) {
        ApplicationUser user = this.authContext.getLoggedInUser();
        EntityPropertyService.DeletePropertyValidationResult deleteValidationResult = this.validateDeleteProperty(user, propertyKey, id);
        if (deleteValidationResult.isValid()) {
            this.entityPropertyService.deleteProperty(user, deleteValidationResult);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
        }
        return this.error(deleteValidationResult.getErrorCollection());
    }

    protected EntityPropertyService.PropertyKeys<E> getPropertiesKeys(ApplicationUser user, String id) {
        return this.withIdValidation(id, entityId -> this.entityPropertyService.getPropertiesKeys(user, entityId));
    }

    protected EntityPropertyService.PropertyResult getProperty(ApplicationUser user, String propertyKey, String id) {
        return this.withIdValidation(id, entityId -> this.entityPropertyService.getProperty(user, entityId, propertyKey));
    }

    protected EntityPropertyService.DeletePropertyValidationResult validateDeleteProperty(ApplicationUser user, String propertyKey, String id) {
        return this.withIdValidation(id, id1 -> this.entityPropertyService.validateDeleteProperty(user, id1, propertyKey));
    }

    protected EntityPropertyService.SetPropertyValidationResult validateSetProperty(ApplicationUser user, EntityPropertyService.PropertyInput propertyInput, String id) {
        return this.withIdValidation(id, entityId -> this.entityPropertyService.validateSetProperty(user, entityId, propertyInput));
    }

    protected <T> T withIdValidation(String id, Function<Long, T> idFunction) {
        return idFunction.apply(this.getLongOrBadRequest(id));
    }

    private Response error(com.atlassian.jira.util.ErrorCollection errorCollection) {
        ErrorCollection.Reason reason = (ErrorCollection.Reason)Option.option((Object)ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons())).getOrElse((Object)ErrorCollection.Reason.SERVER_ERROR);
        return Response.status((int)reason.getHttpStatusCode()).entity((Object)ErrorCollection.of(errorCollection)).cacheControl(CacheControl.never()).build();
    }

    private Long getLongOrBadRequest(String idOrKey) {
        try {
            return Long.parseLong(idOrKey);
        }
        catch (NumberFormatException e) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addErrorMessage(this.i18n.getText("jira.properties.service.property.invalid.entity", this.i18n.getText(this.entityPropertyType.getI18nKeyForEntityName())));
            throw new BadRequestWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
        }
    }

    private String propertyValue(HttpServletRequest request) {
        try {
            InputStream limitInputStream = ByteStreams.limit((InputStream)request.getInputStream(), (long)32769L);
            byte[] bytes = IOUtils.toByteArray((InputStream)limitInputStream);
            if (bytes.length > 32768) {
                throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("jira.properties.service.length.unknown", (Object)32768)));
            }
            return new String(bytes, Charset.forName(ComponentAccessor.getApplicationProperties().getEncoding()));
        }
        catch (IOException e) {
            throw new BadRequestWebException(ErrorCollection.of(e.getMessage()));
        }
    }
}

