/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.index;

import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.index.request.ReindexRequest;
import com.atlassian.jira.index.request.ReindexRequestService;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.rest.v2.index.ReindexRequestBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="reindex/request")
public class ReindexRequestResource {
    private static final Logger log = LoggerFactory.getLogger(ReindexRequestResource.class);
    private final ReindexRequestService reindexRequestService;

    @Inject
    public ReindexRequestResource(ReindexRequestService reindexRequestService) {
        this.reindexRequestService = reindexRequestService;
    }

    @POST
    public Response processRequests() {
        try {
            Set requests = this.reindexRequestService.processRequests(EnumSet.allOf(ReindexRequestType.class), true);
            ArrayList requestIds = new ArrayList();
            for (ReindexRequest request : requests) {
                requestIds.addAll(request.getAllRequestIds());
            }
            Collections.sort(requestIds);
            return Response.ok(requestIds).build();
        }
        catch (PermissionException e) {
            log.error("Permission error processing reindex requests: " + (Object)((Object)e), (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (RuntimeException e) {
            log.error("Error processing reindex requests: " + e, (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="{requestId}")
    public Response getProgress(@PathParam(value="requestId") long requestId) {
        ReindexRequest request = this.reindexRequestService.getReindexProgress(requestId);
        if (request == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new ReindexRequestBean(request)).build();
    }

    @GET
    @Path(value="bulk")
    public List<ReindexRequestBean> getProgressBulk(@QueryParam(value="requestId") Set<Long> requestIds) {
        Set requests = this.reindexRequestService.getReindexProgress(requestIds);
        ArrayList<ReindexRequestBean> beans = new ArrayList<ReindexRequestBean>();
        for (ReindexRequest request : requests) {
            beans.add(new ReindexRequestBean(request));
        }
        return beans;
    }
}

