/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.ProjectSystemField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinksBeanBuilderFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueRefJsonBean;
import com.atlassian.jira.plugin.customfield.CustomFieldRestSerializer;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import com.atlassian.jira.rest.api.issue.JsonTypeBean;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.IssueResource;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import com.atlassian.jira.rest.v2.issue.TransitionBean;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.extras.ImmutableMaps;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class IssueBeanBuilder2 {
    public static final Integer FIRST_REPRESENTATION_VERSION = 1;
    private static final Logger LOG = LoggerFactory.getLogger(IssueBeanBuilder2.class);
    private final FieldLayoutManager fieldLayoutManager;
    private final JiraAuthenticationContext authContext;
    private final FieldManager fieldManager;
    private final ResourceUriBuilder resourceUriBuilder;
    private final BeanBuilderFactory beanBuilderFactory;
    private final IssueLinksBeanBuilderFactory issueLinkBeanBuilderFactory;
    private final IssueWorkflowManager issueWorkflowManager;
    private final Predicate<Field> fieldIncluded;
    private final Map<Long, IssueRefJsonBean> issueRefsByParentId;
    private final Map<IssueContext, List<FieldLayoutItem>> fieldLayoutItemsByIssueContext;
    private final Map<Field, String> fieldNames;
    private final UriBuilder uriBuilder;
    private final String expand;
    private Supplier<String> parentLinkName = Suppliers.memoize((Supplier)new Supplier<String>(){

        public String get() {
            return IssueBeanBuilder2.this.authContext.getI18nHelper().getText("issue.field.parent");
        }
    });
    private Supplier<List<NavigableField>> includedNavigableFields = Suppliers.memoize((Supplier)new Supplier<List<NavigableField>>(){

        public List<NavigableField> get() {
            try {
                Set fields = IssueBeanBuilder2.this.fieldManager.getAvailableNavigableFields(IssueBeanBuilder2.this.authContext.getLoggedInUser());
                return ImmutableList.copyOf((Collection)fields.stream().filter(IssueBeanBuilder2.this.fieldIncluded).collect(Collectors.toSet()));
            }
            catch (FieldException e) {
                return Collections.emptyList();
            }
        }
    });
    private IncludedFields fieldsToInclude;

    public IssueBeanBuilder2(FieldLayoutManager fieldLayoutManager, JiraAuthenticationContext authContext, FieldManager fieldManager, ResourceUriBuilder resourceUriBuilder, BeanBuilderFactory beanBuilderFactory, final IncludedFields fieldsToInclude, IssueLinksBeanBuilderFactory issueLinkBeanBuilderFactory, IssueWorkflowManager issueWorkflowManager, UriBuilder uriBuilder, String expand) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.authContext = authContext;
        this.fieldManager = fieldManager;
        this.resourceUriBuilder = resourceUriBuilder;
        this.beanBuilderFactory = beanBuilderFactory;
        this.fieldsToInclude = fieldsToInclude;
        this.issueLinkBeanBuilderFactory = issueLinkBeanBuilderFactory;
        this.issueWorkflowManager = issueWorkflowManager;
        this.uriBuilder = uriBuilder;
        this.expand = expand;
        this.fieldIncluded = fieldsToInclude == null ? x -> true : new Predicate<Field>(){

            @Override
            public boolean test(Field field) {
                return fieldsToInclude.included(field);
            }
        };
        this.issueRefsByParentId = new HashMap<Long, IssueRefJsonBean>();
        this.fieldLayoutItemsByIssueContext = new HashMap<IssueContext, List<FieldLayoutItem>>();
        this.fieldNames = new HashMap<Field, String>();
    }

    public IssueBean build(Issue issue) {
        Map<String, FieldData> fieldData = this.createFieldsData(issue);
        URI selfUri = this.resourceUriBuilder.build(this.uriBuilder.clone(), IssueResource.class, String.valueOf(issue.getId()));
        IssueBean bean = new IssueBean(issue.getId(), issue.getKey(), selfUri);
        bean.setFieldsToInclude(this.fieldsToInclude);
        Option<IssueRefJsonBean> parentLink = this.createParentLink(issue);
        if (this.isExpanded("versionedRepresentations")) {
            bean.addVersionedRepresentations(this.createVersionedRepresentations(fieldData, issue));
        } else {
            bean.addFields(this.createFields(fieldData));
        }
        if (parentLink.isDefined()) {
            bean.addParentField((IssueRefJsonBean)parentLink.get(), (String)this.parentLinkName.get());
        }
        if (this.isExpanded("renderedFields")) {
            bean.addRenderedFields(this.createRenderableFields(fieldData));
        }
        if (this.isExpanded("names")) {
            bean.addNames(this.createFieldNames(fieldData));
        }
        if (this.isExpanded("schema")) {
            bean.addSchema(this.createFieldSchema(fieldData));
        }
        if (this.isExpanded("transitions")) {
            bean.addTransitionBeans(this.createTransitionBeans(issue));
        }
        if (this.isExpanded("operations")) {
            bean.setOperations(this.beanBuilderFactory.newOpsbarBeanBuilder(issue).build());
        }
        if (this.isExpanded("editmeta")) {
            bean.setEditMeta(this.beanBuilderFactory.newEditMetaBeanBuilder().issue(issue).fieldsToInclude(this.fieldsToInclude).build());
        }
        if (this.isExpanded("changelog")) {
            bean.setChangelog(this.beanBuilderFactory.newChangelogBeanBuilder().build(issue));
        }
        return bean;
    }

    private Map<String, FieldData> createFieldsData(Issue issue) {
        boolean renderedFields = this.isExpanded("renderedFields");
        ArrayList orderableFieldData = Lists.newArrayList(this.createFieldsDataFromOrderable(issue, renderedFields));
        HashSet fieldKeys = Sets.newHashSet((Iterable)Iterables.transform((Iterable)orderableFieldData, (Function)new Function<FieldData, String>(){

            public String apply(FieldData fieldData) {
                return fieldData.field.getId();
            }
        }));
        Iterable<FieldData> navigableFieldData = this.createFieldsDataFromNavigable(issue, fieldKeys, renderedFields);
        return Maps.uniqueIndex((Iterable)Iterables.concat((Iterable)orderableFieldData, navigableFieldData), (Function)new Function<FieldData, String>(){

            public String apply(FieldData fieldData) {
                return fieldData.field.getId();
            }
        });
    }

    private Iterable<FieldData> createFieldsDataFromOrderable(Issue issue, boolean renderedFields) {
        List includedFieldLayoutItems = this.fieldLayoutItemsByIssueContext.computeIfAbsent((IssueContext)new IssueContextImpl(issue.getProjectId(), issue.getIssueTypeId()), k -> {
            FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(issue);
            return fieldLayout.getVisibleLayoutItems(issue.getProjectObject(), CollectionBuilder.list((Object[])new String[]{issue.getIssueTypeId()})).stream().filter(fieldLayoutItem -> this.fieldIncluded.test((Field)fieldLayoutItem.getOrderableField())).collect(Collectors.toList());
        });
        return io.atlassian.fugue.Iterables.collect((Iterable)includedFieldLayoutItems, fieldLayoutItem -> {
            OrderableField field = fieldLayoutItem.getOrderableField();
            if (field instanceof RestAwareField) {
                return this.createFieldData((Field)field, this.getRepresentationForFields((FieldLayoutItem)fieldLayoutItem, field, issue, renderedFields));
            }
            LOG.info(String.format("OrderableField %s not rendered in JSON", field.getId()));
            return Option.none();
        });
    }

    private Option<FieldJsonRepresentation> getRepresentationForFields(FieldLayoutItem fieldLayoutItem, OrderableField field, Issue issue, boolean renderedFields) {
        try {
            FieldJsonRepresentation representation = ((RestAwareField)field).getJsonFromIssue(issue, renderedFields, fieldLayoutItem);
            if (representation == null || representation.getStandardData() == null) {
                return Option.none();
            }
            return Option.some((Object)representation);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Cannot get value from RestAwareField %s, exception: '%s' ", field.getId(), e.getMessage()), (Throwable)e);
            } else {
                LOG.info(String.format("Cannot get value from RestAwareField %s, exception: '%s' ", field.getId(), e.getMessage()));
            }
            return Option.none();
        }
    }

    private Iterable<FieldData> createFieldsDataFromNavigable(final Issue issue, final Set<String> fieldsInBean, final boolean renderedFields) {
        Predicate<NavigableField> isNotInBean = new Predicate<NavigableField>(){

            @Override
            public boolean test(NavigableField field) {
                return !fieldsInBean.contains(field.getId());
            }
        };
        Predicate<NavigableField> isNotOrderableExceptIsSpecial = new Predicate<NavigableField>(){

            @Override
            public boolean test(NavigableField field) {
                return !(field instanceof OrderableField) || IssueBeanBuilder2.this.isSpecialField(field);
            }
        };
        Iterable navigableFields = ((List)this.includedNavigableFields.get()).stream().filter(isNotInBean.and(isNotOrderableExceptIsSpecial)).collect(Collectors.toList());
        Iterable restAwareNavigableFields = Iterables.filter((Iterable)navigableFields, RestAwareField.class);
        return io.atlassian.fugue.Iterables.collect((Iterable)restAwareNavigableFields, (java.util.function.Function)new java.util.function.Function<RestAwareField, Option<FieldData>>(){

            @Override
            public Option<FieldData> apply(RestAwareField field) {
                return IssueBeanBuilder2.this.createFieldData((Field)field, (Option<FieldJsonRepresentation>)Option.option((Object)field.getJsonFromIssue(issue, renderedFields, null)));
            }
        });
    }

    @VisibleForTesting
    Option<FieldData> createFieldData(final Field field, Option<FieldJsonRepresentation> representation) {
        return representation.map((java.util.function.Function)new java.util.function.Function<FieldJsonRepresentation, FieldData>(){

            @Override
            public FieldData apply(FieldJsonRepresentation representation) {
                return new FieldData(field, representation);
            }
        });
    }

    private Map<String, Object> createFields(Map<String, FieldData> fields) {
        return fields.entrySet().stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), ((FieldData)v.getValue()).getJsonData().getData()), HashMap::putAll);
    }

    private Option<IssueRefJsonBean> createParentLink(Issue issue) {
        Long parentId = issue.getParentId();
        if (parentId == null) {
            return Option.none();
        }
        return Option.some((Object)this.issueRefsByParentId.computeIfAbsent(parentId, x -> this.issueLinkBeanBuilderFactory.newIssueLinksBeanBuilder(issue).buildParentLink()));
    }

    private Map<String, Object> createRenderableFields(Map<String, FieldData> fields) {
        return fields.entrySet().stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), ((FieldData)v.getValue()).getRenderedData().map(json -> json.getData()).getOrNull()), HashMap::putAll);
    }

    private Map<String, String> createFieldNames(Map<String, FieldData> fields) {
        return fields.entrySet().stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), this.fieldNames.computeIfAbsent(((FieldData)v.getValue()).field, Field::getName)), HashMap::putAll);
    }

    private Map<String, JsonTypeBean> createFieldSchema(Map<String, FieldData> fields) {
        return fields.entrySet().stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), ((FieldData)v.getValue()).getJsonTypeBean()), HashMap::putAll);
    }

    private List<TransitionBean> createTransitionBeans(Issue issue) {
        List sortedAvailableActions = this.issueWorkflowManager.getSortedAvailableActions(issue, this.authContext.getUser());
        return ImmutableList.copyOf((Collection)sortedAvailableActions.stream().map(action -> this.beanBuilderFactory.newTransitionMetaBeanBuilder().issue(issue).action((ActionDescriptor)action).build()).collect(Collectors.toList()));
    }

    private Map<String, Map<Integer, Object>> createVersionedRepresentations(Map<String, FieldData> fields, final Issue issue) {
        return ImmutableMaps.transformValue(fields, (java.util.function.Function)new java.util.function.Function<FieldData, Map<Integer, Object>>(){

            @Override
            public Map<Integer, Object> apply(FieldData fieldData) {
                HashMap<Integer, Object> representations = new HashMap<Integer, Object>();
                representations.put(FIRST_REPRESENTATION_VERSION, fieldData.getJsonData().getData());
                if (!(fieldData.field instanceof CustomField)) {
                    return representations;
                }
                CustomField field = (CustomField)fieldData.field;
                CustomFieldType customFieldType = field.getCustomFieldType();
                if (!(customFieldType instanceof AbstractCustomFieldType)) {
                    return representations;
                }
                AbstractCustomFieldType abstractCustomFieldType = (AbstractCustomFieldType)customFieldType;
                CustomFieldTypeModuleDescriptor descriptor = abstractCustomFieldType.getDescriptor();
                representations.putAll(IssueBeanBuilder2.this.createVersionedRepresentationsForField(field, descriptor, issue));
                return representations;
            }
        });
    }

    private Map<Integer, Object> createVersionedRepresentationsForField(CustomField field, CustomFieldTypeModuleDescriptor descriptor, Issue issue) {
        return ImmutableMaps.collect((Map)descriptor.getRestSerializers(), entry -> this.getSafelyVersionedRepresentation((CustomFieldRestSerializer)entry.getValue(), (Integer)entry.getKey(), field, issue).map(jsonData -> Maps.immutableEntry(entry.getKey(), (Object)jsonData.getData())));
    }

    private Option<JsonData> getSafelyVersionedRepresentation(CustomFieldRestSerializer serializer, Integer version, CustomField field, Issue issue) {
        try {
            return Option.some((Object)serializer.getJsonData(field, issue));
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Cannot get value from rest serializer %s for field %s, exception: '%s' ", version, field.getId(), e.getMessage()), (Throwable)e);
            } else {
                LOG.info(String.format("Cannot get value from rest serializer %s for field %s, exception: '%s' ", version, field.getId(), e.getMessage()));
            }
            return Option.none();
        }
    }

    private boolean isSpecialField(NavigableField field) {
        return field instanceof ProjectSystemField;
    }

    private boolean isExpanded(String element) {
        return this.expand != null && this.expand.contains(element);
    }

    private static class FieldData {
        private final Field field;
        private final FieldJsonRepresentation representation;

        public FieldData(Field field, FieldJsonRepresentation representation) {
            this.field = field;
            this.representation = representation;
        }

        public JsonData getJsonData() {
            return this.representation.getStandardData();
        }

        public Option<JsonData> getRenderedData() {
            return Option.option((Object)this.representation.getRenderedData());
        }

        public RestAwareField getRestAware() {
            return (RestAwareField)this.field;
        }

        public JsonTypeBean getJsonTypeBean() {
            return new JsonTypeBean(this.getRestAware().getJsonSchema());
        }
    }
}

