/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.issue.link.IssueLinkTypeService;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinkTypeJsonBean;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.issue.IssueLinkTypesBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.AccessDisablingHelper;
import com.atlassian.jira.util.AccessDisablingHelperConfig;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.plugins.rest.api.util.RestUrlBuilder;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;

@Path(value="issueLinkType")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueLinkTypeResource {
    private final IssueLinkTypeService issueLinkTypeService;
    private final JiraAuthenticationContext authenticationContext;
    private final I18nHelper i18n;
    private final AccessDisablingHelper accessDisablingHelper;
    private final UriInfo contextUriInfo;
    private final RestUrlBuilder restUrlBuilder;

    @Inject
    public IssueLinkTypeResource(IssueLinkTypeService issueLinkTypeService, JiraAuthenticationContext authenticationContext, I18nHelper i18n, @ComponentImport AccessDisablingHelper accessDisablingHelper, UriInfo contextUriInfo, @ComponentImport RestUrlBuilder restUrlBuilder) {
        this.issueLinkTypeService = issueLinkTypeService;
        this.authenticationContext = authenticationContext;
        this.i18n = i18n;
        this.accessDisablingHelper = accessDisablingHelper;
        this.contextUriInfo = contextUriInfo;
        this.restUrlBuilder = restUrlBuilder;
    }

    @GET
    public Response getIssueLinkTypes() {
        this.blockAnonymousUsersIfNeeded();
        ServiceOutcome outcome = this.issueLinkTypeService.getIssueLinkTypes(this.authenticationContext.getUser());
        if (outcome.isValid()) {
            Collection linkTypes = (Collection)outcome.getReturnedValue();
            Iterable iterable = Iterables.transform((Iterable)linkTypes, from -> {
                URI uri = this.restUrlBuilder.getUrlFor(this.contextUriInfo.getBaseUri(), IssueLinkTypeResource.class, res -> res.getIssueLinkType(from.getId().toString()));
                return new IssueLinkTypeJsonBean(from.getId(), from.getName(), from.getInward(), from.getOutward(), uri);
            });
            return Response.ok((Object)IssueLinkTypesBean.create(Lists.newArrayList((Iterable)iterable))).cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    private void blockAnonymousUsersIfNeeded() {
        if (!this.accessDisablingHelper.canBeAccessedByCurrentUser(AccessDisablingHelperConfig.builder().blockAnonymous(true).build())) {
            throw new NotAuthorisedWebException();
        }
    }

    @POST
    public Response createIssueLinkType(IssueLinkTypeJsonBean linkTypeBean) {
        this.validateForCreate(linkTypeBean);
        ServiceOutcome outcome = this.issueLinkTypeService.createIssueLinkType(this.authenticationContext.getUser(), linkTypeBean.name(), linkTypeBean.outward(), linkTypeBean.inward());
        if (outcome.isValid()) {
            return Response.status((Response.Status)Response.Status.CREATED).entity(this.getIssueLinkType(((IssueLinkType)outcome.getReturnedValue()).getId().toString()).getEntity()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    private void validateForCreate(IssueLinkTypeJsonBean linkTypeBean) {
        ErrorCollection errors = new ErrorCollection();
        if (StringUtils.isEmpty((CharSequence)linkTypeBean.inward())) {
            errors.addErrorMessage(this.i18n.getText("admin.errors.linking.error.missing.inward"));
        }
        if (StringUtils.isEmpty((CharSequence)linkTypeBean.outward())) {
            errors.addErrorMessage(this.i18n.getText("admin.errors.linking.error.missing.outward"));
        }
        if (StringUtils.isEmpty((CharSequence)linkTypeBean.name())) {
            errors.addErrorMessage(this.i18n.getText("admin.errors.linking.error.missing.name"));
        }
        if (errors.hasAnyErrors()) {
            throw new RESTException(Response.Status.BAD_REQUEST, errors);
        }
    }

    @GET
    @Path(value="/{issueLinkTypeId}")
    public Response getIssueLinkType(@PathParam(value="issueLinkTypeId") String issueLinkTypeIdString) {
        this.blockAnonymousUsersIfNeeded();
        IssueLinkType linkType = this.findLinkType(issueLinkTypeIdString);
        URI uri = this.restUrlBuilder.getUrlFor(this.contextUriInfo.getBaseUri(), IssueLinkTypeResource.class, res -> res.getIssueLinkType(issueLinkTypeIdString));
        return Response.ok((Object)IssueLinkTypeJsonBean.create((IssueLinkType)linkType, (URI)uri)).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="/{issueLinkTypeId}")
    public Response deleteIssueLinkType(@PathParam(value="issueLinkTypeId") String issueLinkTypeIdString) {
        IssueLinkType linkType = this.findLinkType(issueLinkTypeIdString);
        ServiceOutcome outcome = this.issueLinkTypeService.deleteIssueLinkType(this.authenticationContext.getUser(), linkType);
        if (outcome.isValid()) {
            return Response.noContent().cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    @PUT
    @Path(value="/{issueLinkTypeId}")
    public Response updateIssueLinkType(@PathParam(value="issueLinkTypeId") String issueLinkTypeIdString, IssueLinkTypeJsonBean linkTypeJsonBean) {
        IssueLinkType linkType = this.findLinkType(issueLinkTypeIdString);
        ServiceOutcome outcome = this.issueLinkTypeService.updateIssueLinkType(this.authenticationContext.getUser(), linkType, linkTypeJsonBean.name(), linkTypeJsonBean.outward(), linkTypeJsonBean.inward());
        if (outcome.isValid()) {
            return Response.status((Response.Status)Response.Status.OK).entity(this.getIssueLinkType(issueLinkTypeIdString).getEntity()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    private IssueLinkType findLinkType(String issueLinkTypeIdString) {
        Long issueLinkTypeId;
        try {
            issueLinkTypeId = Long.parseLong(issueLinkTypeIdString);
        }
        catch (NumberFormatException e) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(this.i18n.getText("rest.issue.link.type.invalid.id", issueLinkTypeIdString)));
        }
        try {
            ServiceOutcome outcome = this.issueLinkTypeService.getIssueLinkTypes(this.authenticationContext.getUser());
            if (!outcome.isValid()) {
                throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
            }
            return (IssueLinkType)Iterables.find((Iterable)((Iterable)outcome.getReturnedValue()), (Predicate)new Predicate<IssueLinkType>(){

                public boolean apply(@Nullable IssueLinkType input) {
                    return input.getId().equals(issueLinkTypeId);
                }
            });
        }
        catch (NoSuchElementException e) {
            throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(this.i18n.getText("rest.issue.link.type.with.id.not.found", issueLinkTypeIdString)));
        }
    }
}

