/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.PriorityJsonBean;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.AccessDisablingHelper;
import com.atlassian.jira.util.AccessDisablingHelperConfig;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.Pages;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="priority")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PriorityResource {
    private static final String EMPTY_QUERY = "";
    private static final String DEFAULT_MAX_ELEMENTS = "100";
    private final ConstantsManager constantsManager;
    private final I18nHelper i18n;
    private final JiraBaseUrls baseUrls;
    @ComponentImport
    private final AccessDisablingHelper accessDisablingHelper;
    private final PermissionManager permissionManager;
    @ComponentImport
    private final PriorityManager priorityManager;
    private final JiraBaseUrls jiraBaseUrls;

    @Inject
    public PriorityResource(ConstantsManager constantsManager, I18nHelper i18n, JiraBaseUrls baseUrls, AccessDisablingHelper accessDisablingHelper, PermissionManager permissionManager, PriorityManager priorityManager, JiraBaseUrls jiraBaseUrls) {
        this.constantsManager = constantsManager;
        this.baseUrls = baseUrls;
        this.i18n = i18n;
        this.accessDisablingHelper = accessDisablingHelper;
        this.permissionManager = permissionManager;
        this.priorityManager = priorityManager;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @GET
    public Response getPriorities(@Context UriInfo uriInfo) {
        this.blockAnonymousUsersIfNeeded();
        Collection priorities = this.constantsManager.getPriorities();
        List beans = priorities.stream().map(priority -> PriorityJsonBean.fullBean((Priority)priority, (JiraBaseUrls)this.baseUrls)).collect(Collectors.toList());
        return Response.ok(beans).cacheControl(CacheControl.never()).build();
    }

    @Path(value="page")
    @GET
    public Response getPriorities(@DefaultValue(value="0") @QueryParam(value="startAt") long startAt, @DefaultValue(value="100") @QueryParam(value="maxResults") int maxResults, @DefaultValue(value="") @QueryParam(value="query") String query, @QueryParam(value="projectIds") Set<Long> projectIds) {
        this.blockAnonymousUsersIfNeeded();
        List priorities = this.priorityManager.findPriorities(query, projectIds).collect(Collectors.toList());
        PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)maxResults);
        Page statusPage = Pages.toPage(priorities, (PageRequest)pageRequest);
        PageBean<PriorityJsonBean> bean = PageBean.from(pageRequest, statusPage).build(priority -> PriorityJsonBean.fullBean((Priority)priority, (JiraBaseUrls)this.jiraBaseUrls));
        return Response.ok(bean).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{id}")
    public Response getPriority(@PathParam(value="id") String id) {
        this.blockAnonymousUsersIfNeeded();
        Priority priority = this.constantsManager.getPriorityObject(id);
        if (priority == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.priority.error.not.found", id)));
        }
        return Response.ok((Object)PriorityJsonBean.fullBean((Priority)priority, (JiraBaseUrls)this.baseUrls)).cacheControl(CacheControl.never()).build();
    }

    private void blockAnonymousUsersIfNeeded() {
        if (!this.accessDisablingHelper.canBeAccessedByCurrentUser(AccessDisablingHelperConfig.builder().blockAnyoneNotFulfillingCondition(this::canUserAccess).build())) {
            throw new NotAuthorisedWebException();
        }
    }

    private boolean canUserAccess(ApplicationUser user) {
        return user != null || this.permissionManager.hasProjects(ProjectPermissions.BROWSE_PROJECTS, null);
    }
}

