/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.issue.fields.screen.FieldScreenId;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenOperationContext;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.rest.v2.issue.ActionDescriptorBean;
import com.atlassian.jira.rest.v2.issue.ScreenSchemeBean;
import com.atlassian.jira.rest.v2.issue.ScreenWorkflowBean;
import com.atlassian.jira.rest.v2.issue.ScreenableTabBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.plugins.rest.api.expand.annotation.Expandable;
import com.atlassian.plugins.rest.api.expand.expander.SelfExpanding;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenBean {
    private static final Logger log = LoggerFactory.getLogger(ScreenBean.class);
    @XmlElement
    private Long id;
    @XmlElement
    private String name;
    @XmlElement
    private String description;
    @XmlElement
    private Collection<ScreenSchemeBean> fieldScreenSchemes;
    @XmlTransient
    @Expandable(value="fieldScreenSchemes")
    private final SelfExpanding fieldScreenSchemesExpander = () -> {
        FieldScreen fieldScreen = this.getFieldScreenManager().getFieldScreen(this.id);
        this.expandFieldScreenSchemes(fieldScreen);
    };
    @XmlElement
    private Collection<ScreenWorkflowBean> fieldScreenWorkflows;
    @XmlTransient
    @Expandable(value="fieldScreenWorkflows")
    private final SelfExpanding fieldScreenWorkflowsExpander = () -> {
        FieldScreen fieldScreen = this.getFieldScreenManager().getFieldScreen(this.id);
        this.expandFieldScreenWorkflows(fieldScreen);
    };
    @XmlElement
    private Boolean deletable;
    @XmlTransient
    @Expandable(value="deletable")
    private SelfExpanding deletableExpander = this::expandDeletable;
    @XmlElement
    private Collection<ScreenableTabBean> fieldScreenTabList;
    @XmlTransient
    @Expandable(value="fieldScreenTabs")
    private final SelfExpanding fieldScreenTabs = () -> {
        FieldScreen fieldScreen = this.getFieldScreenManager().getFieldScreen(this.id);
        this.expandFieldScreenTabs(fieldScreen);
    };
    @XmlAttribute
    private String expand;
    private FieldScreenManager fieldScreenManager;
    private WorkflowManager workflowManager;
    private FieldScreenSchemeManager fieldScreenSchemeManager;
    private FieldScreenService fieldScreenService;
    private JiraAuthenticationContext jiraAuthenticationContext;
    static final ScreenBean DOC_EXAMPLE = new ScreenBean();
    static final ScreenBean DOC_EXAMPLE_WITH_SCHEMES;

    private ScreenBean() {
    }

    public ScreenBean(Long id, String name, String description, String expand) {
        this.id = Objects.requireNonNull(id);
        this.name = Objects.requireNonNull(name);
        this.description = StringUtils.defaultString((String)description, (String)"");
        this.expand = StringUtils.defaultString((String)expand, (String)"");
    }

    public ScreenBean(FieldScreen fieldScreen) {
        this(fieldScreen, "");
    }

    public ScreenBean(FieldScreen fieldScreen, String expand) {
        this.id = fieldScreen.getId();
        this.name = fieldScreen.getName();
        this.description = fieldScreen.getDescription();
        this.expand = StringUtils.defaultString((String)expand, (String)"");
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<ScreenSchemeBean> getFieldScreenSchemes() {
        return this.fieldScreenSchemes;
    }

    public void setFieldScreenSchemes(Collection<ScreenSchemeBean> fieldScreenSchemes) {
        this.fieldScreenSchemes = fieldScreenSchemes;
    }

    public Collection<ScreenWorkflowBean> getFieldScreenWorkflows() {
        return this.fieldScreenWorkflows;
    }

    public Boolean getDeletable() {
        return this.deletable;
    }

    public Collection<ScreenableTabBean> getFieldScreenTabList() {
        return this.fieldScreenTabList;
    }

    public void setFieldScreenTabList(Collection<ScreenableTabBean> fieldScreenTabList) {
        this.fieldScreenTabList = fieldScreenTabList;
    }

    public void setFieldScreenWorkflows(Collection<ScreenWorkflowBean> fieldScreenWorkflows) {
        this.fieldScreenWorkflows = fieldScreenWorkflows;
    }

    private void expandFieldScreenTabs(FieldScreen fieldScreen) {
        try {
            this.setFieldScreenTabList(fieldScreen.getTabs().stream().map(ScreenableTabBean::new).collect(Collectors.toList()));
        }
        catch (Exception e) {
            log.error("Exception whilst trying to expand screen tabs for '" + fieldScreen.getName() + "' field screen. Defaulting to no empty field screen tabs. " + e, (Throwable)e);
            this.setFieldScreenSchemes(Collections.emptyList());
        }
    }

    private void expandFieldScreenSchemes(FieldScreen fieldScreen) {
        try {
            this.setFieldScreenSchemes(this.getFieldScreenSchemeManager().getFieldScreenSchemes(fieldScreen).stream().map(ScreenSchemeBean::new).collect(Collectors.toList()));
        }
        catch (Exception e) {
            log.error("Exception whilst trying to expand screen schemes for '" + fieldScreen.getName() + "' field screen. Defaulting to empty field screen schemes. " + e, (Throwable)e);
            this.setFieldScreenSchemes(Collections.emptyList());
        }
    }

    private void expandFieldScreenWorkflows(FieldScreen fieldScreen) {
        try {
            Collection<ScreenWorkflowBean> workflowBeans = this.createWorkflowBeans(fieldScreen);
            this.setFieldScreenWorkflows(workflowBeans.stream().filter(workflowBean -> !workflowBean.getActions().isEmpty()).collect(Collectors.toList()));
        }
        catch (Exception e) {
            log.error("Exception whilst trying to expand workflows for '" + fieldScreen.getName() + "' field screen. Defaulting to empty field screen workflows. " + e, (Throwable)e);
            this.setFieldScreenWorkflows(Collections.emptyList());
        }
    }

    private void expandDeletable() {
        try {
            this.deletable = (Boolean)this.getFieldScreenService().getIsFieldScreenDeletable(FieldScreenId.byId((long)this.getId()), this.userContext()).get();
        }
        catch (Exception e) {
            log.error("Exception whilst trying to expand deletability field for '" + this.name + "' field screen. Defaulting to false. " + e, (Throwable)e);
            this.deletable = false;
        }
    }

    private Collection<ScreenWorkflowBean> createWorkflowBeans(FieldScreen fieldScreen) {
        Collection workflows = this.getWorkflowManager().getWorkflows();
        ArrayList<ScreenWorkflowBean> workflowBeans = new ArrayList<ScreenWorkflowBean>();
        for (JiraWorkflow workflow : workflows) {
            Collection actions = workflow.getActionsForScreen(fieldScreen);
            Collection<ActionDescriptorBean> actionBeans = this.createActionDescriptorBeans(workflow, actions);
            ScreenWorkflowBean bean = new ScreenWorkflowBean(workflow, actionBeans);
            workflowBeans.add(bean);
        }
        return workflowBeans;
    }

    private Collection<ActionDescriptorBean> createActionDescriptorBeans(JiraWorkflow workflow, Collection<ActionDescriptor> actions) {
        ArrayList<ActionDescriptorBean> actionBeans = new ArrayList<ActionDescriptorBean>(Collections.emptyList());
        for (ActionDescriptor actionDescriptor : actions) {
            String stepId = this.getWorkflowManager().getStepId((long)actionDescriptor.getId(), workflow.getName());
            if (stepId == null) continue;
            Long firstStep = Long.valueOf(stepId);
            boolean isGlobal = workflow.isGlobalAction(actionDescriptor);
            actionBeans.add(new ActionDescriptorBean(actionDescriptor, firstStep, isGlobal));
        }
        return actionBeans;
    }

    private WorkflowManager getWorkflowManager() {
        if (this.workflowManager == null) {
            this.workflowManager = ComponentAccessor.getWorkflowManager();
        }
        return this.workflowManager;
    }

    private FieldScreenManager getFieldScreenManager() {
        if (this.fieldScreenManager == null) {
            this.fieldScreenManager = ComponentAccessor.getFieldScreenManager();
        }
        return this.fieldScreenManager;
    }

    private FieldScreenSchemeManager getFieldScreenSchemeManager() {
        if (this.fieldScreenSchemeManager == null) {
            this.fieldScreenSchemeManager = ComponentAccessor.getFieldScreenSchemeManager();
        }
        return this.fieldScreenSchemeManager;
    }

    private FieldScreenService getFieldScreenService() {
        if (this.fieldScreenService == null) {
            this.fieldScreenService = (FieldScreenService)ComponentAccessor.getComponent(FieldScreenService.class);
        }
        return this.fieldScreenService;
    }

    private JiraAuthenticationContext getJiraAuthenticationContext() {
        if (this.jiraAuthenticationContext == null) {
            this.jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        }
        return this.jiraAuthenticationContext;
    }

    private FieldScreenOperationContext userContext() {
        return FieldScreenOperationContext.ofUser((ApplicationUser)this.getJiraAuthenticationContext().getLoggedInUser());
    }

    static {
        ScreenBean.DOC_EXAMPLE.id = 10001L;
        ScreenBean.DOC_EXAMPLE.name = "Summary";
        DOC_EXAMPLE_WITH_SCHEMES = new ScreenBean();
        ScreenBean.DOC_EXAMPLE_WITH_SCHEMES.id = 10002L;
        ScreenBean.DOC_EXAMPLE_WITH_SCHEMES.name = "Summary";
        ScreenBean.DOC_EXAMPLE_WITH_SCHEMES.fieldScreenSchemes = Collections.singletonList(ScreenSchemeBean.DOC_EXAMPLE);
    }
}

