/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.comparator.UserCachingComparator;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.rest.api.expand.PagedListWrapper;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Supplier;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;

public class UserJsonBeanListWrapper
extends PagedListWrapper<UserJsonBean, ApplicationUser> {
    private final Ordering<ApplicationUser> userOrdering = Ordering.from((Comparator)new UserCachingComparator());
    private Supplier<List<ApplicationUser>> usersSupplier;
    private ApplicationUser loggedInUser;
    private UserBeanFactory userBeanFactory;

    public UserJsonBeanListWrapper() {
    }

    public UserJsonBeanListWrapper(int userCount, Supplier<List<ApplicationUser>> usersSupplier, int maxResults, ApplicationUser loggedInUser, UserBeanFactory userBeanFactory) {
        super(userCount, maxResults);
        this.userBeanFactory = userBeanFactory;
        this.usersSupplier = usersSupplier;
        this.loggedInUser = loggedInUser;
    }

    @Override
    public UserJsonBean fromBackedObject(ApplicationUser user) {
        return this.userBeanFactory.createBean(user, this.loggedInUser);
    }

    @Override
    public int getBackingListSize() {
        return this.size;
    }

    @Override
    public List<ApplicationUser> getOrderedList(int startIndex, int endIndex) {
        List sortedUsers = this.userOrdering.leastOf((Iterable)this.usersSupplier.get(), endIndex + 1);
        int safeStartIndexInclusive = Math.min(startIndex, sortedUsers.size());
        int safeEndIndexExclusive = Math.min(endIndex + 1, sortedUsers.size());
        return sortedUsers.subList(safeStartIndexInclusive, safeEndIndexExclusive);
    }
}

