/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.attachment.operation;

import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.issue.AttachmentIndexManager;
import com.atlassian.jira.rest.factory.Responder;
import com.atlassian.jira.rest.v2.issue.attachment.AttachmentConfiguration;
import com.atlassian.jira.rest.v2.issue.attachment.format.ArchiveFormatter;
import com.atlassian.jira.rest.v2.issue.attachment.operation.AttachmentExpansion;
import com.atlassian.jira.rest.v2.issue.attachment.operation.AttachmentOperation;
import com.atlassian.jira.rest.v2.issue.attachment.operation.AttachmentRemoval;
import com.atlassian.jira.rest.v2.issue.attachment.operation.AttachmentView;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class AttachmentOperationFactory {
    private Responder responder;
    private AttachmentService attachmentService;
    private BeanBuilderFactory beanBuilderFactory;
    private AttachmentIndexManager attachmentIndexManager;
    private AttachmentConfiguration configuration;

    private AttachmentOperationFactory() {
    }

    @Autowired
    private AttachmentOperationFactory(Responder responder, AttachmentService attachmentService, BeanBuilderFactory beanBuilderFactory, @ComponentImport AttachmentIndexManager attachmentIndexManager, AttachmentConfiguration configuration) {
        this.responder = responder;
        this.attachmentService = attachmentService;
        this.beanBuilderFactory = beanBuilderFactory;
        this.attachmentIndexManager = attachmentIndexManager;
        this.configuration = configuration;
    }

    public AttachmentOperation removal() {
        return new AttachmentRemoval(this.attachmentService, this.responder);
    }

    public AttachmentOperation view() {
        return new AttachmentView(this.responder, this.beanBuilderFactory);
    }

    public AttachmentOperation expansion(ArchiveFormatter<?> formatter) {
        return new AttachmentExpansion(this.attachmentIndexManager, this.responder, this.configuration, formatter);
    }
}

