/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.builder;

import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.DCFeatureLicenseChecker;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadataManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinksBeanBuilderFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.util.ProjectKeyOrId;
import com.atlassian.jira.rest.v2.issue.CreateMetaFieldBeanBuilder;
import com.atlassian.jira.rest.v2.issue.CreateMetaIssueTypeBeanBuilder;
import com.atlassian.jira.rest.v2.issue.DefaultFieldMetaBeanHelper;
import com.atlassian.jira.rest.v2.issue.EditMetaBeanBuilder;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBeanBuilder;
import com.atlassian.jira.rest.v2.issue.IssueBeanBuilder2;
import com.atlassian.jira.rest.v2.issue.OpsbarBeanBuilder;
import com.atlassian.jira.rest.v2.issue.RemoteIssueLinkBeanBuilder;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import com.atlassian.jira.rest.v2.issue.TransitionMetaBeanBuilder;
import com.atlassian.jira.rest.v2.issue.attachment.format.AttachmentBeanBuilder;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.rest.v2.issue.builder.ChangelogBeanBuilder;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.rest.v2.search.FilterBeanBuilder;
import com.atlassian.jira.rest.v2.search.FilterPermissionBeanFactory;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class BeanBuilderFactoryImpl
implements BeanBuilderFactory {
    private final UserManager userManager;
    private final ThumbnailManager thumbnailManager;
    private final VersionBeanFactory versionBeanFactory;
    private final FieldLayoutManager fieldLayoutManager;
    private final JiraAuthenticationContext authContext;
    private final FieldManager fieldManager;
    private final ResourceUriBuilder uriBuilder;
    private final UriInfo contextUriInfo;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ProjectManager projectManager;
    private final ProjectRoleManager projectRoleManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final PermissionManager permissionManager;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final IssueManager issueManager;
    private final JiraBaseUrls baseUrls;
    private final IssueLinksBeanBuilderFactory issueLinkBeanBuilderFactory;
    private final IssueWorkflowManager issueWorkflowManager;
    private final WorkflowManager workflowManager;
    private final StatusManager statusManager;
    private final IssueFactory issueFactory;
    private final ChangeHistoryManager changeHistoryManager;
    private final ApplicationProperties applicationProperties;
    private final SimpleLinkManager simpleLinkManager;
    private final I18nHelper i18nHelper;
    private final PluginAccessor pluginAccessor;
    private final JqlStringSupport jqlStringSupport;
    private final GroupManager groupManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final FilterSubscriptionService filterSubscriptionService;
    private final JiraBaseUrls jiraBaseUrls;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final HistoryMetadataManager historyMetadataManager;
    private final UserBeanFactory userBeanFactory;
    @ComponentImport
    private final LicenseCountService licenseCountService;
    private final FeatureManager featureManager;
    private final FilterPermissionBeanFactory filterPermissionBeanFactory;
    private final UserSearchService userSearchService;
    private final DCFeatureLicenseChecker licenseChecker;
    @ComponentImport
    private final ShareManager shareManager;
    private final ConstantsManager constantsManager;
    private final ResourceUriBuilder resourceUriBuilder;

    @Autowired
    public BeanBuilderFactoryImpl(UserManager userManager, ThumbnailManager thumbnailManager, VersionBeanFactory versionBeanFactory, FieldLayoutManager fieldLayoutManager, JiraAuthenticationContext authContext, FieldManager fieldManager, ResourceUriBuilder uriBuilder, UriInfo contextUriInfo, VelocityRequestContextFactory velocityRequestContextFactory, ProjectManager projectManager, ProjectRoleManager projectRoleManager, IssueTypeSchemeManager issueTypeSchemeManager, PermissionManager permissionManager, FieldScreenRendererFactory fieldScreenRendererFactory, IssueManager issueManager, JiraBaseUrls baseUrls, IssueLinksBeanBuilderFactory issueLinkBeanBuilderFactory, IssueWorkflowManager issueWorkflowManager, WorkflowManager workflowManager, StatusManager statusManager, IssueFactory issueFactory, ChangeHistoryManager changeHistoryManager, ApplicationProperties applicationProperties, SimpleLinkManager simpleLinkManager, I18nHelper i18nHelper, PluginAccessor pluginAccessor, JqlStringSupport jqlStringSupport, GroupManager groupManager, PermissionSchemeManager permissionSchemeManager, FilterSubscriptionService filterSubscriptionService, JiraBaseUrls jiraBaseUrls, IssueSecurityLevelManager issueSecurityLevelManager, HistoryMetadataManager historyMetadataManager, UserBeanFactory userBeanFactory, LicenseCountService licenseCountService, FeatureManager featureManager, FilterPermissionBeanFactory filterPermissionBeanFactory, ShareManager shareManager, ConstantsManager constantsManager, UserSearchService userSearchService, @ComponentImport DCFeatureLicenseChecker licenseChecker, ResourceUriBuilder resourceUriBuilder) {
        this.userManager = userManager;
        this.thumbnailManager = thumbnailManager;
        this.versionBeanFactory = versionBeanFactory;
        this.fieldLayoutManager = fieldLayoutManager;
        this.authContext = authContext;
        this.fieldManager = fieldManager;
        this.uriBuilder = uriBuilder;
        this.contextUriInfo = contextUriInfo;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.projectManager = projectManager;
        this.projectRoleManager = projectRoleManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.permissionManager = permissionManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.issueManager = issueManager;
        this.baseUrls = baseUrls;
        this.issueLinkBeanBuilderFactory = issueLinkBeanBuilderFactory;
        this.issueWorkflowManager = issueWorkflowManager;
        this.workflowManager = workflowManager;
        this.statusManager = statusManager;
        this.issueFactory = issueFactory;
        this.changeHistoryManager = changeHistoryManager;
        this.applicationProperties = applicationProperties;
        this.simpleLinkManager = simpleLinkManager;
        this.i18nHelper = i18nHelper;
        this.pluginAccessor = pluginAccessor;
        this.jqlStringSupport = jqlStringSupport;
        this.groupManager = groupManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.filterSubscriptionService = filterSubscriptionService;
        this.jiraBaseUrls = jiraBaseUrls;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.historyMetadataManager = historyMetadataManager;
        this.userBeanFactory = userBeanFactory;
        this.licenseCountService = licenseCountService;
        this.featureManager = featureManager;
        this.filterPermissionBeanFactory = filterPermissionBeanFactory;
        this.shareManager = shareManager;
        this.constantsManager = constantsManager;
        this.userSearchService = userSearchService;
        this.licenseChecker = licenseChecker;
        this.resourceUriBuilder = resourceUriBuilder;
    }

    @Override
    public AttachmentBeanBuilder newAttachmentBeanBuilder(Attachment attachment) {
        return new AttachmentBeanBuilder(this.jiraBaseUrls, this.thumbnailManager, attachment);
    }

    @Override
    public IssueBeanBuilder2 newIssueBeanBuilder2(IncludedFields include, String expand) {
        return new IssueBeanBuilder2(this.fieldLayoutManager, this.authContext, this.fieldManager, this.uriBuilder, this, include, this.issueLinkBeanBuilderFactory, this.issueWorkflowManager, this.contextUriInfo.getBaseUriBuilder(), expand);
    }

    @Override
    public IssueBeanBuilder2 newIssueBeanBuilder2(@Nullable IncludedFields include, @Nullable String expand, @Nonnull UriBuilder baseUriBuilder) {
        return new IssueBeanBuilder2(this.fieldLayoutManager, this.authContext, this.fieldManager, this.uriBuilder, this, include, this.issueLinkBeanBuilderFactory, this.issueWorkflowManager, baseUriBuilder, expand);
    }

    @Override
    public IssueBeanBuilder newIssueBeanBuilder(@Nonnull Issue issue, @Nullable IncludedFields include) {
        return new IssueBeanBuilder(this, include, issue);
    }

    @Override
    public CreateMetaIssueTypeBeanBuilder newCreateMetaIssueTypeBeanBuilder(@Nonnull String projectIdOrKey) {
        return new CreateMetaIssueTypeBeanBuilder(this.projectManager, this.contextUriInfo, this.issueTypeSchemeManager, this.baseUrls, projectIdOrKey, this);
    }

    @Override
    public CreateMetaFieldBeanBuilder newCreateMetaFieldBeanBuilder(@Nonnull String projectIdOrKey, @Nonnull String issueTypeId) {
        Project project = this.getProject(projectIdOrKey);
        Preconditions.checkArgument((project != null ? 1 : 0) != 0, (String)"Project with id/key: %s doesn't exist", (Object)projectIdOrKey);
        IssueType issueType = this.constantsManager.getIssueType(issueTypeId);
        Preconditions.checkArgument((issueType != null ? 1 : 0) != 0, (String)"Issue type with id: %s doesn't exist in project: %s", (Object)issueTypeId, (Object)projectIdOrKey);
        return new CreateMetaFieldBeanBuilder(this.fieldLayoutManager, project, issueType, this.issueFactory, this.authContext.getUser(), this.versionBeanFactory, this.velocityRequestContextFactory, this.baseUrls, this.permissionManager, this.fieldScreenRendererFactory, this.authContext, this.fieldManager, new DefaultFieldMetaBeanHelper(project, issueType, this.issueSecurityLevelManager, this.licenseChecker));
    }

    private Project getProject(String projectIdOrKey) {
        return (Project)ProjectKeyOrId.parse(projectIdOrKey).fold(arg_0 -> ((ProjectManager)this.projectManager).getProjectObj(arg_0), arg_0 -> ((ProjectManager)this.projectManager).getProjectObjByKey(arg_0));
    }

    @Override
    public EditMetaBeanBuilder newEditMetaBeanBuilder() {
        return new EditMetaBeanBuilder(this.authContext, this.fieldLayoutManager, this.velocityRequestContextFactory, this.contextUriInfo, this.versionBeanFactory, this.baseUrls, this.fieldScreenRendererFactory, this.issueManager, this.fieldManager);
    }

    @Override
    public TransitionMetaBeanBuilder newTransitionMetaBeanBuilder() {
        return new TransitionMetaBeanBuilder(this.fieldScreenRendererFactory, this.authContext, this.fieldLayoutManager, this.velocityRequestContextFactory, this.versionBeanFactory, this.baseUrls, this.workflowManager, this.statusManager);
    }

    @Override
    public OpsbarBeanBuilder newOpsbarBeanBuilder(Issue issue) {
        return new OpsbarBeanBuilder(issue, this.applicationProperties, this.simpleLinkManager, this.authContext, this.i18nHelper, this.issueManager, this.pluginAccessor, this.permissionManager);
    }

    @Override
    public RemoteIssueLinkBeanBuilder newRemoteIssueLinkBeanBuilder(RemoteIssueLink remoteIssueLink) {
        return new RemoteIssueLinkBeanBuilder(this.contextUriInfo, this.issueManager, remoteIssueLink);
    }

    @Override
    public ChangelogBeanBuilder newChangelogBeanBuilder() {
        return new ChangelogBeanBuilder(this.changeHistoryManager, this.historyMetadataManager, this.authContext, this.userBeanFactory);
    }

    @Override
    public FilterBeanBuilder newFilterBeanBuilder() {
        return new FilterBeanBuilder(this.authContext, this.projectManager, this.permissionManager, this.projectRoleManager, this.userManager, this.jqlStringSupport, this.groupManager, (SchemeManager)this.permissionSchemeManager, this.filterSubscriptionService, this.jiraBaseUrls, this.licenseCountService, this.featureManager, this.filterPermissionBeanFactory, this.shareManager, this.userSearchService, this.resourceUriBuilder);
    }
}

