/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.customfield;

import com.atlassian.analytics.api.annotations.EventName;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@EventName(value="administration.customfields.rest.find")
public class CustomFieldFindEvent {
    private final Long startAt;
    private final int maxResults;
    private List<Long> projectIds;
    private List<Long> screenIds;
    private List<String> types;
    private Long sortOrder;
    private Long sortColumn;
    private final Long lastValueUpdate;

    public CustomFieldFindEvent(Long startAt, int maxResults, List<String> projectIds, List<String> screenIds, List<String> types, String sortOrder, String sortColumn, Long lastValueUpdate) {
        this.startAt = startAt;
        this.maxResults = maxResults;
        if (projectIds != null) {
            this.projectIds = projectIds.stream().limit(1000L).map(projectId -> {
                if (projectId.equals("admin.issuefields.customfields.global.all.projects")) {
                    return "-1";
                }
                return projectId;
            }).filter(StringUtils::isNotBlank).filter(StringUtils::isNumeric).map(Long::valueOf).collect(Collectors.toList());
        }
        if (screenIds != null) {
            this.screenIds = screenIds.stream().limit(1000L).filter(StringUtils::isNotBlank).filter(StringUtils::isNumeric).map(Long::valueOf).collect(Collectors.toList());
        }
        if (types != null) {
            this.types = types.stream().limit(1000L).map(type -> UUID.nameUUIDFromBytes(type.getBytes(StandardCharsets.UTF_8)).toString()).collect(Collectors.toList());
        }
        if (sortOrder != null) {
            if (sortOrder.equals("descending")) {
                this.sortOrder = 1L;
            } else if (sortOrder.equals("ascending")) {
                this.sortOrder = 2L;
            }
        }
        if (sortColumn != null) {
            if (sortColumn.equals("issuesWithValue")) {
                this.sortColumn = 1L;
            } else if (sortColumn.equals("lastValueUpdate")) {
                this.sortColumn = 2L;
            }
        }
        this.lastValueUpdate = lastValueUpdate;
    }

    public Long getStartAt() {
        return this.startAt;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public List<Long> getProjectIds() {
        return this.projectIds;
    }

    public List<Long> getScreenIds() {
        return this.screenIds;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public Long getSortOrder() {
        return this.sortOrder;
    }

    public Long getSortColumn() {
        return this.sortColumn;
    }

    public Long getLastValueUpdate() {
        return this.lastValueUpdate;
    }
}

