/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.project;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectJsonBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.v2.issue.IssueTypeBeanBuilder;
import com.atlassian.jira.rest.v2.issue.ProjectCategoryResource;
import com.atlassian.jira.rest.v2.issue.ProjectResource;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.issue.component.ComponentBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBeanFactory;
import com.atlassian.jira.rest.v2.issue.project.ProjectCategoryBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectIdentity;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleBeanFactory;
import com.atlassian.jira.rest.v2.issue.version.VersionBean;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.expand.EntityCrawler;
import com.atlassian.plugins.rest.api.expand.parameter.ExpandParameter;
import com.atlassian.plugins.rest.api.expand.resolver.EntityExpanderResolver;
import com.atlassian.plugins.rest.api.internal.expand.parameter.DefaultExpandParameter;
import com.atlassian.plugins.rest.api.internal.expand.resolver.SelfExpandingEntityExpanderResolver;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;

public class ProjectBeanFactoryImpl
implements ProjectBeanFactory {
    private static final String EXPAND_PROJECT_KEYS = "projectKeys";
    private static final String EXPAND_WILDCARD = "*";
    private final VersionBeanFactory versionBeanFactory;
    private final UserManager userManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final ProjectManager projectManager;
    private final ProjectRoleBeanFactory projectRoleBeanFactory;
    private final ResourceUriBuilder uriBuilder;
    private final UriInfo uriInfo;
    private final ProjectRoleService projectRoleService;
    private final JiraAuthenticationContext authenticationContext;
    private final SelfExpandingEntityExpanderResolver selfExpandingEntityExpanderResolver;
    private final EntityCrawler entityCrawler;

    public ProjectBeanFactoryImpl(VersionBeanFactory versionBeanFactory, UriInfo uriInfo, ResourceUriBuilder uriBuilder, ProjectRoleService projectRoleService, JiraAuthenticationContext authenticationContext, UserManager userManager, JiraBaseUrls jiraBaseUrls, ProjectManager projectManager, ProjectRoleBeanFactory projectRoleBeanFactory, @ComponentImport SelfExpandingEntityExpanderResolver selfExpandingEntityExpanderResolver, @ComponentImport EntityCrawler entityCrawler) {
        this.versionBeanFactory = versionBeanFactory;
        this.uriInfo = uriInfo;
        this.uriBuilder = uriBuilder;
        this.projectRoleService = projectRoleService;
        this.authenticationContext = authenticationContext;
        this.userManager = userManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.projectManager = projectManager;
        this.projectRoleBeanFactory = projectRoleBeanFactory;
        this.selfExpandingEntityExpanderResolver = selfExpandingEntityExpanderResolver;
        this.entityCrawler = entityCrawler;
    }

    @Override
    public ProjectBean fullProject(Project project, String expand) {
        Preconditions.checkNotNull((Object)project, (Object)"project must not be null");
        Preconditions.checkNotNull((Object)expand, (Object)"expand must not be null");
        ProjectBeanBuilder builder = this.shortProjectBuilder(project);
        builder.name(project.getName()).description(project.getDescription());
        String leadUserKey = project.getLeadUserKey();
        ApplicationUser user = this.userManager.getUserByKeyEvenWhenUnknown(leadUserKey);
        builder.lead(user);
        builder.components(project.getProjectComponents());
        builder.url(project.getUrl());
        builder.versions(project.getVersions());
        builder.assigneeType(project.getAssigneeType());
        builder.email(project.getEmail());
        builder.projectTypeKey(project.getProjectTypeKey().getKey());
        builder.archived(project.isArchived());
        builder.expandLead().expandDescription().expandUrl();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Collection projectRoles = this.projectRoleService.getProjectRoles(this.authenticationContext.getUser(), (ErrorCollection)errorCollection);
        if (!errorCollection.hasAnyErrors()) {
            for (ProjectRole projectRole : projectRoles) {
                URI uri = this.projectRoleBeanFactory.projectRole((Project)project, (ProjectRole)projectRole).self;
                builder.role(projectRole.getName(), uri);
            }
        }
        builder.issueTypes(Lists.newArrayList((Iterable)Iterables.transform((Iterable)project.getIssueTypes(), (Function)new Function<IssueType, IssueTypeJsonBean>(){

            public IssueTypeJsonBean apply(IssueType issueType) {
                return new IssueTypeBeanBuilder().jiraBaseUrls(ProjectBeanFactoryImpl.this.jiraBaseUrls).issueType(issueType).context(ProjectBeanFactoryImpl.this.uriInfo).buildShort();
            }
        })));
        ProjectBean projectBean = this.createAndExpandProjectBean(project, builder, expand);
        return projectBean;
    }

    @Override
    public ProjectBean shortProject(Project project) {
        return this.shortProjectBuilder(project).build();
    }

    @Override
    public ProjectIdentity projectIdentity(@Nonnull Project project) {
        Preconditions.checkNotNull((Object)project, (Object)"project must not be null");
        Preconditions.checkNotNull((Object)project.getId(), (Object)"id must not be null");
        Preconditions.checkNotNull((Object)project.getKey(), (Object)"key must not be null");
        return new ProjectIdentity(this.createSelfLink(project), project.getId(), project.getKey());
    }

    @Override
    public Function<Project, ProjectBean> summaryProject(final String expand) {
        return new Function<Project, ProjectBean>(){

            public ProjectBean apply(Project project) {
                return ProjectBeanFactoryImpl.this.summaryProject(project, Strings.nullToEmpty((String)expand));
            }
        };
    }

    private ProjectBean summaryProject(Project project, String expand) {
        Preconditions.checkNotNull((Object)project, (Object)"project must not be null");
        Preconditions.checkNotNull((Object)expand, (Object)"expand must not be null");
        ProjectBeanBuilder builder = this.summaryProjectBuilder(project, expand);
        ProjectBean projectBean = this.createAndExpandProjectBean(project, builder, expand);
        return projectBean;
    }

    private ProjectBean createAndExpandProjectBean(Project project, ProjectBeanBuilder builder, String expand) {
        ImmutableList<String> expandItems;
        StringList expandList = StringList.fromQueryParam(expand);
        ImmutableList<String> immutableList = expandItems = expandList == null ? ImmutableList.of() : expandList.asList();
        if (expandItems.contains(EXPAND_PROJECT_KEYS) || expandItems.contains(EXPAND_WILDCARD)) {
            builder.projectKeys(this.projectManager.getAllProjectKeys(project.getId()));
        }
        ProjectBean projectBean = builder.build();
        DefaultExpandParameter expandParameter = new DefaultExpandParameter(expandItems);
        this.entityCrawler.crawl((Object)projectBean, (ExpandParameter)expandParameter, (EntityExpanderResolver)this.selfExpandingEntityExpanderResolver);
        return projectBean;
    }

    private ProjectBeanBuilder shortProjectBuilder(Project project) {
        return new ProjectBeanBuilder().self(this.createSelfLink(project)).key(project.getKey()).name(project.getName()).id(project.getId()).avatarUrls(ProjectJsonBean.getAvatarUrls((Project)project)).projectCategory(project.getProjectCategoryObject()).projectTypeKey(project.getProjectTypeKey().getKey()).expandUrl();
    }

    private ProjectBeanBuilder summaryProjectBuilder(Project project, String expand) {
        ProjectBeanBuilder builder = this.shortProjectBuilder(project).expand(expand).description(project.getDescription()).url(project.getUrl()).archived(project.isArchived()).muteRoles().muteAssigneeType().muteUrl();
        builder.self(URI.create(this.jiraBaseUrls.restApi2BaseUrl() + "project/" + project.getId().toString()));
        String leadUserKey = project.getLeadUserKey();
        ApplicationUser user = this.userManager.getUserByKeyEvenWhenUnknown(leadUserKey);
        builder.lead(user);
        return builder;
    }

    private URI createSelfLink(Project project) {
        return this.uriBuilder.build(this.uriInfo, ProjectResource.class, project.getId().toString());
    }

    private class ProjectBeanBuilder {
        private String expand;
        private URI self;
        private String id;
        private String key;
        private String name;
        private String description;
        private String projectTypeKey;
        private UserBean lead;
        private Collection<ComponentBean> components;
        private String url;
        private String email;
        private ProjectBean.AssigneeType assigneeType = ProjectBean.AssigneeType.getAssigneeType(null);
        private Collection<VersionBean> versions;
        private Collection<IssueTypeJsonBean> issueTypes;
        private Map<String, URI> roles = new HashMap<String, URI>();
        private Map<String, String> avatarUrls = new HashMap<String, String>();
        private Collection<String> projectKeys;
        private ProjectCategoryBean projectCategory;
        private Boolean archived;
        private boolean expandLead;
        private boolean expandDescription;
        private boolean expandUrl;

        public ProjectBeanBuilder expand(String expand) {
            this.expand = expand;
            return this;
        }

        public ProjectBeanBuilder self(URI self) {
            this.self = self;
            return this;
        }

        public ProjectBeanBuilder role(String name, URI uri) {
            this.roles.put(name, uri);
            return this;
        }

        public ProjectBeanBuilder id(Long id) {
            this.id = id == null ? null : id.toString();
            return this;
        }

        public ProjectBeanBuilder key(String key) {
            this.key = key;
            return this;
        }

        public ProjectBeanBuilder issueTypes(Collection<IssueTypeJsonBean> types) {
            this.issueTypes = types;
            return this;
        }

        public ProjectBeanBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ProjectBeanBuilder lead(ApplicationUser lead) {
            this.lead = UserBeanBuilder.shortBuilder(ProjectBeanFactoryImpl.this.jiraBaseUrls).user(lead).buildShort();
            return this;
        }

        public ProjectBeanBuilder expandLead() {
            this.expandLead = true;
            return this;
        }

        public ProjectBeanBuilder expandDescription() {
            this.expandDescription = true;
            return this;
        }

        public ProjectBeanBuilder expandUrl() {
            this.expandUrl = true;
            return this;
        }

        public ProjectBeanBuilder assigneeType(Long assigneeType) {
            this.assigneeType = ProjectBean.AssigneeType.getAssigneeType(assigneeType);
            return this;
        }

        public ProjectBeanBuilder components(Collection<? extends ProjectComponent> components) {
            this.components = ComponentBean.asBeans(components, ProjectBeanFactoryImpl.this.jiraBaseUrls);
            return this;
        }

        public ProjectBeanBuilder projectKeys(Collection<String> keys) {
            this.projectKeys = keys;
            return this;
        }

        public ProjectBeanBuilder url(String url) {
            this.url = StringUtils.stripToNull((String)url);
            return this;
        }

        public void email(String email) {
            this.email = StringUtils.stripToNull((String)email);
        }

        public ProjectBeanBuilder projectTypeKey(String projectTypeKey) {
            this.projectTypeKey = projectTypeKey;
            return this;
        }

        public ProjectBeanBuilder versions(Collection<? extends Version> versions) {
            this.versions = ProjectBeanFactoryImpl.this.versionBeanFactory.createVersionBeans(versions);
            return this;
        }

        public ProjectBeanBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ProjectBeanBuilder avatarUrls(Map<String, String> avatarUrls) {
            this.avatarUrls = avatarUrls;
            return this;
        }

        public ProjectBeanBuilder projectCategory(ProjectCategory projectCategory) {
            if (projectCategory != null) {
                this.projectCategory = new ProjectCategoryBean(projectCategory, ProjectBeanFactoryImpl.this.uriBuilder.build(ProjectBeanFactoryImpl.this.uriInfo, ProjectCategoryResource.class, projectCategory.getId().toString()));
            }
            return this;
        }

        public ProjectBeanBuilder muteRoles() {
            this.roles = null;
            return this;
        }

        public ProjectBeanBuilder muteAssigneeType() {
            this.assigneeType = null;
            return this;
        }

        public ProjectBeanBuilder muteUrl() {
            this.expandUrl = false;
            return this;
        }

        public ProjectBeanBuilder archived(boolean archived) {
            this.archived = archived;
            return this;
        }

        public ProjectBean build() {
            ProjectBean bean = new ProjectBean(this.expand, this.self, this.id, this.key, this.name, this.projectTypeKey, this.description, this.lead, this.assigneeType, this.url, this.email, this.components, this.versions, this.issueTypes, this.roles, this.avatarUrls, this.projectKeys, this.projectCategory, this.archived);
            if (this.expandLead) {
                bean.expandLead();
            }
            if (this.expandDescription) {
                bean.expandDescription();
            }
            if (this.expandUrl) {
                bean.expandUrl();
            }
            return bean;
        }
    }
}

