/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.project;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.project.ProjectRoleBean;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.issue.project.ActorInputBean;
import com.atlassian.jira.rest.v2.issue.project.CreateUpdateRoleRequestBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleActorsBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleBeanFactory;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.DefaultRoleActorsImpl;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.atlassian.fugue.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="role")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@WebSudoRequired
public class RoleResource {
    private final ProjectRoleService projectRoleService;
    private final ProjectRoleBeanFactory projectRoleBeanFactory;
    private final ResponseFactory responses;
    private final I18nHelper i18n;
    private final JiraAuthenticationContext authContext;
    private final GlobalPermissionManager permissionManager;

    @Inject
    public RoleResource(ProjectRoleService projectRoleService, ProjectRoleBeanFactory projectRoleBeanFactory, ResponseFactory responses, I18nHelper i18n, JiraAuthenticationContext authContext, GlobalPermissionManager permissionManager) {
        this.projectRoleService = projectRoleService;
        this.projectRoleBeanFactory = projectRoleBeanFactory;
        this.responses = responses;
        this.i18n = i18n;
        this.authContext = authContext;
        this.permissionManager = permissionManager;
    }

    @GET
    public Response getProjectRoles() {
        ArrayList<ProjectRoleBean> roles = new ArrayList<ProjectRoleBean>();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Collection projectRoles = this.projectRoleService.getProjectRoles((ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return this.responses.errorResponse((ErrorCollection)errorCollection);
        }
        for (ProjectRole projectRole : projectRoles) {
            DefaultRoleActors actors = this.projectRoleService.getDefaultRoleActors(projectRole, (ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                return this.responses.errorResponse((ErrorCollection)errorCollection);
            }
            roles.add(this.projectRoleBeanFactory.projectRole(projectRole, actors));
        }
        return Response.ok(roles).build();
    }

    @GET
    @Path(value="{id}")
    public Response getProjectRolesById(@PathParam(value="id") long roleId) {
        return (Response)this.getProjectRole(roleId).left().on((Function)new Function<ProjectRole, Response>(){

            @Override
            public Response apply(final ProjectRole projectRole) {
                return (Response)RoleResource.this.withDefaultRoleActors(projectRole).left().on((Function)new Function<DefaultRoleActors, Response>(){

                    @Override
                    @Nullable
                    public Response apply(@Nullable DefaultRoleActors defaultRoleActors) {
                        return Response.ok((Object)RoleResource.this.projectRoleBeanFactory.projectRole(projectRole, defaultRoleActors)).build();
                    }
                });
            }
        });
    }

    @POST
    public Response createProjectRole(CreateUpdateRoleRequestBean inputBean) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        String description = inputBean.getDescription() == null ? "" : inputBean.getDescription();
        ProjectRole projectRole = this.projectRoleService.createProjectRole((ProjectRole)new ProjectRoleImpl(inputBean.getName(), description), (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return this.responses.errorResponse((ErrorCollection)errorCollection);
        }
        DefaultRoleActorsImpl actors = new DefaultRoleActorsImpl(projectRole.getId(), Collections.emptySet());
        return Response.ok((Object)this.projectRoleBeanFactory.projectRole(projectRole, (DefaultRoleActors)actors)).build();
    }

    @POST
    @Path(value="{id}")
    public Response partialUpdateProjectRole(@PathParam(value="id") long roleId, final CreateUpdateRoleRequestBean updateProjectRoleBean) {
        final SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        return (Response)this.getProjectRole(roleId).left().on((Function)new Function<ProjectRole, Response>(){

            @Override
            @Nullable
            public Response apply(@Nullable ProjectRole projectRole) {
                RoleResource.this.validatePartialUpdate(updateProjectRoleBean, errorCollection);
                if (errorCollection.hasAnyErrors()) {
                    return RoleResource.this.responses.errorResponse((ErrorCollection)errorCollection);
                }
                final ProjectRole updatedProjectRole = RoleResource.this.getPartiallyUpdatedProjectRole(projectRole, updateProjectRoleBean);
                RoleResource.this.projectRoleService.updateProjectRole(updatedProjectRole, (ErrorCollection)errorCollection);
                if (errorCollection.hasAnyErrors()) {
                    return RoleResource.this.responses.errorResponse((ErrorCollection)errorCollection);
                }
                return (Response)RoleResource.this.withDefaultRoleActors(updatedProjectRole).left().on((Function)new Function<DefaultRoleActors, Response>(){

                    @Override
                    public Response apply(DefaultRoleActors defaultRoleActors) {
                        return Response.ok((Object)RoleResource.this.projectRoleBeanFactory.projectRole(updatedProjectRole, defaultRoleActors)).build();
                    }
                });
            }
        });
    }

    @PUT
    @Path(value="{id}")
    public Response fullyUpdateProjectRole(final @PathParam(value="id") long roleId, final CreateUpdateRoleRequestBean updateProjectRoleBean) {
        final SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        return (Response)this.getProjectRole(roleId).left().on((Function)new Function<ProjectRole, Response>(){

            @Override
            @Nullable
            public Response apply(@Nullable ProjectRole projectRole) {
                RoleResource.this.validateFullUpdate(updateProjectRoleBean, errorCollection);
                if (errorCollection.hasAnyErrors()) {
                    return RoleResource.this.responses.errorResponse((ErrorCollection)errorCollection);
                }
                final ProjectRole updatedProjectRole = ProjectRoleImpl.Builder.from((ProjectRole)projectRole).id(Long.valueOf(roleId)).name(updateProjectRoleBean.getName()).description(updateProjectRoleBean.getDescription()).build();
                RoleResource.this.projectRoleService.updateProjectRole(updatedProjectRole, (ErrorCollection)errorCollection);
                if (errorCollection.hasAnyErrors()) {
                    return RoleResource.this.responses.errorResponse((ErrorCollection)errorCollection);
                }
                return (Response)RoleResource.this.withDefaultRoleActors(updatedProjectRole).left().on((Function)new Function<DefaultRoleActors, Response>(){

                    @Override
                    @Nullable
                    public Response apply(@Nullable DefaultRoleActors defaultRoleActors) {
                        return Response.ok((Object)RoleResource.this.projectRoleBeanFactory.projectRole(updatedProjectRole, defaultRoleActors)).build();
                    }
                });
            }
        });
    }

    @DELETE
    @Path(value="{id}")
    public Response deleteProjectRole(@PathParam(value="id") long roleId, final @QueryParam(value="swap") Long roleIdToSwap) {
        final SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        return (Response)this.getProjectRole(roleId).left().on((Function)new Function<ProjectRole, Response>(){

            @Override
            public Response apply(ProjectRole projectRole) {
                if (roleIdToSwap == null) {
                    ServiceResult serviceResult = RoleResource.this.projectRoleService.validateNoRoleUsage(projectRole);
                    if (!serviceResult.isValid()) {
                        return RoleResource.this.responses.errorResponse(serviceResult.getErrorCollection());
                    }
                } else {
                    ProjectRole roleToSwap = RoleResource.this.projectRoleService.getProjectRole(roleIdToSwap, (ErrorCollection)errorCollection);
                    if (roleToSwap == null) {
                        errorCollection.addErrorMessage("rest.swap.role.not.found", ErrorCollection.Reason.VALIDATION_FAILED);
                    }
                    if (errorCollection.hasAnyErrors()) {
                        return RoleResource.this.responses.errorResponse((ErrorCollection)errorCollection);
                    }
                    RoleResource.this.projectRoleService.swapRole(projectRole, roleToSwap);
                }
                RoleResource.this.projectRoleService.deleteProjectRole(projectRole, (ErrorCollection)errorCollection);
                if (errorCollection.hasAnyErrors()) {
                    return RoleResource.this.responses.errorResponse((ErrorCollection)errorCollection);
                }
                return Response.noContent().build();
            }
        });
    }

    @GET
    @Path(value="{id}/actors")
    public Response getProjectRoleActorsForRole(@PathParam(value="id") long roleId) {
        return (Response)this.getProjectRole(roleId).left().on((Function)new Function<ProjectRole, Response>(){

            @Override
            public Response apply(ProjectRole projectRole) {
                return (Response)RoleResource.this.withDefaultRoleActors(projectRole).left().on((Function)new Function<DefaultRoleActors, Response>(){

                    @Override
                    public Response apply(DefaultRoleActors defaultRoleActors) {
                        return Response.ok((Object)ProjectRoleActorsBean.from(defaultRoleActors.getRoleActors())).build();
                    }
                });
            }
        });
    }

    @POST
    @Path(value="{id}/actors")
    public Response addProjectRoleActorsToRole(@PathParam(value="id") long roleId, final ActorInputBean actorsInput) {
        final SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        return (Response)this.getProjectRole(roleId).left().on((Function)new Function<ProjectRole, Response>(){

            @Override
            public Response apply(final @Nullable ProjectRole projectRole) {
                return (Response)RoleResource.this.withValidationOfActorInputBean(actorsInput).left().on((Function)new Function<ValidationActorsResult<Collection<String>>, Response>(){

                    @Override
                    public Response apply(ValidationActorsResult<Collection<String>> validationResult) {
                        RoleResource.this.projectRoleService.addDefaultActorsToProjectRole((Collection)((ValidationActorsResult)validationResult).roleEntity, projectRole, ((ValidationActorsResult)validationResult).roleType, (ErrorCollection)errorCollection);
                        if (errorCollection.hasAnyErrors()) {
                            return RoleResource.this.responses.errorResponse((ErrorCollection)errorCollection);
                        }
                        return (Response)RoleResource.this.withDefaultRoleActors(projectRole).left().on((Function)new Function<DefaultRoleActors, Response>(){

                            @Override
                            public Response apply(DefaultRoleActors defaultRoleActors) {
                                return Response.ok((Object)ProjectRoleActorsBean.from(defaultRoleActors.getRoleActors())).build();
                            }
                        });
                    }
                });
            }
        });
    }

    @DELETE
    @Path(value="{id}/actors")
    public Response deleteProjectRoleActorsFromRole(@PathParam(value="id") long roleId, final @QueryParam(value="user") String user, final @QueryParam(value="group") String group) {
        return (Response)this.getProjectRole(roleId).left().on((Function)new Function<ProjectRole, Response>(){

            @Override
            public Response apply(final @Nullable ProjectRole projectRole) {
                final SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                return (Response)RoleResource.this.withValidationOfInputUserNamesAndGroupNames(user, group).left().on((Function)new Function<ValidationActorsResult<String>, Response>(){

                    @Override
                    public Response apply(ValidationActorsResult<String> validationResult) {
                        RoleResource.this.projectRoleService.removeDefaultActorsFromProjectRole(Collections.singleton(((ValidationActorsResult)validationResult).roleEntity), projectRole, ((ValidationActorsResult)validationResult).roleType, (ErrorCollection)errorCollection);
                        if (errorCollection.hasAnyErrors()) {
                            return RoleResource.this.responses.errorResponse((ErrorCollection)errorCollection);
                        }
                        return (Response)RoleResource.this.withDefaultRoleActors(projectRole).left().on((Function)new Function<DefaultRoleActors, Response>(){

                            @Override
                            public Response apply(DefaultRoleActors defaultRoleActors) {
                                return Response.ok((Object)ProjectRoleActorsBean.from(defaultRoleActors.getRoleActors())).build();
                            }
                        });
                    }
                });
            }
        });
    }

    private void validateFullUpdate(CreateUpdateRoleRequestBean updateProjectRoleBean, SimpleErrorCollection errorCollection) {
        if (updateProjectRoleBean.getName() == null || updateProjectRoleBean.getDescription() == null) {
            errorCollection.addErrorMessage(this.i18n.getText("rest.role.name.and.description.required"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private ProjectRole getPartiallyUpdatedProjectRole(ProjectRole projectRole, CreateUpdateRoleRequestBean updateProjectRoleBean) {
        ProjectRoleImpl.Builder builder = ProjectRoleImpl.Builder.from((ProjectRole)projectRole).id(projectRole.getId());
        if (updateProjectRoleBean.getName() != null) {
            builder.name(updateProjectRoleBean.getName());
        } else {
            builder.description(updateProjectRoleBean.getDescription());
        }
        return builder.build();
    }

    private void validatePartialUpdate(CreateUpdateRoleRequestBean updateProjectRoleBean, SimpleErrorCollection errorCollection) {
        if (updateProjectRoleBean.getName() == null && updateProjectRoleBean.getDescription() == null) {
            errorCollection.addErrorMessage(this.i18n.getText("rest.role.name.or.description.required"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    @Nonnull
    private Either<Response, ProjectRole> getProjectRole(long roleId) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!this.hasAdminPermission(this.authContext.getLoggedInUser())) {
            return Either.left((Object)this.responses.forbidden("rest.authorization.admin.required", new String[0]));
        }
        ProjectRole projectRole = this.projectRoleService.getProjectRole(Long.valueOf(roleId), (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return Either.left((Object)this.responses.errorResponse((ErrorCollection)errorCollection));
        }
        if (projectRole == null) {
            return Either.left((Object)this.responses.notFound("rest.role.not.found", new String[0]));
        }
        return Either.right((Object)projectRole);
    }

    @Nonnull
    private Either<Response, DefaultRoleActors> withDefaultRoleActors(ProjectRole projectRole) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        DefaultRoleActors actors = this.projectRoleService.getDefaultRoleActors(projectRole, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return Either.left((Object)this.responses.errorResponse((ErrorCollection)errorCollection));
        }
        return Either.right((Object)actors);
    }

    private boolean hasAdminPermission(ApplicationUser currentUser) {
        return this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, currentUser);
    }

    private Either<Response, ValidationActorsResult<Collection<String>>> withValidationOfActorInputBean(ActorInputBean actorsInput) {
        return this.withValidationOfInputUserNamesAndGroupNames(actorsInput.getUsernames(), actorsInput.getGroupnames());
    }

    private <T> Either<Response, ValidationActorsResult<T>> withValidationOfInputUserNamesAndGroupNames(T usernames, T groupnames) {
        if (usernames != null && groupnames != null) {
            return Either.left((Object)this.responses.badRequest("rest.role.actors.add.username.or.groupname.both.cannot.be.provided", new String[0]));
        }
        if (usernames != null) {
            return Either.right(new ValidationActorsResult("atlassian-user-role-actor", usernames));
        }
        if (groupnames != null) {
            return Either.right(new ValidationActorsResult("atlassian-group-role-actor", groupnames));
        }
        return Either.left((Object)this.responses.badRequest("rest.role.actors.delete.username.or.groupname.required", new String[0]));
    }

    private static class ValidationActorsResult<T> {
        private final String roleType;
        private final T roleEntity;

        private ValidationActorsResult(String roleType, T roleEntity) {
            this.roleType = roleType;
            this.roleEntity = roleEntity;
        }
    }
}

