/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.users;

import com.atlassian.jira.user.util.DuplicatedUsersToDirectoriesMapping;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;

public class DuplicatedUsersMapBeanFactory {
    private DuplicatedUsersMapBeanFactory() {
    }

    public static Map<String, List<DirectoryWithUserActiveBean>> getBean(DuplicatedUsersToDirectoriesMapping mapping) {
        return mapping.getUsernames().stream().collect(Collectors.toMap(Function.identity(), name -> DuplicatedUsersMapBeanFactory.toBeans(mapping.getDirectoriesForUser(name))));
    }

    private static List<DirectoryWithUserActiveBean> toBeans(List<DuplicatedUsersToDirectoriesMapping.DirectoryWithUserActive> directoriesForUser) {
        return directoriesForUser.stream().map(originalDirectory -> new DirectoryWithUserActiveBean(originalDirectory.getDirectoryId(), originalDirectory.getDirectoryName(), originalDirectory.isUserActive())).collect(Collectors.toList());
    }

    public static class DirectoryWithUserActiveBean {
        @XmlElement
        private final long directoryId;
        @XmlElement
        private final String directoryName;
        @XmlElement
        private final boolean userActive;

        DirectoryWithUserActiveBean(long directoryId, String getDirectoryName, boolean userActive) {
            this.directoryId = directoryId;
            this.directoryName = getDirectoryName;
            this.userActive = userActive;
        }

        public long getDirectoryId() {
            return this.directoryId;
        }

        public String getDirectoryName() {
            return this.directoryName;
        }

        public boolean isUserActive() {
            return this.userActive;
        }
    }
}

