/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.notification;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.notification.NotificationScheme;
import com.atlassian.jira.notification.NotificationSchemeService;
import com.atlassian.jira.rest.api.notification.NotificationSchemeBean;
import com.atlassian.jira.rest.api.notification.NotificationSchemeBeanFactory;
import com.atlassian.jira.rest.api.notification.NotificationSchemeExpandParam;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="notificationscheme")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class NotificationSchemeResource {
    private static final Integer MAX_RESULTS = 50;
    private final NotificationSchemeService notificationSchemeService;
    private final JiraAuthenticationContext authContext;
    private final ResponseFactory responseFactory;
    private final NotificationSchemeBeanFactory notificationSchemeBeanFactory;

    @Inject
    public NotificationSchemeResource(NotificationSchemeService notificationSchemeService, JiraAuthenticationContext authContext, ResponseFactory responseFactory, NotificationSchemeBeanFactory notificationSchemeBeanFactory) {
        this.notificationSchemeService = notificationSchemeService;
        this.authContext = authContext;
        this.responseFactory = responseFactory;
        this.notificationSchemeBeanFactory = notificationSchemeBeanFactory;
    }

    @GET
    @Path(value="{id}")
    public Response getNotificationScheme(final @PathParam(value="id") Long notificationSchemeId, @QueryParam(value="expand") String expand) {
        return (Response)this.responseFactory.toResponse(this.notificationSchemeBeanFactory.parseExpandQuery(expand)).left().on((Function)new Function<List<NotificationSchemeExpandParam>, Response>(){

            @Override
            public Response apply(final List<NotificationSchemeExpandParam> expands) {
                ServiceOutcome notificationSchemeOutcome = NotificationSchemeResource.this.notificationSchemeService.getNotificationScheme(NotificationSchemeResource.this.authContext.getUser(), notificationSchemeId);
                return (Response)NotificationSchemeResource.this.responseFactory.validateOutcome(notificationSchemeOutcome).left().on((Function)new Function<NotificationScheme, Response>(){

                    @Override
                    public Response apply(NotificationScheme notificationScheme) {
                        return NotificationSchemeResource.this.responseFactory.okNoCache(NotificationSchemeResource.this.notificationSchemeBeanFactory.createNotificationSchemeBean(notificationScheme, expands));
                    }
                });
            }
        });
    }

    @GET
    public Response getNotificationSchemes(final @QueryParam(value="startAt") Long startAt, final @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="expand") String expand) {
        return (Response)this.responseFactory.toResponse(this.notificationSchemeBeanFactory.parseExpandQuery(expand)).left().on((Function)new Function<List<NotificationSchemeExpandParam>, Response>(){

            @Override
            public Response apply(List<NotificationSchemeExpandParam> expands) {
                PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)((Integer)MoreObjects.firstNonNull((Object)maxResults, (Object)MAX_RESULTS)));
                Page notificationSchemes = NotificationSchemeResource.this.notificationSchemeService.getNotificationSchemes(NotificationSchemeResource.this.authContext.getLoggedInUser(), pageRequest);
                PageBean<NotificationSchemeBean> pageBean = PageBean.from(pageRequest, notificationSchemes).build(scheme -> NotificationSchemeResource.this.notificationSchemeBeanFactory.createNotificationSchemeBean((NotificationScheme)scheme, expands));
                return NotificationSchemeResource.this.responseFactory.okNoCache(pageBean);
            }
        });
    }
}

