/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.search.FilterBean;
import com.atlassian.jira.rest.v2.search.FilterPermissionBeanFactory;
import com.atlassian.jira.rest.v2.search.FilterResource;
import com.atlassian.jira.rest.v2.search.FilterSubscriptionBeanListWrapper;
import com.atlassian.jira.rest.v2.search.SearchResource;
import com.atlassian.jira.rest.v2.search.UserBeanListWrapper;
import com.atlassian.jira.rest.v2.search.UserListResolver;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.rights.ShareRight;
import com.atlassian.jira.sharing.rights.ShareRights;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.Streams;
import com.atlassian.query.Query;
import java.net.URI;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriInfo;

public class FilterBeanBuilder {
    private final JiraAuthenticationContext authContext;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final ProjectRoleManager projectRoleManager;
    private final UserManager userManager;
    private final JqlStringSupport jqlStringSupport;
    private final GroupManager groupManager;
    private final SchemeManager schemeManager;
    private final FilterSubscriptionService filterSubscriptionService;
    private final JiraBaseUrls jiraBaseUrls;
    private final LicenseCountService licenseCountService;
    private final FeatureManager featureManager;
    private final FilterPermissionBeanFactory filterPermissionBeanFactory;
    private final ShareManager shareManager;
    private final UserSearchService userSearchService;
    private final ResourceUriBuilder resourceUriBuilder;
    private SearchRequest filter;
    private UriInfo context;
    private ApplicationUser owner = null;
    private boolean favourite = false;

    public FilterBeanBuilder(JiraAuthenticationContext authContext, ProjectManager projectManager, PermissionManager permissionManager, ProjectRoleManager projectRoleManager, UserManager userManager, JqlStringSupport jqlStringSupport, GroupManager groupManager, SchemeManager schemeManager, FilterSubscriptionService filterSubscriptionService, JiraBaseUrls jiraBaseUrls, LicenseCountService licenseCountService, FeatureManager featureManager, FilterPermissionBeanFactory filterPermissionBeanFactory, ShareManager shareManager, UserSearchService userSearchService, ResourceUriBuilder resourceUriBuilder) {
        this.authContext = authContext;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.projectRoleManager = projectRoleManager;
        this.userManager = userManager;
        this.jqlStringSupport = jqlStringSupport;
        this.groupManager = groupManager;
        this.schemeManager = schemeManager;
        this.filterSubscriptionService = filterSubscriptionService;
        this.jiraBaseUrls = jiraBaseUrls;
        this.licenseCountService = licenseCountService;
        this.featureManager = featureManager;
        this.filterPermissionBeanFactory = filterPermissionBeanFactory;
        this.shareManager = shareManager;
        this.userSearchService = userSearchService;
        this.resourceUriBuilder = resourceUriBuilder;
    }

    public FilterBeanBuilder filter(SearchRequest filter) {
        this.filter = filter;
        return this;
    }

    public FilterBeanBuilder context(UriInfo context) {
        this.context = context;
        return this;
    }

    public FilterBeanBuilder owner(ApplicationUser owner) {
        this.owner = owner;
        return this;
    }

    public FilterBeanBuilder favourite(boolean favourite) {
        this.favourite = favourite;
        return this;
    }

    public FilterBean build() {
        if (this.filter == null) {
            return null;
        }
        if (this.context == null) {
            throw new IllegalStateException("No context set.");
        }
        String baseUrl = this.jiraBaseUrls.baseUrl();
        UserBean ownerBean = UserBeanBuilder.shortBuilder(this.jiraBaseUrls).user(this.owner).buildShort();
        URI issueNavUri = URI.create(baseUrl + "/issues/?filter=" + this.filter.getId());
        URI self = this.resourceUriBuilder.getBuilder(this.context.getBaseUriBuilder(), FilterResource.class).path(Long.toString(this.filter.getId())).build(new Object[0]);
        String jql = this.getJqlStringFromSearchRequest(this.filter);
        URI searchUri = this.resourceUriBuilder.getBuilder(this.context.getBaseUriBuilder(), SearchResource.class).queryParam("jql", new Object[]{"{0}"}).build(new Object[]{jql});
        Collection sharePermissions = Streams.stream((Iterable)this.filter.getPermissions()).map(sharePermission -> this.filterPermissionBeanFactory.buildPermissionBean(this.authContext.getLoggedInUser(), (SharePermission)sharePermission)).collect(Collectors.toList());
        FilterSubscriptionBeanListWrapper filterSubscribtionBeanListWrapper = new FilterSubscriptionBeanListWrapper(this.filterSubscriptionService, this.userManager, this.authContext.getUser(), this.filter, this.jiraBaseUrls);
        UserListResolver userListResolver = new UserListResolver(this.authContext, this.userManager, this.groupManager, this.licenseCountService, this.projectManager, this.permissionManager, this.projectRoleManager, this.schemeManager, this.featureManager, this.userSearchService, sharePermissions);
        UserBeanListWrapper userBeanListWrapper = new UserBeanListWrapper(this.jiraBaseUrls, userListResolver, 1000);
        boolean editable = this.shareManager.isSharedWith(this.authContext.getLoggedInUser(), (SharedEntity)this.filter, (ShareRight)ShareRights.VIEW_EDIT);
        return new FilterBean(self, Long.toString(this.filter.getId()), this.filter.getName(), this.filter.getDescription(), ownerBean, jql, issueNavUri, searchUri, this.favourite, sharePermissions, filterSubscribtionBeanListWrapper, userBeanListWrapper, editable);
    }

    private String getJqlStringFromSearchRequest(SearchRequest searchRequest) {
        Query query = searchRequest.getQuery();
        String queryString = query.getQueryString();
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.JQL_FILTER_PRESERVE_USER_INPUT) && queryString != null ? queryString : this.jqlStringSupport.generateJqlString(query);
    }
}

