/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.project.ProjectRoleBean;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBeanFactory;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleBeanFactory;
import com.atlassian.jira.rest.v2.search.FilterPermissionBean;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.sharing.type.ShareTypePermissionChecker;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.collect.ImmutableMap;
import java.util.function.BiFunction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FilterPermissionBeanFactory {
    private final ProjectBeanFactory projectBeanFactory;
    private final ProjectManager projectManager;
    private final ProjectRoleManager projectRoleManager;
    private final ProjectRoleBeanFactory projectRoleBeanFactory;
    private final JiraBaseUrls jiraBaseUrls;
    private final ShareTypeFactory shareTypeFactory;
    private final UserManager userManager;
    private final ImmutableMap<ShareType.Name, BiFunction<ApplicationUser, SharePermission, FilterPermissionBean>> mapFunction;

    @Autowired
    public FilterPermissionBeanFactory(ProjectBeanFactory projectBeanFactory, ProjectManager projectManager, ProjectRoleManager projectRoleManager, ProjectRoleBeanFactory projectRoleBeanFactory, JiraBaseUrls jiraBaseUrls, ShareTypeFactory shareTypeFactory, UserManager userManager) {
        this.projectBeanFactory = projectBeanFactory;
        this.projectManager = projectManager;
        this.projectRoleManager = projectRoleManager;
        this.projectRoleBeanFactory = projectRoleBeanFactory;
        this.jiraBaseUrls = jiraBaseUrls;
        this.shareTypeFactory = shareTypeFactory;
        this.userManager = userManager;
        this.mapFunction = ImmutableMap.of((Object)ShareType.Name.GLOBAL, this::fromGlobal, (Object)ShareType.Name.AUTHENTICATED, this::fromAuthenticated, (Object)ShareType.Name.GROUP, this::fromGroup, (Object)ShareType.Name.PROJECT, this::fromProject, (Object)ShareType.Name.USER, this::fromUser);
    }

    public FilterPermissionBean buildPermissionBean(ApplicationUser user, SharePermission sharePermission) {
        return (FilterPermissionBean)((BiFunction)this.mapFunction.get((Object)sharePermission.getType())).apply(user, sharePermission);
    }

    private FilterPermissionBean fromGlobal(ApplicationUser user, SharePermission sharePermission) {
        return new FilterPermissionBean(sharePermission.getId(), ShareType.Name.GLOBAL.get(), null, null, null, null, sharePermission.isView(), sharePermission.isEdit());
    }

    private FilterPermissionBean fromAuthenticated(ApplicationUser user, SharePermission sharePermission) {
        return new FilterPermissionBean(sharePermission.getId(), ShareType.Name.AUTHENTICATED.get(), null, null, null, null, sharePermission.isView(), sharePermission.isEdit());
    }

    private FilterPermissionBean fromGroup(ApplicationUser user, SharePermission sharePermission) {
        String groupKey = sharePermission.getParam1();
        GroupJsonBean group = new GroupJsonBeanBuilder(this.jiraBaseUrls).name(groupKey).build();
        return new FilterPermissionBean(sharePermission.getId(), ShareType.Name.GROUP.get(), null, null, group, null, sharePermission.isView(), sharePermission.isEdit());
    }

    private FilterPermissionBean fromProject(ApplicationUser applicationUser, SharePermission sharePermission) {
        ShareTypePermissionChecker permissionChecker = this.shareTypeFactory.getShareType(sharePermission.getType()).getPermissionsChecker();
        if (!permissionChecker.hasPermission(applicationUser, sharePermission)) {
            return new FilterPermissionBean(sharePermission.getId(), ShareType.Name.PROJECT_UNKNOWN.get(), null, null, null, null, sharePermission.isView(), sharePermission.isEdit());
        }
        Long projectId = Long.valueOf(sharePermission.getParam1());
        Project project = this.projectManager.getProjectObj(projectId);
        ProjectBean projectBean = this.projectBeanFactory.shortProject(project);
        String roleKey = sharePermission.getParam2();
        if (null != roleKey) {
            Long id = Long.valueOf(roleKey);
            ProjectRole projectRole = this.projectRoleManager.getProjectRole(id);
            ProjectRoleBean projectRoleBean = this.projectRoleBeanFactory.projectRole(project, projectRole);
            return new FilterPermissionBean(sharePermission.getId(), ShareType.Name.PROJECT.get(), projectBean, projectRoleBean, null, null, sharePermission.isView(), sharePermission.isEdit());
        }
        return new FilterPermissionBean(sharePermission.getId(), ShareType.Name.PROJECT.get(), projectBean, null, null, null, sharePermission.isView(), sharePermission.isEdit());
    }

    private FilterPermissionBean fromUser(ApplicationUser currentUser, SharePermission sharePermission) {
        String userKey = sharePermission.getParam1();
        ApplicationUser userToBeSharedWith = this.userManager.getUserByKey(userKey);
        if (userToBeSharedWith == null) {
            return new FilterPermissionBean(sharePermission.getId(), ShareType.Name.USER_UNKNOWN.get(), null, null, null, null, sharePermission.isView(), sharePermission.isEdit());
        }
        UserBean userBean = UserBeanBuilder.shortBuilder(this.jiraBaseUrls).user(userToBeSharedWith).buildShort();
        return new FilterPermissionBean(sharePermission.getId(), ShareType.Name.USER.get(), null, null, null, userBean, sharePermission.isView(), sharePermission.isEdit());
    }
}

