/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.user.anonymization;

import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public abstract class ResultWithErrorsAndWarningsBean
implements Serializable {
    public static final String GENERAL = "GENERAL";
    @XmlElement
    private Map<String, ErrorCollection> errors;
    @XmlElement
    private Map<String, ErrorCollection> warnings;

    ResultWithErrorsAndWarningsBean() {
    }

    ResultWithErrorsAndWarningsBean(@Nonnull Map<String, ErrorCollection> errors, @Nonnull Map<String, ErrorCollection> warnings) {
        this.errors = Objects.requireNonNull(errors);
        this.warnings = Objects.requireNonNull(warnings);
    }

    @Nonnull
    static <T> Map<String, ErrorCollection> getErrorsFromOperationReport(@Nonnull AnonymizeUserService.OperationsReport<T> operationsReport) {
        return operationsReport.getReports().stream().filter(report -> report.getResult().getErrorCollection().hasAnyErrors()).collect(Collectors.toMap(report -> report.getOperation().toString(), report -> ErrorCollection.of(report.getResult().getErrorCollection())));
    }

    @Nonnull
    static <T> Map<String, ErrorCollection> getWarningsFromOperationReport(@Nonnull AnonymizeUserService.OperationsReport<T> operationsReport) {
        return operationsReport.getReports().stream().flatMap(report -> report.getResult().getWarnings().entrySet().stream()).filter(entrySet -> ((com.atlassian.jira.util.ErrorCollection)entrySet.getValue()).hasAnyErrors()).collect(Collectors.toMap(Map.Entry::getKey, e -> ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)e.getValue())));
    }

    @Nonnull
    public Map<String, ErrorCollection> getErrors() {
        return this.errors;
    }

    @Nonnull
    public Map<String, ErrorCollection> getWarnings() {
        return this.warnings;
    }
}

