/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.user.anonymization;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.user.anonymization.UserAnonymizationProgressBean;
import com.atlassian.jira.rest.v2.user.anonymization.UserAnonymizationRequestBean;
import com.atlassian.jira.rest.v2.user.anonymization.UserAnonymizationRerunRequestBean;
import com.atlassian.jira.rest.v2.user.anonymization.UserAnonymizationValidationBean;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.AnonymizationParameters;
import com.atlassian.jira.user.anonymize.AnonymizationResult;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.AnonymizeUserTaskContext;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.FixedSized;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@Path(value="user/anonymization")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class UserAnonymizationResource {
    private static final Logger log = Logger.getLogger(UserAnonymizationResource.class);
    public static final String EXPAND_AFFECTED_ENTITIES = "affectedEntities";
    private final AnonymizeUserService anonymizeUserService;
    private final JiraAuthenticationContext authenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final UserManager userManager;
    private final TaskManager taskManager;
    private final ClusterManager clusterManager;
    private final I18nHelper i18n;

    @Inject
    UserAnonymizationResource(@ComponentImport AnonymizeUserService anonymizeUserService, JiraAuthenticationContext authenticationContext, GlobalPermissionManager globalPermissionManager, JiraBaseUrls jiraBaseUrls, UserManager userManager, TaskManager taskManager, ClusterManager clusterManager, I18nHelper i18n) {
        this.anonymizeUserService = anonymizeUserService;
        this.authenticationContext = authenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.userManager = userManager;
        this.taskManager = taskManager;
        this.clusterManager = clusterManager;
        this.i18n = i18n;
    }

    @GET
    public Response validateUserAnonymization(@QueryParam(value="userKey") String userKey, @QueryParam(value="expand") String expand) {
        return this.validateUserAnonymization(userKey, false, null, null, this.expandAffectedEntities(expand));
    }

    @Path(value="/rerun")
    @GET
    public Response validateUserAnonymizationRerun(@QueryParam(value="userKey") String userKey, @QueryParam(value="oldUserKey") String oldUserKey, @QueryParam(value="oldUserName") String oldUserName, @QueryParam(value="expand") String expand) {
        return this.validateUserAnonymization(userKey, true, oldUserKey, oldUserName, this.expandAffectedEntities(expand));
    }

    private boolean expandAffectedEntities(String expand) {
        return EXPAND_AFFECTED_ENTITIES.equals(expand);
    }

    private Response validateUserAnonymization(@Nullable String userKey, boolean rerun, @Nullable String oldUserKey, @Nullable String oldUserName, boolean getAffectedEntities) {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.authenticationContext.getLoggedInUser())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorCollection.of(this.i18n.getText("rest.user.anonymize.forbidden"))).build();
        }
        if (StringUtils.isBlank((CharSequence)userKey)) {
            return this.missingParametersResponse((List<String>)ImmutableList.of((Object)"userKey"));
        }
        AnonymizeUserService.AnonymizeValidationResult validationResult = this.anonymizeUserService.preValidateAnonymize(AnonymizationParameters.builder().executor(this.authenticationContext.getLoggedInUser()).targetUser(userKey).rerunPluginPoints(rerun).oldUserKey(oldUserKey).oldUserName(oldUserName).getAffectedEntities(getAffectedEntities).build());
        UserAnonymizationValidationBean responseBean = UserAnonymizationValidationBean.from(validationResult, this.i18n);
        if (responseBean.isSuccess()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseBean).cacheControl(CacheControl.never()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)responseBean).cacheControl(CacheControl.never()).build();
    }

    @POST
    public Response scheduleUserAnonymization(UserAnonymizationRequestBean userAnonymizationRequestBean) throws URISyntaxException {
        List<String> missingParams = this.getMissingAnonymizationParameters(userAnonymizationRequestBean);
        if (!missingParams.isEmpty()) {
            return this.missingParametersResponse(missingParams);
        }
        AnonymizationParameters anonymizeRequest = AnonymizationParameters.builder().targetUser(userAnonymizationRequestBean.userKey).newOwnerKey(userAnonymizationRequestBean.newOwnerKey).rerunPluginPoints(false).getAffectedEntities(true).executor(this.authenticationContext.getLoggedInUser()).build();
        return this.scheduleUserAnonymization(anonymizeRequest);
    }

    @Path(value="/rerun")
    @POST
    public Response scheduleUserAnonymizationRerun(UserAnonymizationRerunRequestBean userAnonymizationRequestBean) throws URISyntaxException {
        List<String> missingParams = this.getMissingAnonymizationParameters(userAnonymizationRequestBean);
        if (!missingParams.isEmpty()) {
            return this.missingParametersResponse(missingParams);
        }
        AnonymizationParameters anonymizeRequest = AnonymizationParameters.builder().targetUser(userAnonymizationRequestBean.userKey).newOwnerKey(userAnonymizationRequestBean.newOwnerKey).rerunPluginPoints(true).oldUserKey(userAnonymizationRequestBean.oldUserKey).oldUserName(userAnonymizationRequestBean.oldUserName).getAffectedEntities(true).executor(this.authenticationContext.getLoggedInUser()).build();
        return this.scheduleUserAnonymization(anonymizeRequest);
    }

    @Nonnull
    private List<String> getMissingAnonymizationParameters(UserAnonymizationRequestBean userAnonymizationRequestBean) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        if (StringUtils.isBlank((CharSequence)userAnonymizationRequestBean.userKey)) {
            resultBuilder.add((Object)"userKey");
        }
        if (StringUtils.isBlank((CharSequence)userAnonymizationRequestBean.newOwnerKey)) {
            resultBuilder.add((Object)"newOwnerKey");
        }
        return resultBuilder.build();
    }

    private Response scheduleUserAnonymization(@Nonnull AnonymizationParameters anonymizationParameters) throws URISyntaxException {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.authenticationContext.getLoggedInUser())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorCollection.of(this.i18n.getText("rest.user.anonymize.forbidden"))).build();
        }
        AnonymizeUserTaskContext anonymizeUserTaskContext = this.createTaskContextFromParameters(anonymizationParameters);
        if (this.taskManager.hasLiveTaskWithContext((TaskContext)anonymizeUserTaskContext)) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)ErrorCollection.of(this.i18n.getText("rest.user.anonymize.already.running"))).build();
        }
        String taskName = this.i18n.getText("rest.user.anonymize.task");
        TaskDescriptor task = this.taskManager.submitTask((Callable)new AnonymizeUserCommand(anonymizationParameters), taskName, (TaskContext)anonymizeUserTaskContext);
        return Response.status((Response.Status)Response.Status.ACCEPTED).location(new URI(this.jiraBaseUrls.baseUrl() + task.getProgressURL())).entity((Object)UserAnonymizationProgressBean.fromTaskDescriptor((TaskDescriptor<AnonymizationResult>)task)).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="progress")
    public Response getProgress(@QueryParam(value="taskId") long taskId) throws URISyntaxException {
        Optional<TaskDescriptor<?>> task;
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.authenticationContext.getLoggedInUser())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorCollection.of(this.i18n.getText("rest.user.anonymize.progress.forbidden"))).build();
        }
        Optional<TaskDescriptor<?>> optional = task = taskId > 0L ? this.getTaskById(taskId) : this.getLastTask();
        if (!task.isPresent()) {
            return this.taskNotFoundResponse();
        }
        return this.taskProgressResponse(task.get());
    }

    @DELETE
    @Path(value="unlock")
    public Response unlockAnonymization() {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.authenticationContext.getLoggedInUser())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorCollection.of(this.i18n.getText("rest.user.anonymize.unlock.forbidden"))).build();
        }
        if (!this.clusterManager.isClustered()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of(this.i18n.getText("rest.user.anonymize.unlock.non.clustered"))).build();
        }
        TaskDescriptor task = this.taskManager.getLiveTask((TaskContext)AnonymizeUserTaskContext.EMPTY);
        if (task == null) {
            return this.taskNotFoundResponse();
        }
        if (this.clusterManager.isNodeAlive(task.getNodeId())) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)ErrorCollection.of(this.i18n.getText("rest.user.anonymize.unlock.node.still.running", task.getNodeId()))).build();
        }
        log.info((Object)String.format("Cancelling user anonymization task '%s' from node '%s'", task.getTaskId(), task.getNodeId()));
        this.taskManager.removeTask(task.getTaskId());
        return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)ImmutableMap.of()).build();
    }

    @Nonnull
    private AnonymizeUserTaskContext createTaskContextFromParameters(@Nonnull AnonymizationParameters parameters) {
        if (this.shouldGetTaskContextWithOldUsernameUserkey(parameters)) {
            return this.createTaskContextWithOldUsernameUserkey(parameters);
        }
        return this.createRegularTaskContext(parameters);
    }

    private boolean shouldGetTaskContextWithOldUsernameUserkey(@Nonnull AnonymizationParameters parameters) {
        return parameters.isRerunPluginPoints() && parameters.getOldUserKey() != null;
    }

    private AnonymizeUserTaskContext createTaskContextWithOldUsernameUserkey(AnonymizationParameters parameters) {
        ApplicationUser user = this.userManager.getUserByKeyEvenWhenUnknown(parameters.getUserKey());
        Objects.requireNonNull(parameters.getOldUserKey());
        if (user == null) {
            return new AnonymizeUserTaskContext(parameters.getOldUserKey(), parameters.getOldUserName(), true);
        }
        return new AnonymizeUserTaskContext(parameters.getOldUserKey(), parameters.getOldUserName(), user.getDisplayName(), true);
    }

    private AnonymizeUserTaskContext createRegularTaskContext(AnonymizationParameters parameters) {
        ApplicationUser user = this.userManager.getUserByKeyEvenWhenUnknown(parameters.getUserKey());
        if (user == null) {
            return new AnonymizeUserTaskContext(parameters.getUserKey(), parameters.isRerunPluginPoints());
        }
        return new AnonymizeUserTaskContext(user.getKey(), user.getName(), user.getDisplayName(), parameters.isRerunPluginPoints());
    }

    @Nonnull
    private Optional<TaskDescriptor<?>> getTaskById(long taskId) {
        TaskDescriptor task = this.taskManager.getTask(Long.valueOf(taskId));
        if (task != null && task.getTaskContext() instanceof AnonymizeUserTaskContext) {
            return Optional.of(task);
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<TaskDescriptor<?>> getLastTask() {
        Collection anonymizationTasks = this.taskManager.findTasks(descriptor -> descriptor.getTaskContext() instanceof AnonymizeUserTaskContext);
        return anonymizationTasks.stream().max(Comparator.comparing(TaskDescriptor::getTaskId));
    }

    @Nonnull
    private Response missingParametersResponse(@Nonnull List<String> fieldNames) {
        ImmutableList errorMessages = (ImmutableList)fieldNames.stream().map(fieldName -> this.i18n.getText("rest.missing.parameter", fieldName)).collect(ImmutableList.toImmutableList());
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((Collection<String>)errorMessages)).build();
    }

    @Nonnull
    private Response taskProgressResponse(@Nonnull TaskDescriptor<?> task) throws URISyntaxException {
        try {
            TaskDescriptor<?> anonymizationResultTaskDescriptor = task;
            boolean isExecutingNodeAlive = !this.clusterManager.isClustered() || this.clusterManager.isNodeAlive(task.getNodeId());
            return Response.status((Response.Status)Response.Status.OK).location(new URI(this.jiraBaseUrls.baseUrl() + task.getProgressURL())).entity((Object)UserAnonymizationProgressBean.fromTaskDescriptor(anonymizationResultTaskDescriptor, isExecutingNodeAlive)).cacheControl(CacheControl.never()).build();
        }
        catch (ClassCastException e) {
            return this.taskNotFoundResponse();
        }
    }

    @Nonnull
    private Response taskNotFoundResponse() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("rest.user.anonymize.progress.no.task.found"))).build();
    }

    @ParametersAreNonnullByDefault
    private class AnonymizeUserCommand
    implements Callable<AnonymizationResult>,
    ProvidesTaskProgress {
        private static final String ANONYMIZATION_PERCENTAGE = "rest.user.anonymize.percent.complete";
        private static final String ANONYMIZATION_CURRENT_TASK = "rest.user.anonymize.current.task";
        private final AnonymizationParameters anonymizationParameters;
        private volatile TaskProgressSink taskProgressSink;

        private AnonymizeUserCommand(AnonymizationParameters anonymizationParameters) {
            this.anonymizationParameters = anonymizationParameters;
        }

        @Override
        public AnonymizationResult call() throws Exception {
            AnonymizeUserService.AnonymizeValidationResult validationResult = UserAnonymizationResource.this.anonymizeUserService.validateAnonymize(this.anonymizationParameters);
            if (!validationResult.isValid()) {
                log.info((Object)String.format("User anonymization of user with key '%s' rejected due to a failed validation", this.anonymizationParameters.getUserKey()));
                return AnonymizationResult.from((AnonymizeUserService.AnonymizeValidationResult)validationResult);
            }
            int stepsCount = UserAnonymizationResource.this.anonymizeUserService.getStepCount(validationResult);
            return AnonymizationResult.from((AnonymizeUserService.AnonymizeValidationResult)validationResult, (AnonymizeUserService.AnonymizePerformResult)UserAnonymizationResource.this.anonymizeUserService.perform(validationResult, this.createContext(stepsCount)));
        }

        public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
            this.taskProgressSink = taskProgressSink;
        }

        private Context createContext(int stepsCount) {
            if (this.taskProgressSink == null) {
                log.warn((Object)"User anonymization is being started without the ability to report progress of sub-tasks.");
                return Contexts.nullContext();
            }
            return Contexts.builder().progress(this.taskProgressSink, UserAnonymizationResource.this.i18n, ANONYMIZATION_PERCENTAGE, ANONYMIZATION_CURRENT_TASK).sized((Sized)new FixedSized(stepsCount)).build();
        }
    }
}

