/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.test.util.lic;

import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.LicenseManager;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.common.util.ProductLicenseProperties;
import com.atlassian.extras.core.AtlassianLicenseFactory;
import com.atlassian.extras.core.DefaultAtlassianLicenseFactory;
import com.atlassian.extras.core.DefaultLicenseManager;
import com.atlassian.extras.core.DefaultProductLicense;
import com.atlassian.extras.core.jira.JiraProductLicenseFactory;
import com.atlassian.extras.core.plugins.PluginLicenseFactory;
import com.atlassian.extras.decoder.api.DelegatingLicenseDecoder;
import com.atlassian.extras.decoder.api.LicenseDecoder;
import com.atlassian.extras.decoder.v1.Version1LicenseDecoder;
import com.atlassian.extras.decoder.v2.Version2LicenseDecoder;
import com.atlassian.jira.test.util.lic.License;
import com.atlassian.jira.test.util.lic.ProductLicenseAdapter;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;

public final class LicenseReader {
    private static final Product SERVICE_DESK = new Product("ServiceDesk", "com.atlassian.servicedesk", true);
    private static final Product JIRA_ROLE = new Product("JIRA Role", "jira", false);
    private static final List<Product> LOOKUP_ORDER = ImmutableList.of((Object)JIRA_ROLE, (Object)SERVICE_DESK, (Object)Product.JIRA);
    private static final Pattern ACTIVE_PATTERN = Pattern.compile("jira\\.product\\.(.+)\\.active");
    private static final String NUMBER_USERS_TEMPLATE = "jira.product.%s.NumberOfUsers";
    private static final String SERVICE_DESK_ACTIVE = "com.atlassian.servicedesk.active";
    private static final String SERVICE_DESK_COUNT = "com.atlassian.servicedesk.numRoleCount";
    private static final String SOFTWARE_PRODUCT = "jira-software";
    private static final String SERVICE_DESK_PRODUCT = "jira-servicedesk";
    private static final LicenseDecoder licenseDecoder = new DelegatingLicenseDecoder((List)ImmutableList.of((Object)new Version2LicenseDecoder(), (Object)new Version1LicenseDecoder()));
    private static final LicenseManager licenseManager = LicenseReader.getLicenseManager(licenseDecoder);

    private LicenseReader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readLicenseEncodedString(String resource, Class<?> base) {
        try (InputStream input = LicenseReader.openResource(resource, base);){
            String string = IOUtils.toString((InputStream)input, (String)StandardCharsets.UTF_8.name());
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static License readLicense(String resource, Class<?> base) {
        String key = LicenseReader.readLicenseEncodedString(resource, base);
        ProductLicense productLicense = LicenseReader.getProductLicense(licenseManager.getLicense(key));
        if (productLicense == null) {
            throw new IllegalArgumentException(String.format("Resource '%s' does not contain a license.", resource));
        }
        return new ProductLicenseAdapter(key, productLicense, LicenseReader.parseRoles(key));
    }

    private static ProductLicense getProductLicense(AtlassianLicense license) {
        for (Product product : LOOKUP_ORDER) {
            ProductLicense productLicense = license.getProductLicense(product);
            if (productLicense == null) continue;
            return productLicense;
        }
        return null;
    }

    private static InputStream openResource(String resource, Class<?> base) {
        InputStream stream = base.getResourceAsStream(resource);
        if (stream == null && (stream = base.getClassLoader().getResourceAsStream(resource)) == null) {
            if (resource.startsWith("/resources/")) {
                return LicenseReader.openResource(resource.substring("/resources/".length()), base);
            }
            throw new RuntimeException(String.format("Unable to find resource '%s'.", resource));
        }
        return stream;
    }

    private static LicenseManager getLicenseManager(LicenseDecoder decoder) {
        HashMap<Product, Object> licenseFactoryMap = new HashMap<Product, Object>();
        licenseFactoryMap.put(Product.JIRA, new JiraProductLicenseFactory());
        licenseFactoryMap.put(SERVICE_DESK, new PluginLicenseFactory(SERVICE_DESK));
        licenseFactoryMap.put(JIRA_ROLE, (Object)new JiraRoleBasedLicenseFactory());
        DefaultAtlassianLicenseFactory atlassianLicenseFactory = new DefaultAtlassianLicenseFactory(licenseFactoryMap);
        return new DefaultLicenseManager(decoder, (AtlassianLicenseFactory)atlassianLicenseFactory);
    }

    private static Map<String, License.Role> parseRoles(String license) {
        ArrayList roles = new ArrayList();
        Properties properties = licenseDecoder.decode(license);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            Matcher matcher = ACTIVE_PATTERN.matcher(key);
            if (!matcher.matches() || !"true".equals(value)) continue;
            String namespace = matcher.group(1);
            String roleUsers = properties.getProperty(String.format(NUMBER_USERS_TEMPLATE, namespace));
            Iterables.addAll(roles, LicenseReader.roleFor(namespace, roleUsers));
        }
        if (roles.isEmpty()) {
            Iterables.addAll(roles, LicenseReader.fromOldJiraLicense(properties));
            Iterables.addAll(roles, LicenseReader.fromServiceDeskLicense(properties));
        }
        return Maps.uniqueIndex(roles, (Function)new Function<License.Role, String>(){

            public String apply(@Nullable License.Role input) {
                return input != null ? input.getProduct() : "NULL";
            }
        });
    }

    private static Option<License.Role> fromServiceDeskLicense(Properties properties) {
        if (Boolean.parseBoolean(properties.getProperty(SERVICE_DESK_ACTIVE))) {
            String userCount = properties.getProperty(SERVICE_DESK_COUNT);
            if (userCount == null) {
                userCount = properties.getProperty("NumberOfUsers");
            }
            return LicenseReader.roleFor(SERVICE_DESK_PRODUCT, userCount);
        }
        return Option.none();
    }

    private static Option<License.Role> fromOldJiraLicense(Properties properties) {
        ProductLicenseProperties licenseProperties = new ProductLicenseProperties(Product.JIRA, properties);
        if (licenseProperties.getBoolean("active")) {
            return LicenseReader.roleFor(SOFTWARE_PRODUCT, licenseProperties.getProperty("NumberOfUsers"));
        }
        return Option.none();
    }

    private static Option<License.Role> roleFor(String product, @Nullable String count) {
        if (count != null) {
            int countNumber = Integer.parseInt(count);
            return Option.some((Object)(countNumber < 0 ? new UnlimitedRole(product) : new LimitedRole(product, countNumber)));
        }
        return Option.none();
    }

    private static class TestProductLicense
    extends DefaultProductLicense {
        private TestProductLicense(Product product, LicenseProperties properties) {
            super(product, properties);
        }
    }

    private static class JiraRoleBasedLicenseFactory
    extends JiraProductLicenseFactory {
        private static final String PRODUCT_PREFIX = "jira.product";

        private JiraRoleBasedLicenseFactory() {
        }

        public ProductLicense getLicenseInternal(Product product, LicenseProperties licenseProperties) {
            return new TestProductLicense(product, licenseProperties);
        }

        public boolean hasLicense(Product product, LicenseProperties licenseProperties) {
            for (String key : licenseProperties.getPropertiesEndingWith("active").keySet()) {
                if (!key.startsWith(PRODUCT_PREFIX)) continue;
                return true;
            }
            return false;
        }
    }

    private static class LimitedRole
    implements License.Role {
        private final int count;
        private final String product;

        private LimitedRole(String product, int count) {
            this.count = count;
            this.product = product;
        }

        @Override
        public String getProduct() {
            return this.product;
        }

        @Override
        public int getNumberOfUsers() {
            return this.count;
        }

        @Override
        public boolean isUnlimitedUsers() {
            return false;
        }
    }

    private static class UnlimitedRole
    implements License.Role {
        private final String product;

        private UnlimitedRole(String product) {
            this.product = product;
        }

        @Override
        public String getProduct() {
            return this.product;
        }

        @Override
        public int getNumberOfUsers() {
            return -1;
        }

        @Override
        public boolean isUnlimitedUsers() {
            return true;
        }
    }
}

