/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.test.util.lic;

import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.jira.test.util.lic.License;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

final class ProductLicenseAdapter
implements License {
    private final String key;
    private final ProductLicense productLicense;
    private final Map<String, License.Role> roles;

    ProductLicenseAdapter(String key, ProductLicense productLicense, Map<String, License.Role> roles) {
        this.productLicense = (ProductLicense)Preconditions.checkNotNull((Object)productLicense, (Object)"productLicense is null");
        this.key = (String)Preconditions.checkNotNull((Object)StringUtils.stripToNull((String)key), (Object)"key is empty");
        this.roles = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(roles, (Object)"roles is blank")));
    }

    @Override
    public String getLicenseString() {
        return this.key;
    }

    @Override
    public String getDescription() {
        return this.productLicense.getDescription();
    }

    @Override
    public String getOrganisation() {
        return this.productLicense.getOrganisation().getName();
    }

    @Override
    public String getSen() {
        return this.productLicense.getSupportEntitlementNumber();
    }

    @Override
    public boolean isEvaluation() {
        return this.productLicense.isEvaluation();
    }

    @Override
    public Option<Date> getSubscriptionExpiryDate() {
        return Option.option((Object)this.productLicense.getExpiryDate());
    }

    @Override
    public Option<Date> getMaintenanceExpiryDate() {
        return Option.option((Object)this.productLicense.getMaintenanceExpiryDate());
    }

    @Override
    public Map<String, License.Role> getRoles() {
        return this.roles;
    }

    @Override
    public LicenseType getLicenseType() {
        return this.productLicense.getLicenseType();
    }

    @Override
    @Nullable
    public String getProperty(String property) {
        return this.productLicense.getProperty(property);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductLicenseAdapter that = (ProductLicenseAdapter)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key;
    }
}

