/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.ofbiz.test.mock.MockSequenceUtil;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.mockobjects.servlet.MockHttpServletRequest;
import com.mockobjects.servlet.MockHttpServletResponse;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockito.Mockito;
import org.ofbiz.core.entity.SequenceUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;

public class JiraTestUtil {
    public static final String TESTS_BASE = "com/atlassian/jira";

    public static void loginUser(ApplicationUser user) {
        JiraTestUtil.loginUserImpl(user);
    }

    private static void loginUserImpl(ApplicationUser user) {
        Map session = ActionContext.getSession();
        session.put("seraph_defaultauthenticator_user", user);
        session.put("seraph_defaultauthenticator_user_id", user.getName());
        session.put("seraph_defaultauthenticator_logged_out_user", null);
        ((JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class)).setLoggedInUser(user);
    }

    public static void logoutUser(ApplicationUser user) {
        JiraTestUtil.logoutUserImpl(user);
    }

    private static void logoutUserImpl(ApplicationUser user) {
        ActionContext.getSession().put("seraph_defaultauthenticator_logged_out_user", user);
        ((JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class)).clearLoggedInUser();
    }

    public static void resetRequestAndResponse() {
        ServletActionContext.setRequest(null);
        ServletActionContext.setResponse(null);
    }

    @Deprecated
    public static MockHttpServletResponse setupExpectedRedirect(String url) throws IOException {
        MockHttpServletResponse response = new MockHttpServletResponse();
        response.setExpectedRedirect(url);
        ServletActionContext.setResponse((HttpServletResponse)response);
        return response;
    }

    public static HttpServletResponse mockExpectedRedirect(String url) {
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        ServletActionContext.setResponse((HttpServletResponse)response);
        return response;
    }

    public static MockHttpServletResponse setupExpectedInternalRedirect(String url) throws IOException {
        MockHttpServletRequest request = new MockHttpServletRequest();
        ServletActionContext.setRequest((HttpServletRequest)request);
        MockHttpServletResponse response = new MockHttpServletResponse();
        response.setExpectedRedirect(url);
        ServletActionContext.setResponse((HttpServletResponse)response);
        return response;
    }

    public static void setupMockSequenceUtil() {
        String helperName = CoreFactory.getGenericDelegator().getEntityHelperName("SequenceValueItem");
        ModelEntity seqEntity = CoreFactory.getGenericDelegator().getModelEntity("SequenceValueItem");
        CoreFactory.getGenericDelegator().setSequencer((SequenceUtil)new MockSequenceUtil(helperName, seqEntity, "seqName", "seqId"));
    }

    public static MockHttpServletRequest setupGetContextPath(String contextPath) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setupGetContextPath(contextPath);
        ServletActionContext.setRequest((HttpServletRequest)request);
        return request;
    }
}

