/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class ErrorMatcher
extends TypeSafeMatcher<ServiceOutcome<?>> {
    private final ErrorCollection errorCollection = new SimpleErrorCollection();

    public ErrorMatcher setReasons(Set<ErrorCollection.Reason> reasons) {
        this.errorCollection.setReasons(reasons);
        return this;
    }

    public ErrorMatcher addReasons(Set<ErrorCollection.Reason> reasons) {
        this.errorCollection.addReasons(reasons);
        return this;
    }

    public ErrorMatcher addReason(ErrorCollection.Reason reason) {
        this.errorCollection.addReason(reason);
        return this;
    }

    public ErrorMatcher addErrors(Map<String, String> errors) {
        this.errorCollection.addErrors(errors);
        return this;
    }

    public ErrorMatcher addErrorMessages(Collection<String> errorMessages) {
        this.errorCollection.addErrorMessages(errorMessages);
        return this;
    }

    public ErrorMatcher addErrorMessage(String message, ErrorCollection.Reason reason) {
        this.errorCollection.addErrorMessage(message, reason);
        return this;
    }

    public ErrorMatcher addErrorCollection(ErrorCollection errors) {
        this.errorCollection.addErrorCollection(errors);
        return this;
    }

    public ErrorMatcher addError(String field, String message) {
        this.errorCollection.addError(field, message);
        return this;
    }

    public ErrorMatcher addError(String field, String message, ErrorCollection.Reason reason) {
        this.errorCollection.addError(field, message, reason);
        return this;
    }

    public ErrorMatcher addErrorMessage(String message) {
        this.errorCollection.addErrorMessage(message);
        return this;
    }

    protected void describeMismatchSafely(ServiceOutcome<?> item, Description mismatchDescription) {
        mismatchDescription.appendText(this.toString(item.getErrorCollection()));
    }

    protected boolean matchesSafely(ServiceOutcome<?> serviceOutcome) {
        ErrorCollection outcomeCollection = serviceOutcome.getErrorCollection();
        return outcomeCollection.getReasons().equals(this.errorCollection.getReasons()) && outcomeCollection.getErrors().equals(this.errorCollection.getErrors()) && ErrorMatcher.equalsIgnoreOrder(outcomeCollection.getErrorMessages(), this.errorCollection.getErrorMessages());
    }

    private static boolean equalsIgnoreOrder(Collection<?> first, Collection<?> second) {
        return first.size() == second.size() && first.containsAll(second);
    }

    public void describeTo(Description description) {
        description.appendText(this.toString(this.errorCollection));
    }

    private String toString(ErrorCollection collection) {
        return String.format("Errors: [%s, %s, %s]", collection.getErrors(), collection.getErrorMessages(), collection.getReasons());
    }
}

