/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeCompleteFormatter;
import com.atlassian.jira.datetime.DateTimeDateFormatter;
import com.atlassian.jira.datetime.DateTimeDatePickerFormatter;
import com.atlassian.jira.datetime.DateTimeFormatStrategy;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeFormatterImpl;
import com.atlassian.jira.datetime.DateTimeFormatterServiceProvider;
import com.atlassian.jira.datetime.DateTimeFormatterSupplier;
import com.atlassian.jira.datetime.DateTimeISO8601DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimePickerFormatter;
import com.atlassian.jira.datetime.DateTimeRFC1123DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeRFC822DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeRelativeFormatter;
import com.atlassian.jira.datetime.DateTimeSettings;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.datetime.DateTimeTimeFormatter;
import com.atlassian.jira.datetime.JodaFormatterSupplier;
import com.atlassian.jira.datetime.Source;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.MockApplicationUser;
import com.atlassian.jira.util.RealClock;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class DateTimeFormatterFactoryStub
implements DateTimeFormatterFactory {
    private DateTimeZone jiraTimeZone = DateTimeZone.getDefault();
    private Locale jiraLocale = Locale.getDefault();
    private DateTimeZone userTimeZone = DateTimeZone.getDefault();
    private Locale userLocale = Locale.getDefault();
    private boolean useRelativeDates = true;
    private final JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)Mockito.mock(JiraAuthenticationContext.class);
    private final ImmutableMap<DateTimeStyle, DateTimeFormatStrategy> patterns;
    private DateTimeStyle style = DateTimeStyle.RELATIVE;

    public DateTimeFormatterFactoryStub() {
        Mockito.when((Object)this.jiraAuthenticationContext.getLoggedInUser()).thenReturn((Object)new MockApplicationUser("mockMeNot"));
        Mockito.when((Object)this.jiraAuthenticationContext.getUser()).thenReturn((Object)new MockApplicationUser("mockMeNot"));
        ApplicationProperties applicationProperties = (ApplicationProperties)Mockito.mock(ApplicationProperties.class);
        Mockito.when((Object)applicationProperties.getOption("jira.lf.date.relativize")).thenAnswer((Answer)new RelativeDatesAnswer());
        this.patterns = ImmutableMap.builder().put((Object)DateTimeStyle.RELATIVE, (Object)new DateTimeRelativeFormatter((DateTimeFormatterServiceProvider)new ServiceProviderStub(), (JodaFormatterSupplier)new JodaFormatterStub(), applicationProperties, (Clock)RealClock.getInstance())).put((Object)DateTimeStyle.COMPLETE, (Object)new DateTimeCompleteFormatter((DateTimeFormatterServiceProvider)new ServiceProviderStub(), (JodaFormatterSupplier)new JodaFormatterStub())).put((Object)DateTimeStyle.DATE, (Object)new DateTimeDateFormatter((DateTimeFormatterServiceProvider)new ServiceProviderStub(), (JodaFormatterSupplier)new JodaFormatterStub())).put((Object)DateTimeStyle.TIME, (Object)new DateTimeTimeFormatter((DateTimeFormatterServiceProvider)new ServiceProviderStub(), (JodaFormatterSupplier)new JodaFormatterStub())).put((Object)DateTimeStyle.DATE_TIME_PICKER, (Object)new DateTimePickerFormatter((DateTimeFormatterServiceProvider)new ServiceProviderStub(), (JodaFormatterSupplier)new JodaFormatterStub())).put((Object)DateTimeStyle.DATE_PICKER, (Object)new DateTimeDatePickerFormatter((DateTimeFormatterServiceProvider)new ServiceProviderStub(), (JodaFormatterSupplier)new JodaFormatterStub())).put((Object)DateTimeStyle.ISO_8601_DATE_TIME, (Object)new DateTimeISO8601DateTimeFormatter((JodaFormatterSupplier)new JodaFormatterStub())).put((Object)DateTimeStyle.RSS_RFC822_DATE_TIME, (Object)new DateTimeRFC822DateTimeFormatter((JodaFormatterSupplier)new JodaFormatterStub())).put((Object)DateTimeStyle.RFC_1123_DATE_TIME, (Object)new DateTimeRFC1123DateTimeFormatter((JodaFormatterSupplier)new JodaFormatterStub())).build();
    }

    public DateTimeFormatterFactoryStub relativeDates(boolean useRelativeDates) {
        this.useRelativeDates = useRelativeDates;
        return this;
    }

    public DateTimeFormatterFactoryStub jiraTimeZone(DateTimeZone timeZone) {
        this.jiraTimeZone = timeZone;
        return this;
    }

    public DateTimeFormatterFactoryStub userTimeZone(DateTimeZone timeZone) {
        this.userTimeZone = timeZone;
        return this;
    }

    public DateTimeFormatterFactoryStub jiraLocale(Locale locale) {
        this.jiraLocale = locale;
        return this;
    }

    public DateTimeFormatterFactoryStub userLocale(Locale locale) {
        this.userLocale = locale;
        return this;
    }

    public DateTimeFormatterFactoryStub style(DateTimeStyle style) {
        this.style = style;
        return this;
    }

    public DateTimeFormatter formatter() {
        return new DateTimeFormatterSupplierStub().getFormatterFor(this.style, (Source<DateTimeZone>)DateTimeFormatterImpl.constant((Object)this.userTimeZone), (Source<Locale>)DateTimeFormatterImpl.constant((Object)this.userLocale));
    }

    private class RelativeDatesAnswer
    implements Answer<Boolean> {
        private RelativeDatesAnswer() {
        }

        public Boolean answer(InvocationOnMock invocation) throws Throwable {
            return DateTimeFormatterFactoryStub.this.useRelativeDates;
        }
    }

    private class DateTimeSettingsStub
    implements DateTimeSettings {
        private DateTimeSettingsStub() {
        }

        public Locale localeFor(@Nullable ApplicationUser user) {
            return user == null ? DateTimeFormatterFactoryStub.this.jiraLocale : DateTimeFormatterFactoryStub.this.userLocale;
        }

        public DateTimeZone timeZoneFor(@Nullable ApplicationUser user) {
            return user == null ? DateTimeFormatterFactoryStub.this.jiraTimeZone : DateTimeFormatterFactoryStub.this.userTimeZone;
        }
    }

    private class DateTimeFormatterSupplierStub
    implements DateTimeFormatterSupplier {
        private DateTimeFormatterSupplierStub() {
        }

        public DateTimeFormatter getFormatterFor(DateTimeStyle style, @Nullable Source<DateTimeZone> timeZone, @Nullable Source<Locale> locale) {
            DateTimeFormatStrategy strategy = (DateTimeFormatStrategy)DateTimeFormatterFactoryStub.this.patterns.get((Object)style);
            if (strategy == null) {
                throw new IllegalStateException(String.format("%s is not supported by %s", style, DateTimeFormatterFactoryStub.class.getSimpleName()));
            }
            return new DateTimeFormatterImpl(strategy, (DateTimeFormatterSupplier)this, (DateTimeSettings)new DateTimeSettingsStub(), DateTimeFormatterFactoryStub.this.jiraAuthenticationContext, timeZone, locale);
        }
    }

    class ServiceProviderStub
    implements DateTimeFormatterServiceProvider {
        ServiceProviderStub() {
        }

        public String getDefaultBackedString(String key) {
            if ("jira.lf.date.time".equals(key)) {
                return "hh:mm a";
            }
            if ("jira.lf.date.day".equals(key)) {
                return "EEEE hh:mm a";
            }
            if ("jira.lf.date.complete".equals(key)) {
                return "dd/MMM/yy hh:mm a";
            }
            if ("jira.lf.date.dmy".equals(key)) {
                return "dd/MMM/yy";
            }
            if ("jira.date.picker.java.format".equals(key)) {
                return "d/MMM/yy";
            }
            throw new IllegalArgumentException(key);
        }

        public String getUnescapedText(String key) {
            if ("common.concepts.today".equals(key)) {
                return "Today {0}";
            }
            if ("common.concepts.yesterday".equals(key)) {
                return "Yesterday {0}";
            }
            throw new IllegalArgumentException();
        }

        public String getText(String key, Object ... parameters) {
            return null;
        }
    }

    class JodaFormatterStub
    implements JodaFormatterSupplier {
        JodaFormatterStub() {
        }

        public org.joda.time.format.DateTimeFormatter get(JodaFormatterSupplier.Key key) {
            return DateTimeFormat.forPattern((String)key.pattern).withLocale(key.locale);
        }
    }
}

