/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.option;

import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class MockOptionsManager
implements OptionsManager {
    private final OptionsTable table = new OptionsTable();

    public Options getOptions(FieldConfig fieldConfig) {
        return new OptionsImpl(this.toOptions(this.table.getRootByConfig(fieldConfig), (Ordering<? super Option>)OptionSorts.sequenceSort()), fieldConfig);
    }

    public void setRootOptions(FieldConfig fieldConfig, Options options) {
        this.removeCustomFieldConfigOptions(fieldConfig);
        int seq = 0;
        for (Option option : options) {
            this.table.create(option.getValue(), null, seq++, fieldConfig);
        }
    }

    public void removeCustomFieldOptions(CustomField customField) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeCustomFieldConfigOptions(FieldConfig fieldConfig) {
        this.table.removeByFieldConfig(fieldConfig);
    }

    public void updateOptions(Collection<Option> options) {
        for (Option option : options) {
            this.store(option);
        }
    }

    public Option createOption(FieldConfig fieldConfig, Long parentOptionId, Long sequence, String value) {
        return this.toOption(this.table.create(value, parentOptionId, sequence, fieldConfig));
    }

    public List<Option> createOptions(FieldConfig config, Long parentOptionId, Long sequence, Iterable<String> options) {
        ArrayList<Option> result = new ArrayList<Option>();
        for (String option : options) {
            Long l = sequence;
            Long l2 = sequence = Long.valueOf(sequence + 1L);
            result.add(this.createOption(config, parentOptionId, l, option));
        }
        return result;
    }

    public void deleteOptionAndChildren(Option option) {
        for (Option child : option.getChildOptions()) {
            this.deleteOptionAndChildren(child);
        }
        this.table.removeById(option.getOptionId());
    }

    public Option findByOptionId(Long optionId) {
        OptionState byId = this.table.getById(optionId);
        return byId == null ? null : this.toOption(byId);
    }

    public List<Option> getAllOptions() {
        return this.toOptions(this.table.getAll(), (Ordering<? super Option>)OptionSorts.valueSort());
    }

    public void enableOption(Option option) {
        option.setDisabled(Boolean.valueOf(false));
        this.store(option);
    }

    public void disableOption(Option option) {
        option.setDisabled(Boolean.valueOf(true));
        this.store(option);
    }

    public void setValue(Option option, String value) {
        option.setValue(value);
        this.store(option);
    }

    public List<Option> findByOptionValue(String value) {
        return this.toOptions(this.table.getByValue(value), (Ordering<? super Option>)OptionSorts.valueSort());
    }

    public List<Option> findByParentId(Long parentOptionId) {
        return this.toOptions(this.table.getByParentId(parentOptionId), (Ordering<? super Option>)OptionSorts.sequenceSort());
    }

    @Nonnull
    public List<Option> getOptions(@Nonnull CustomField field, @Nonnull Collection<Long> projectIds, @Nonnull Collection<String> issueTypeIds) {
        return Collections.emptyList();
    }

    public void store(Option option) {
        this.table.store(option);
    }

    public static List<String> optionsToPaths(Iterable<? extends Option> options) {
        ArrayList stringOptions = Lists.newArrayList();
        for (Option option : options) {
            String value = option.getValue();
            stringOptions.add(value);
            stringOptions.addAll(MockOptionsManager.childOptionsToPaths(value, option));
        }
        return stringOptions;
    }

    private static List<String> childOptionsToPaths(String parentStr, Option option) {
        ArrayList stringOptions = Lists.newArrayList();
        for (Option child : option.getChildOptions()) {
            String childStr = String.format("%s/%s", parentStr, child.getValue());
            stringOptions.add(childStr);
            stringOptions.addAll(MockOptionsManager.childOptionsToPaths(childStr, child));
        }
        return stringOptions;
    }

    private Option toOption(OptionState state) {
        return new OptionImpl(state);
    }

    private List<Option> toOptions(Iterable<OptionState> states, Ordering<? super Option> ordering) {
        return ordering.sortedCopy(this.toIterableOptions(states));
    }

    private Iterable<Option> toIterableOptions(Iterable<OptionState> states) {
        return Iterables.transform(states, (Function)new Function<OptionState, Option>(){

            public Option apply(OptionState input) {
                return MockOptionsManager.this.toOption(input);
            }
        });
    }

    private Option createById(Long id) {
        OptionState state;
        if (id != null && (state = this.table.getById(id)) != null) {
            return new OptionImpl(state);
        }
        return null;
    }

    private List<Option> createByParentId(Long id) {
        return this.toOptions(this.table.getByParentId(id), (Ordering<? super Option>)OptionSorts.sequenceSort());
    }

    private static class OptionSorts {
        public static final Ordering<Option> SEQUENCE_ORDERING = Ordering.natural().onResultOf((Function)new Function<Option, String>(){

            public String apply(Option input) {
                return input.getValue();
            }
        });
        public static final Ordering<Option> VALUE_ORDERING = Ordering.natural().onResultOf((Function)new Function<Option, Long>(){

            public Long apply(Option input) {
                return input.getSequence();
            }
        });

        private OptionSorts() {
        }

        private static Ordering<Option> valueSort() {
            return SEQUENCE_ORDERING;
        }

        private static Ordering<Option> sequenceSort() {
            return VALUE_ORDERING;
        }
    }

    private class OptionsImpl
    implements Options {
        private final List<Option> options;
        private final FieldConfig config;

        private OptionsImpl(List<Option> options, FieldConfig config) {
            this.options = options;
            this.config = config;
        }

        public List<Option> getRootOptions() {
            return this.options;
        }

        public Option getOptionById(Long optionId) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Option getOptionForValue(String value, Long parentOptionId) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Option addOption(Option parent, String value) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void removeOption(Option option) {
            MockOptionsManager.this.deleteOptionAndChildren(option);
        }

        public void moveToStartSequence(Option option) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void incrementSequence(Option option) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void decrementSequence(Option option) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void moveToLastSequence(Option option) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void setValue(Option option, String value) {
            MockOptionsManager.this.setValue(option, value);
        }

        public void enableOption(Option option) {
            MockOptionsManager.this.enableOption(option);
        }

        public void disableOption(Option option) {
            MockOptionsManager.this.disableOption(option);
        }

        public FieldConfig getRelatedFieldConfig() {
            return this.config;
        }

        public void sortOptionsByValue(Option parentOption) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void moveOptionToPosition(Map<Integer, Option> positionsToOptions) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean add(Option option) {
            return this.options.add(option);
        }

        public void add(int index, Option element) {
            this.options.add(index, element);
        }

        public boolean addAll(@Nonnull Collection<? extends Option> c) {
            return this.options.addAll(c);
        }

        public boolean addAll(int index, @Nonnull Collection<? extends Option> c) {
            return this.options.addAll(index, c);
        }

        public void clear() {
            this.options.clear();
        }

        public boolean contains(Object o) {
            return this.options.contains(o);
        }

        public boolean containsAll(@Nonnull Collection<?> c) {
            return this.options.containsAll(c);
        }

        public boolean equals(Object o) {
            return this.options.equals(o);
        }

        public Option get(int index) {
            return this.options.get(index);
        }

        public int hashCode() {
            return this.options.hashCode();
        }

        public int indexOf(Object o) {
            return this.options.indexOf(o);
        }

        public boolean isEmpty() {
            return this.options.isEmpty();
        }

        @Nonnull
        public Iterator<Option> iterator() {
            return this.options.iterator();
        }

        public int lastIndexOf(Object o) {
            return this.options.lastIndexOf(o);
        }

        @Nonnull
        public ListIterator<Option> listIterator() {
            return this.options.listIterator();
        }

        @Nonnull
        public ListIterator<Option> listIterator(int index) {
            return this.options.listIterator(index);
        }

        public Option remove(int index) {
            return this.options.remove(index);
        }

        public boolean remove(Object o) {
            return this.options.remove(o);
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            return this.options.removeAll(c);
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            return this.options.retainAll(c);
        }

        public Option set(int index, Option element) {
            return this.options.set(index, element);
        }

        public int size() {
            return this.options.size();
        }

        @Nonnull
        public List<Option> subList(int fromIndex, int toIndex) {
            return this.options.subList(fromIndex, toIndex);
        }

        @Nonnull
        public Object[] toArray() {
            return this.options.toArray();
        }

        @Nonnull
        public <T> T[] toArray(T[] a) {
            return this.options.toArray(a);
        }
    }

    private class OptionImpl
    implements Option {
        private final Long parentId;
        private final Long id;
        private Long sequence;
        private Boolean disabled;
        private FieldConfig config;
        private String value;
        private Option parent;
        private List<Option> children;

        private OptionImpl(OptionState state) {
            this.id = state.id;
            this.sequence = state.sequence;
            this.disabled = state.disabled;
            this.config = state.config;
            this.value = state.value;
            this.parentId = state.parentId;
        }

        public Long getSequence() {
            return this.sequence;
        }

        public Boolean getDisabled() {
            return this.disabled;
        }

        public GenericValue getGenericValue() {
            throw new UnsupportedOperationException("Not the mock you are looking for.");
        }

        public FieldConfig getRelatedCustomField() {
            return this.config;
        }

        public Option getParentOption() {
            if (this.parent == null && this.parentId != null) {
                this.parent = MockOptionsManager.this.createById(this.parentId);
            }
            return this.parent;
        }

        public void setSequence(Long sequence) {
            this.sequence = sequence;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        public List<Option> retrieveAllChildren(@Nullable List<Option> listToAddTo) {
            if (listToAddTo == null) {
                listToAddTo = Lists.newArrayList();
            }
            List<Option> childOptions = this.getChildOptions();
            for (Option childOption : childOptions) {
                childOptions.add(childOption);
                childOption.retrieveAllChildren((List)listToAddTo);
            }
            return listToAddTo;
        }

        public void store() {
            MockOptionsManager.this.store(this);
        }

        @Nullable
        public Long getOptionId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }

        @Nonnull
        public List<Option> getChildOptions() {
            if (this.children == null) {
                this.children = this.id != null ? MockOptionsManager.this.createByParentId(this.id) : Lists.newArrayList();
            }
            return this.children;
        }
    }

    private static class OptionState {
        private final Long parentId;
        private final long sequence;
        private final Boolean disabled;
        private final FieldConfig config;
        private final String value;
        private final long id;

        private static Iterable<OptionState> orderBySequence(Iterable<OptionState> filter) {
            return Ordering.natural().onResultOf((Function)new Function<OptionState, Long>(){

                public Long apply(OptionState input) {
                    return input.sequence;
                }
            }).sortedCopy(filter);
        }

        private static Predicate<OptionState> fieldConfigPredicate(final FieldConfig config) {
            return new Predicate<OptionState>(){

                public boolean apply(OptionState input) {
                    return config.equals(input.config);
                }
            };
        }

        private static Predicate<OptionState> valuePredicate(final String value) {
            return new Predicate<OptionState>(){

                public boolean apply(OptionState input) {
                    return value.equals(input.value);
                }
            };
        }

        private static Predicate<OptionState> parentPredicate(final Long parentId) {
            return new Predicate<OptionState>(){

                public boolean apply(OptionState input) {
                    return Objects.equal((Object)parentId, (Object)input.parentId);
                }
            };
        }

        private static Predicate<OptionState> isRoot() {
            return new Predicate<OptionState>(){

                public boolean apply(OptionState input) {
                    return input.parentId == null;
                }
            };
        }

        private OptionState(long id, String value, Long parentId, long sequence, FieldConfig config) {
            this.id = id;
            this.value = value;
            this.parentId = parentId;
            this.disabled = false;
            this.config = config;
            this.sequence = sequence;
        }

        private OptionState(Option option) {
            if (option.getOptionId() == null) {
                throw new IllegalArgumentException();
            }
            this.sequence = option.getSequence();
            this.disabled = option.getDisabled();
            this.config = option.getRelatedCustomField();
            this.value = option.getValue();
            this.id = option.getOptionId();
            Option parentOption = option.getParentOption();
            this.parentId = parentOption != null ? parentOption.getOptionId() : null;
        }
    }

    private class OptionsTable {
        private long id = 0L;
        private Map<Long, OptionState> options = Maps.newHashMap();

        private OptionsTable() {
        }

        private Iterable<OptionState> getAll() {
            return this.options.values();
        }

        private OptionState getById(long id) {
            return this.options.get(id);
        }

        private Iterable<OptionState> getByParentId(Long parentId) {
            return OptionState.orderBySequence(Iterables.filter(this.options.values(), (Predicate)OptionState.parentPredicate(parentId)));
        }

        private Iterable<OptionState> getByValue(String value) {
            return Iterables.filter(this.options.values(), (Predicate)OptionState.valuePredicate(value));
        }

        private Iterable<OptionState> getRootByConfig(FieldConfig fieldConfig) {
            return OptionState.orderBySequence(Iterables.filter(this.options.values(), (Predicate)Predicates.and((Predicate)OptionState.isRoot(), (Predicate)OptionState.fieldConfigPredicate(fieldConfig))));
        }

        private void removeByFieldConfig(FieldConfig fieldConfig) {
            Iterator<OptionState> iterator = this.options.values().iterator();
            while (iterator.hasNext()) {
                OptionState next = iterator.next();
                if (!fieldConfig.equals(next.config)) continue;
                iterator.remove();
            }
        }

        private long nextId() {
            return this.id++;
        }

        private OptionState create(String value, Long parentId, long sequence, FieldConfig config) {
            OptionState optionState = new OptionState(this.nextId(), value, parentId, sequence, config);
            this.options.put(optionState.id, optionState);
            return optionState;
        }

        private OptionState store(Option option) {
            if (option.getOptionId() == null) {
                throw new IllegalArgumentException("Option was not previously stored.");
            }
            OptionState value = new OptionState(option);
            this.options.put(option.getOptionId(), value);
            return value;
        }

        private void removeById(Long optionId) {
            this.options.remove(optionId);
        }
    }
}

