/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.option;

import com.atlassian.jira.issue.customfields.option.SimpleOption;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MockSimpleOption
implements SimpleOption<MockSimpleOption> {
    private static final Function<SimpleOption<?>, MockSimpleOption> TO_MOCK = new Function<SimpleOption<?>, MockSimpleOption>(){

        public MockSimpleOption apply(SimpleOption<?> input) {
            return new MockSimpleOption(input);
        }
    };
    private Long id;
    private String value;
    private List<MockSimpleOption> options = Lists.newArrayList();
    private MockSimpleOption parent;

    public static Function<SimpleOption<?>, MockSimpleOption> toMock() {
        return TO_MOCK;
    }

    public MockSimpleOption() {
    }

    public MockSimpleOption(SimpleOption<?> option) {
        this.id = option.getOptionId();
        this.value = option.getValue();
        for (SimpleOption child : option.getChildOptions()) {
            MockSimpleOption childMock = new MockSimpleOption(child);
            childMock.parent = this;
            this.options.add(childMock);
        }
    }

    @Nullable
    public Long getOptionId() {
        return this.id;
    }

    public MockSimpleOption setId(Long id) {
        this.id = id;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public MockSimpleOption setValue(String value) {
        this.value = value;
        return this;
    }

    @Nonnull
    public List<MockSimpleOption> getChildOptions() {
        return this.options;
    }

    public MockSimpleOption parent() {
        return this.parent;
    }

    public MockSimpleOption parent(MockSimpleOption parent) {
        this.parent = parent;
        return this;
    }

    public MockSimpleOption addChild(String value) {
        MockSimpleOption mockSimpleOption = new MockSimpleOption().setValue(value).parent(this);
        this.options.add(mockSimpleOption);
        return mockSimpleOption;
    }

    public String toString() {
        return String.format("Option[%s, id: %d, children: %s]", this.getValue(), this.getOptionId(), this.getChildOptions());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockSimpleOption that = (MockSimpleOption)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(that.options) : that.options != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        return result;
    }
}

